/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc16;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAmbientDepthFilterEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNDiffCallback;
import org.tmatesoft.svn.core.internal.wc.SVNDiffEditor;
import org.tmatesoft.svn.core.internal.wc.SVNDiffStatusEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver;
import org.tmatesoft.svn.core.internal.wc.SVNRemoteDiffEditor;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNReporter;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatch;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchTarget;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffStatusHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDiffClient16
extends SVNMergeDriver {
    private ISVNDiffGenerator myDiffGenerator;
    private SVNDiffOptions myDiffOptions;

    public SVNDiffClient16(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNDiffClient16(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public void setDiffGenerator(ISVNDiffGenerator diffGenerator) {
        this.myDiffGenerator = diffGenerator;
    }

    public ISVNDiffGenerator getDiffGenerator() {
        return this.myDiffGenerator;
    }

    public void setMergeOptions(SVNDiffOptions diffOptions) {
        this.myDiffOptions = diffOptions;
    }

    @Override
    public SVNDiffOptions getMergeOptions() {
        if (this.myDiffOptions == null) {
            this.myDiffOptions = new SVNDiffOptions();
        }
        return this.myDiffOptions;
    }

    public void doDiff(SVNURL url, SVNRevision pegRevision, SVNRevision rN, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        this.doDiff(url, pegRevision, rN, rM, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, result);
    }

    public void doDiff(SVNURL url, SVNRevision pegRevision, SVNRevision rN, SVNRevision rM, SVNDepth depth, boolean useAncestry, OutputStream result) throws SVNException {
        SVNErrorMessage err;
        if (!rN.isValid() || !rM.isValid()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (rN.isLocal() || rM.isLocal()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions must be non-local for a pegged diff of an URL");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        this.getDiffGenerator().init(url.toString(), url.toString());
        this.doDiffURLURL(url, null, rN, url, null, rM, pegRevision, depth, useAncestry, result);
    }

    public void doDiff(File path, SVNRevision pegRevision, SVNRevision rN, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        this.doDiff(path, pegRevision, rN, rM, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, result, null);
    }

    public void doDiff(File[] paths, SVNRevision rN, SVNRevision rM, SVNRevision pegRevision, SVNDepth depth, boolean useAncestry, OutputStream result, Collection changeLists) throws SVNException {
        if (paths == null) {
            return;
        }
        for (int i = 0; i < paths.length; ++i) {
            File path = paths[i];
            try {
                this.doDiff(path, pegRevision, rN, rM, depth, useAncestry, result, changeLists);
                continue;
            }
            catch (SVNException svne) {
                this.dispatchEvent(SVNEventFactory.createErrorEvent(svne.getErrorMessage(), null));
            }
        }
    }

    public void doDiff(File path, SVNRevision pegRevision, SVNRevision rN, SVNRevision rM, SVNDepth depth, boolean useAncestry, OutputStream result, Collection changeLists) throws SVNException {
        boolean rMisLocal;
        if (!rN.isValid() || !rM.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        boolean rNisLocal = rN == SVNRevision.BASE || rN == SVNRevision.WORKING;
        boolean bl = rMisLocal = rM == SVNRevision.BASE || rM == SVNRevision.WORKING;
        if (rNisLocal && rMisLocal) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "At least one revision must be non-local for a pegged diff");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        path = path.getAbsoluteFile();
        this.getDiffGenerator().init(path.getAbsolutePath(), path.getAbsolutePath());
        if (rM != SVNRevision.BASE && rM != SVNRevision.WORKING && rM != SVNRevision.COMMITTED) {
            if (rN == SVNRevision.BASE || rN == SVNRevision.WORKING || rN == SVNRevision.COMMITTED) {
                this.doDiffURLWC(path, rM, pegRevision, path, rN, true, depth, useAncestry, result, changeLists);
            } else {
                this.doDiffURLURL(null, path, rN, null, path, rM, pegRevision, depth, useAncestry, result);
            }
        } else {
            this.doDiffURLWC(path, rN, pegRevision, path, rM, false, depth, useAncestry, result, changeLists);
        }
    }

    public void doDiff(SVNURL url1, SVNRevision rN, SVNURL url2, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        this.doDiff(url1, rN, url2, rM, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, result);
    }

    public void doDiff(SVNURL url1, SVNRevision rN, SVNURL url2, SVNRevision rM, SVNDepth depth, boolean useAncestry, OutputStream result) throws SVNException {
        if (!rN.isValid() || !rM.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        this.getDiffGenerator().init(url1.toString(), url2.toString());
        this.doDiffURLURL(url1, null, rN, url2, null, rM, SVNRevision.UNDEFINED, depth, useAncestry, result);
    }

    public void doDiff(File path1, SVNRevision rN, SVNURL url2, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        this.doDiff(path1, rN, url2, rM, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, result, null);
    }

    public void doDiff(File path1, SVNRevision rN, SVNURL url2, SVNRevision rM, SVNDepth depth, boolean useAncestry, OutputStream result, Collection changeLists) throws SVNException {
        if (!rN.isValid() || !rM.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        this.getDiffGenerator().init(path1.getAbsolutePath(), url2.toString());
        if (rN == SVNRevision.BASE || rN == SVNRevision.WORKING) {
            this.doDiffURLWC(url2, rM, SVNRevision.UNDEFINED, path1, rN, true, depth, useAncestry, result, changeLists);
        } else {
            this.doDiffURLURL(null, path1, rN, url2, null, rM, SVNRevision.UNDEFINED, depth, useAncestry, result);
        }
    }

    public void doDiff(SVNURL url1, SVNRevision rN, File path2, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        this.doDiff(url1, rN, path2, rM, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, result, null);
    }

    public void doDiff(SVNURL url1, SVNRevision rN, File path2, SVNRevision rM, SVNDepth depth, boolean useAncestry, OutputStream result, Collection changeLists) throws SVNException {
        if (!rN.isValid() || !rM.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        this.getDiffGenerator().init(url1.toString(), path2.getAbsolutePath());
        if (rM == SVNRevision.BASE || rM == SVNRevision.WORKING) {
            this.doDiffURLWC(url1, rN, SVNRevision.UNDEFINED, path2, rM, false, depth, useAncestry, result, changeLists);
        } else {
            this.doDiffURLURL(url1, null, rN, null, path2, rM, SVNRevision.UNDEFINED, depth, useAncestry, result);
        }
    }

    public void doDiff(File path1, SVNRevision rN, File path2, SVNRevision rM, boolean recursive, boolean useAncestry, OutputStream result) throws SVNException {
        this.doDiff(path1, rN, path2, rM, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, result, null);
    }

    public void doDiff(File path1, SVNRevision rN, File path2, SVNRevision rM, SVNDepth depth, boolean useAncestry, OutputStream result, Collection changeLists) throws SVNException {
        if (!rN.isValid() || !rM.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        boolean isPath1Local = rN == SVNRevision.WORKING || rN == SVNRevision.BASE;
        boolean isPath2Local = rM == SVNRevision.WORKING || rM == SVNRevision.BASE;
        this.getDiffGenerator().init(path1.getAbsolutePath(), path2.getAbsolutePath());
        if (isPath1Local && isPath2Local) {
            this.doDiffWCWC(path1, rN, path2, rM, depth, useAncestry, result, changeLists);
        } else if (isPath1Local) {
            this.doDiffURLWC(path2, rM, SVNRevision.UNDEFINED, path1, rN, true, depth, useAncestry, result, changeLists);
        } else if (isPath2Local) {
            this.doDiffURLWC(path1, rN, SVNRevision.UNDEFINED, path2, rM, false, depth, useAncestry, result, changeLists);
        } else {
            this.doDiffURLURL(null, path1, rN, null, path2, rM, SVNRevision.UNDEFINED, depth, useAncestry, result);
        }
    }

    public void doDiffStatus(File path1, SVNRevision rN, File path2, SVNRevision rM, boolean recursive, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        this.doDiffStatus(path1, rN, path2, rM, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, handler);
    }

    public void doDiffStatus(File path, SVNRevision rN, SVNRevision rM, SVNRevision pegRevision, SVNDepth depth, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        boolean isPath2Local;
        if (handler == null) {
            return;
        }
        if (pegRevision == null) {
            pegRevision = SVNRevision.UNDEFINED;
        }
        if (!rN.isValid() || !rM.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        boolean isPath1Local = rN == SVNRevision.WORKING || rN == SVNRevision.BASE;
        boolean bl = isPath2Local = rM == SVNRevision.WORKING || rM == SVNRevision.BASE;
        if (isPath1Local || isPath2Local) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Summarizing diff can only compare repository to repository");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        this.doDiffURLURL(null, path, rN, null, path, rM, pegRevision, depth, useAncestry, handler);
    }

    public void doDiffStatus(File path1, SVNRevision rN, File path2, SVNRevision rM, SVNDepth depth, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        boolean isPath2Local;
        if (handler == null) {
            return;
        }
        if (!rN.isValid() || !rM.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        boolean isPath1Local = rN == SVNRevision.WORKING || rN == SVNRevision.BASE;
        boolean bl = isPath2Local = rM == SVNRevision.WORKING || rM == SVNRevision.BASE;
        if (isPath1Local || isPath2Local) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Summarizing diff can only compare repository to repository");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        this.doDiffURLURL(null, path1, rN, null, path2, rM, SVNRevision.UNDEFINED, depth, useAncestry, handler);
    }

    public void doDiffStatus(File path1, SVNRevision rN, SVNURL url2, SVNRevision rM, boolean recursive, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        this.doDiffStatus(path1, rN, url2, rM, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, handler);
    }

    public void doDiffStatus(File path1, SVNRevision rN, SVNURL url2, SVNRevision rM, SVNDepth depth, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        SVNErrorMessage err;
        if (handler == null) {
            return;
        }
        if (!rN.isValid() || !rM.isValid()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (rN == SVNRevision.BASE || rN == SVNRevision.WORKING) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Summarizing diff can only compare repository to repository");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        } else {
            this.doDiffURLURL(null, path1, rN, url2, null, rM, SVNRevision.UNDEFINED, depth, useAncestry, handler);
        }
    }

    public void doDiffStatus(SVNURL url1, SVNRevision rN, File path2, SVNRevision rM, boolean recursive, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        this.doDiffStatus(url1, rN, path2, rM, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, handler);
    }

    public void doDiffStatus(SVNURL url1, SVNRevision rN, File path2, SVNRevision rM, SVNDepth depth, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        SVNErrorMessage err;
        if (handler == null) {
            return;
        }
        if (!rN.isValid() || !rM.isValid()) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (rM == SVNRevision.BASE || rM == SVNRevision.WORKING) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Summarizing diff can only compare repository to repository");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        } else {
            this.doDiffURLURL(url1, null, rN, null, path2, rM, SVNRevision.UNDEFINED, depth, useAncestry, handler);
        }
    }

    public void doDiffStatus(SVNURL url1, SVNRevision rN, SVNURL url2, SVNRevision rM, boolean recursive, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        this.doDiffStatus(url1, rN, url2, rM, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, handler);
    }

    public void doDiffStatus(SVNURL url, SVNRevision rN, SVNRevision rM, SVNRevision pegRevision, SVNDepth depth, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        if (handler == null) {
            return;
        }
        if (pegRevision == null) {
            pegRevision = SVNRevision.UNDEFINED;
        }
        if (!rN.isValid() || !rM.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        this.doDiffURLURL(url, null, rN, url, null, rM, pegRevision, depth, useAncestry, handler);
    }

    public void doDiffStatus(SVNURL url1, SVNRevision rN, SVNURL url2, SVNRevision rM, SVNDepth depth, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        if (handler == null) {
            return;
        }
        if (!rN.isValid() || !rM.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        this.doDiffURLURL(url1, null, rN, url2, null, rM, SVNRevision.UNDEFINED, depth, useAncestry, handler);
    }

    public void doMerge(File path1, SVNRevision revision1, File path2, SVNRevision revision2, File dstPath, boolean recursive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        this.doMerge(path1, revision1, path2, revision2, dstPath, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, force, dryRun, false);
    }

    public void doMerge(File path1, SVNRevision revision1, File path2, SVNRevision revision2, File dstPath, SVNDepth depth, boolean useAncestry, boolean force, boolean dryRun, boolean recordOnly) throws SVNException {
        SVNURL url2;
        path1 = path1.getAbsoluteFile();
        path2 = path2.getAbsoluteFile();
        dstPath = dstPath.getAbsoluteFile();
        SVNURL url1 = this.getURL(path1);
        if (url1 == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)path1);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ((url2 = this.getURL(path2)) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)path2);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        this.runMerge(url1, revision1, url2, revision2, dstPath, depth, dryRun, force, !useAncestry, recordOnly);
    }

    public void doMerge(File path1, SVNRevision revision1, SVNURL url2, SVNRevision revision2, File dstPath, boolean recursive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        this.doMerge(path1, revision1, url2, revision2, dstPath, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, force, dryRun, false);
    }

    public void doMerge(File path1, SVNRevision revision1, SVNURL url2, SVNRevision revision2, File dstPath, SVNDepth depth, boolean useAncestry, boolean force, boolean dryRun, boolean recordOnly) throws SVNException {
        path1 = path1.getAbsoluteFile();
        dstPath = dstPath.getAbsoluteFile();
        SVNURL url1 = this.getURL(path1);
        if (url1 == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)path1);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        this.runMerge(url1, revision1, url2, revision2, dstPath, depth, dryRun, force, !useAncestry, recordOnly);
    }

    public void doMerge(SVNURL url1, SVNRevision revision1, File path2, SVNRevision revision2, File dstPath, boolean recursive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        this.doMerge(url1, revision1, path2, revision2, dstPath, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, force, dryRun, false);
    }

    public void doMerge(SVNURL url1, SVNRevision revision1, File path2, SVNRevision revision2, File dstPath, SVNDepth depth, boolean useAncestry, boolean force, boolean dryRun, boolean recordOnly) throws SVNException {
        path2 = path2.getAbsoluteFile();
        dstPath = dstPath.getAbsoluteFile();
        SVNURL url2 = this.getURL(path2);
        if (url2 == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)path2);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        this.runMerge(url1, revision1, url2, revision2, dstPath, depth, dryRun, force, !useAncestry, recordOnly);
    }

    public void doMerge(SVNURL url1, SVNRevision revision1, SVNURL url2, SVNRevision revision2, File dstPath, boolean recursive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        this.doMerge(url1, revision1, url2, revision2, dstPath, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, force, dryRun, false);
    }

    public void doMerge(SVNURL url1, SVNRevision revision1, SVNURL url2, SVNRevision revision2, File dstPath, SVNDepth depth, boolean useAncestry, boolean force, boolean dryRun, boolean recordOnly) throws SVNException {
        this.runMerge(url1, revision1, url2, revision2, dstPath, depth, dryRun, force, !useAncestry, recordOnly);
    }

    public void doMerge(SVNURL url1, SVNRevision pegRevision, SVNRevision revision1, SVNRevision revision2, File dstPath, boolean recursive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        SVNRevisionRange range = new SVNRevisionRange(revision1, revision2);
        LinkedList<SVNRevisionRange> rangesToMerge = new LinkedList<SVNRevisionRange>();
        rangesToMerge.add(range);
        this.doMerge(url1, pegRevision, rangesToMerge, dstPath, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, force, dryRun, false);
    }

    public void doMerge(SVNURL url1, SVNRevision pegRevision, Collection rangesToMerge, File dstPath, SVNDepth depth, boolean useAncestry, boolean force, boolean dryRun, boolean recordOnly) throws SVNException {
        if (pegRevision == null || !pegRevision.isValid()) {
            pegRevision = SVNRevision.HEAD;
        }
        this.runPeggedMerge(url1, null, rangesToMerge, pegRevision, dstPath, depth, dryRun, force, !useAncestry, recordOnly);
    }

    public void doMerge(File path1, SVNRevision pegRevision, SVNRevision revision1, SVNRevision revision2, File dstPath, boolean recursive, boolean useAncestry, boolean force, boolean dryRun) throws SVNException {
        SVNRevisionRange range = new SVNRevisionRange(revision1, revision2);
        LinkedList<SVNRevisionRange> rangesToMerge = new LinkedList<SVNRevisionRange>();
        rangesToMerge.add(range);
        this.doMerge(path1, pegRevision, rangesToMerge, dstPath, SVNDepth.getInfinityOrFilesDepth(recursive), useAncestry, force, dryRun, false);
    }

    public void doMerge(File path1, SVNRevision pegRevision, Collection rangesToMerge, File dstPath, SVNDepth depth, boolean useAncestry, boolean force, boolean dryRun, boolean recordOnly) throws SVNException {
        if (pegRevision == null || !pegRevision.isValid()) {
            pegRevision = SVNRevision.WORKING;
        }
        this.runPeggedMerge(null, path1, rangesToMerge, pegRevision, dstPath, depth, dryRun, force, !useAncestry, recordOnly);
    }

    public void doMergeReIntegrate(File srcPath, SVNRevision pegRevision, File dstPath, boolean dryRun) throws SVNException {
        if (pegRevision == null || !pegRevision.isValid()) {
            pegRevision = SVNRevision.WORKING;
        }
        this.runMergeReintegrate(null, srcPath, pegRevision, dstPath, dryRun);
    }

    public void doMergeReIntegrate(SVNURL srcURL, SVNRevision pegRevision, File dstPath, boolean dryRun) throws SVNException {
        if (pegRevision == null || !pegRevision.isValid()) {
            pegRevision = SVNRevision.HEAD;
        }
        this.runMergeReintegrate(srcURL, null, pegRevision, dstPath, dryRun);
    }

    public void doGetLogMergedMergeInfo(File path, SVNRevision pegRevision, SVNURL mergeSrcURL, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        this.getLogMergedMergeInfoImpl(path, null, pegRevision, mergeSrcURL, null, srcPegRevision, discoverChangedPaths, revisionProperties, handler);
    }

    public void doGetLogMergedMergeInfo(SVNURL url, SVNRevision pegRevision, SVNURL mergeSrcURL, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        this.getLogMergedMergeInfoImpl(null, url, pegRevision, mergeSrcURL, null, srcPegRevision, discoverChangedPaths, revisionProperties, handler);
    }

    public void doGetLogMergedMergeInfo(File path, SVNRevision pegRevision, File mergeSrcPath, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        this.getLogMergedMergeInfoImpl(path, null, pegRevision, null, mergeSrcPath, srcPegRevision, discoverChangedPaths, revisionProperties, handler);
    }

    public void doGetLogMergedMergeInfo(SVNURL url, SVNRevision pegRevision, File mergeSrcPath, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        this.getLogMergedMergeInfoImpl(null, url, pegRevision, null, mergeSrcPath, srcPegRevision, discoverChangedPaths, revisionProperties, handler);
    }

    public void doGetLogEligibleMergeInfo(File path, SVNRevision pegRevision, SVNURL mergeSrcURL, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        this.getLogEligibleMergeInfoImpl(path, null, pegRevision, mergeSrcURL, null, srcPegRevision, discoverChangedPaths, revisionProperties, handler);
    }

    public void doGetLogEligibleMergeInfo(SVNURL url, SVNRevision pegRevision, SVNURL mergeSrcURL, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        this.getLogEligibleMergeInfoImpl(null, url, pegRevision, mergeSrcURL, null, srcPegRevision, discoverChangedPaths, revisionProperties, handler);
    }

    public void doGetLogEligibleMergeInfo(File path, SVNRevision pegRevision, File mergeSrcPath, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        this.getLogEligibleMergeInfoImpl(path, null, pegRevision, null, mergeSrcPath, srcPegRevision, discoverChangedPaths, revisionProperties, handler);
    }

    public void doGetLogEligibleMergeInfo(SVNURL url, SVNRevision pegRevision, File mergeSrcPath, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        this.getLogEligibleMergeInfoImpl(null, url, pegRevision, null, mergeSrcPath, srcPegRevision, discoverChangedPaths, revisionProperties, handler);
    }

    public Map<SVNURL, SVNMergeRangeList> doGetMergedMergeInfo(File path, SVNRevision pegRevision) throws SVNException {
        SVNURL[] reposRoot = new SVNURL[1];
        TreeMap<SVNURL, SVNMergeRangeList> mergeInfo = this.getMergeInfo(path, pegRevision, reposRoot);
        SVNURL repositoryRoot = reposRoot[0];
        if (mergeInfo != null) {
            TreeMap<SVNURL, SVNMergeRangeList> fullPathMergeInfo = new TreeMap<SVNURL, SVNMergeRangeList>(new Comparator<SVNURL>(){

                @Override
                public int compare(SVNURL o1, SVNURL o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            for (String mergeSrcPath : mergeInfo.keySet()) {
                SVNMergeRangeList rangeList = (SVNMergeRangeList)mergeInfo.get(mergeSrcPath);
                if (mergeSrcPath.startsWith("/")) {
                    mergeSrcPath = mergeSrcPath.substring(1);
                }
                SVNURL url = repositoryRoot.appendPath(mergeSrcPath, false);
                fullPathMergeInfo.put(url, rangeList);
            }
            mergeInfo = fullPathMergeInfo;
        }
        return mergeInfo;
    }

    public Map<SVNURL, SVNMergeRangeList> doGetMergedMergeInfo(SVNURL url, SVNRevision pegRevision) throws SVNException {
        SVNURL[] reposRoot = new SVNURL[1];
        TreeMap<SVNURL, SVNMergeRangeList> mergeInfo = this.getMergeInfo(url, pegRevision, reposRoot);
        SVNURL repositoryRoot = reposRoot[0];
        if (mergeInfo != null) {
            TreeMap<SVNURL, SVNMergeRangeList> fullPathMergeInfo = new TreeMap<SVNURL, SVNMergeRangeList>(new Comparator<SVNURL>(){

                @Override
                public int compare(SVNURL o1, SVNURL o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            for (String mergeSrcPath : mergeInfo.keySet()) {
                SVNMergeRangeList rangeList = (SVNMergeRangeList)mergeInfo.get(mergeSrcPath);
                if (mergeSrcPath.startsWith("/")) {
                    mergeSrcPath = mergeSrcPath.substring(1);
                }
                SVNURL nextURL = repositoryRoot.appendPath(mergeSrcPath, false);
                fullPathMergeInfo.put(nextURL, rangeList);
            }
            mergeInfo = fullPathMergeInfo;
        }
        return mergeInfo;
    }

    public Collection<SVNURL> doSuggestMergeSources(File path, SVNRevision pegRevision) throws SVNException {
        Map<SVNURL, SVNMergeRangeList> mergeInfo;
        LinkedList<SVNURL> suggestions = new LinkedList<SVNURL>();
        SVNURL reposRoot = this.getReposRoot(path, null, pegRevision, null, null);
        SVNLocationEntry copyFromInfo = this.getCopySource(path, null, pegRevision);
        String copyFromPath = copyFromInfo.getPath();
        SVNURL copyFromURL = null;
        if (copyFromPath != null) {
            String relCopyFromPath = copyFromPath.startsWith("/") ? copyFromPath.substring(1) : copyFromPath;
            copyFromURL = reposRoot.appendPath(relCopyFromPath, false);
            suggestions.add(copyFromURL);
        }
        if ((mergeInfo = this.doGetMergedMergeInfo(path, pegRevision)) != null) {
            for (SVNURL mergeSrcURL : mergeInfo.keySet()) {
                if (copyFromURL != null && copyFromURL.equals(mergeSrcURL)) continue;
                suggestions.add(mergeSrcURL);
            }
        }
        return suggestions;
    }

    public Collection<SVNURL> doSuggestMergeSources(SVNURL url, SVNRevision pegRevision) throws SVNException {
        Map<SVNURL, SVNMergeRangeList> mergeInfo;
        LinkedList<SVNURL> suggestions = new LinkedList<SVNURL>();
        SVNURL reposRoot = this.getReposRoot(null, url, pegRevision, null, null);
        SVNLocationEntry copyFromInfo = this.getCopySource(null, url, pegRevision);
        String copyFromPath = copyFromInfo.getPath();
        SVNURL copyFromURL = null;
        if (copyFromPath != null) {
            String relCopyFromPath = copyFromPath.startsWith("/") ? copyFromPath.substring(1) : copyFromPath;
            copyFromURL = reposRoot.appendPath(relCopyFromPath, false);
            suggestions.add(copyFromURL);
        }
        if ((mergeInfo = this.doGetMergedMergeInfo(url, pegRevision)) != null) {
            for (SVNURL mergeSrcURL : mergeInfo.keySet()) {
                if (copyFromURL != null && copyFromURL.equals(mergeSrcURL)) continue;
                suggestions.add(mergeSrcURL);
            }
        }
        return suggestions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffURLWC(SVNURL url1, SVNRevision revision1, SVNRevision pegRevision, File path2, SVNRevision revision2, boolean reverse, SVNDepth depth, boolean useAncestry, OutputStream result, Collection changeLists) throws SVNException {
        try (SVNWCAccess wcAccess = this.createWCAccess();){
            SVNAdminAreaInfo info = wcAccess.openAnchor(path2, false, SVNDepth.recurseFromDepth(depth) ? -1 : 0);
            File anchorPath = info.getAnchor().getRoot();
            String target = "".equals(info.getTargetName()) ? null : info.getTargetName();
            SVNEntry anchorEntry = info.getAnchor().getVersionedEntry("", false);
            if (anchorEntry.getURL() == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)anchorPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            SVNURL anchorURL = anchorEntry.getSVNURL();
            if (pegRevision.isValid()) {
                SVNBasicDelegate.SVNRepositoryLocation[] locations = this.getLocations(url1, null, null, pegRevision, revision1, SVNRevision.UNDEFINED);
                url1 = locations[0].getURL();
                String anchorPath2 = SVNPathUtil.append(anchorURL.toString(), target == null ? "" : target);
                this.getDiffGenerator().init(url1.toString(), anchorPath2);
            }
            SVNRepository repository = this.createRepository(anchorURL, null, null, true);
            long revNumber = this.getRevisionNumber(revision1, repository, null);
            SVNDiffCallback callback = new SVNDiffCallback(info.getAnchor(), this.getDiffGenerator(), reverse ? -1L : revNumber, reverse ? revNumber : -1L, result);
            SVNDiffEditor editor = new SVNDiffEditor(wcAccess, info, callback, useAncestry, reverse, revision2 == SVNRevision.BASE || revision2 == SVNRevision.COMMITTED, depth, changeLists);
            boolean serverSupportsDepth = repository.hasCapability(SVNCapability.DEPTH);
            SVNReporter reporter = new SVNReporter(info, info.getAnchor().getFile(info.getTargetName()), false, !serverSupportsDepth, depth, false, false, true, this.getDebugLog());
            long pegRevisionNumber = this.getRevisionNumber(revision2, repository, path2);
            try {
                repository.diff(url1, revNumber, pegRevisionNumber, target, !useAncestry, depth, true, (ISVNReporterBaton)reporter, SVNCancellableEditor.newInstance(editor, this, this.getDebugLog()));
            }
            finally {
                editor.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffURLWC(File path1, SVNRevision revision1, SVNRevision pegRevision, File path2, SVNRevision revision2, boolean reverse, SVNDepth depth, boolean useAncestry, OutputStream result, Collection changeLists) throws SVNException {
        try (SVNWCAccess wcAccess = this.createWCAccess();){
            SVNURL url1;
            int admDepth = this.getAdminDepth(depth);
            SVNAdminAreaInfo info = wcAccess.openAnchor(path2, false, admDepth);
            File anchorPath = info.getAnchor().getRoot();
            String target = "".equals(info.getTargetName()) ? null : info.getTargetName();
            SVNEntry anchorEntry = info.getAnchor().getVersionedEntry("", false);
            if (anchorEntry.getURL() == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)anchorPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            SVNURL anchorURL = anchorEntry.getSVNURL();
            if (pegRevision.isValid()) {
                SVNBasicDelegate.SVNRepositoryLocation[] locations = this.getLocations(null, path1, null, pegRevision, revision1, SVNRevision.UNDEFINED);
                url1 = locations[0].getURL();
                String anchorPath2 = SVNPathUtil.append(anchorURL.toString(), target == null ? "" : target);
                if (!reverse) {
                    this.getDiffGenerator().init(url1.toString(), anchorPath2);
                } else {
                    this.getDiffGenerator().init(anchorPath2, url1.toString());
                }
            } else {
                url1 = this.getURL(path1);
            }
            SVNRepository repository = this.createRepository(anchorURL, null, null, true);
            long revNumber = this.getRevisionNumber(revision1, repository, path1);
            SVNDiffCallback callback = new SVNDiffCallback(info.getAnchor(), this.getDiffGenerator(), reverse ? -1L : revNumber, reverse ? revNumber : -1L, result);
            SVNDiffEditor editor = new SVNDiffEditor(wcAccess, info, callback, useAncestry, reverse, revision2 == SVNRevision.BASE || revision2 == SVNRevision.COMMITTED, depth, changeLists);
            ISVNEditor filterEditor = SVNAmbientDepthFilterEditor.wrap(editor, info, false);
            boolean serverSupportsDepth = repository.hasCapability(SVNCapability.DEPTH);
            SVNReporter reporter = new SVNReporter(info, info.getAnchor().getFile(info.getTargetName()), false, !serverSupportsDepth, depth, false, false, true, this.getDebugLog());
            long pegRevisionNumber = this.getRevisionNumber(revision2, repository, path2);
            try {
                repository.diff(url1, revNumber, pegRevisionNumber, target, !useAncestry, depth, true, (ISVNReporterBaton)reporter, SVNCancellableEditor.newInstance(filterEditor, this, this.getDebugLog()));
            }
            finally {
                editor.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffWCWC(File path1, SVNRevision revision1, File path2, SVNRevision revision2, SVNDepth depth, boolean useAncestry, OutputStream result, Collection changeLists) throws SVNException {
        if (!path1.equals(path2) || revision1 != SVNRevision.BASE || revision2 != SVNRevision.WORKING) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Only diffs between a path's text-base and its working files are supported at this time (-rBASE:WORKING)");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        try (SVNWCAccess wcAccess = this.createWCAccess();){
            int admDepth = this.getAdminDepth(depth);
            SVNAdminAreaInfo info = wcAccess.openAnchor(path1, false, admDepth);
            wcAccess.getVersionedEntry(path1, false);
            long rev = this.getRevisionNumber(revision1, null, path1);
            SVNDiffCallback callback = new SVNDiffCallback(info.getAnchor(), this.getDiffGenerator(), rev, -1L, result);
            SVNDiffEditor editor = new SVNDiffEditor(wcAccess, info, callback, useAncestry, false, false, depth, changeLists);
            try {
                editor.closeEdit();
            }
            finally {
                editor.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffURLURL(SVNURL url1, File path1, SVNRevision revision1, SVNURL url2, File path2, SVNRevision revision2, SVNRevision pegRevision, SVNDepth depth, boolean useAncestry, OutputStream result) throws SVNException {
        File basePath = null;
        if (path1 != null) {
            basePath = path1;
        }
        if (path2 != null) {
            basePath = path2;
        }
        if (pegRevision.isValid()) {
            SVNBasicDelegate.SVNRepositoryLocation[] locations = this.getLocations(url2, path2, null, pegRevision, revision1, revision2);
            url1 = locations[0].getURL();
            url2 = locations[1].getURL();
            this.getDiffGenerator().init(url1.toString(), url2.toString());
        } else {
            url1 = url1 == null ? this.getURL(path1) : url1;
            url2 = url2 == null ? this.getURL(path2) : url2;
        }
        SVNRepository repository1 = this.createRepository(url1, null, null, true);
        SVNRepository repository2 = this.createRepository(url2, null, null, false);
        final long rev1 = this.getRevisionNumber(revision1, repository1, path1);
        long rev2 = -1L;
        String target1 = null;
        SVNNodeKind kind1 = null;
        SVNNodeKind kind2 = null;
        try {
            SVNErrorMessage err;
            rev2 = this.getRevisionNumber(revision2, repository2, path2);
            kind1 = repository1.checkPath("", rev1);
            kind2 = repository2.checkPath("", rev2);
            if (kind1 == SVNNodeKind.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' was not found in the repository at revision {1}", url1, new Long(rev1));
                SVNErrorManager.error(err, SVNLogType.WC);
            } else if (kind2 == SVNNodeKind.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' was not found in the repository at revision {1}", url2, new Long(rev2));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        finally {
            repository2.closeSession();
        }
        if (kind1 == SVNNodeKind.FILE || kind2 == SVNNodeKind.FILE) {
            target1 = SVNPathUtil.tail(url1.getPath());
            if (basePath != null) {
                basePath = basePath.getParentFile();
            }
            url1 = SVNURL.parseURIEncoded(SVNPathUtil.removeTail(url1.toString()));
            repository1 = this.createRepository(url1, null, null, true);
        }
        repository2 = this.createRepository(url1, null, null, false);
        SVNRemoteDiffEditor editor = null;
        try {
            SVNDiffCallback callback = new SVNDiffCallback(null, this.getDiffGenerator(), rev1, rev2, result);
            callback.setBasePath(basePath);
            editor = new SVNRemoteDiffEditor(null, null, callback, repository2, rev1, rev2, false, null, this);
            editor.setUseGlobalTmp(true);
            ISVNReporterBaton reporter = new ISVNReporterBaton(){

                @Override
                public void report(ISVNReporter reporter) throws SVNException {
                    reporter.setPath("", null, rev1, SVNDepth.INFINITY, false);
                    reporter.finishReport();
                }
            };
            repository1.diff(url2, rev2, rev1, target1, !useAncestry, depth, true, reporter, SVNCancellableEditor.newInstance(editor, this, this.getDebugLog()));
        }
        finally {
            if (editor != null) {
                editor.cleanup();
            }
            repository2.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffURLURL(SVNURL url1, File path1, SVNRevision revision1, SVNURL url2, File path2, SVNRevision revision2, SVNRevision pegRevision, SVNDepth depth, boolean useAncestry, ISVNDiffStatusHandler handler) throws SVNException {
        File basePath = null;
        if (path1 != null) {
            basePath = path1;
        }
        if (path2 != null) {
            basePath = path2;
        }
        if (pegRevision.isValid()) {
            SVNBasicDelegate.SVNRepositoryLocation[] locations = this.getLocations(url2, path2, null, pegRevision, revision1, revision2);
            url1 = locations[0].getURL();
            url2 = locations[1].getURL();
            this.getDiffGenerator().init(url1.toString(), url2.toString());
        } else {
            url1 = url1 == null ? this.getURL(path1) : url1;
            url2 = url2 == null ? this.getURL(path2) : url2;
        }
        SVNRepository repository1 = this.createRepository(url1, null, null, true);
        SVNRepository repository2 = this.createRepository(url2, null, null, false);
        final long rev1 = this.getRevisionNumber(revision1, repository1, path1);
        long rev2 = -1L;
        SVNNodeKind kind1 = null;
        SVNNodeKind kind2 = null;
        String target1 = null;
        try {
            SVNErrorMessage err;
            rev2 = this.getRevisionNumber(revision2, repository2, path2);
            kind1 = repository1.checkPath("", rev1);
            kind2 = repository2.checkPath("", rev2);
            if (kind1 == SVNNodeKind.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' was not found in the repository at revision {1}", url1, new Long(rev1));
                SVNErrorManager.error(err, SVNLogType.WC);
            } else if (kind2 == SVNNodeKind.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' was not found in the repository at revision {1}", url2, new Long(rev2));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (kind1 == SVNNodeKind.FILE || kind2 == SVNNodeKind.FILE) {
                target1 = SVNPathUtil.tail(url1.getPath());
                if (basePath != null) {
                    basePath = basePath.getParentFile();
                }
                url1 = SVNURL.parseURIEncoded(SVNPathUtil.removeTail(url1.toString()));
                repository1 = this.createRepository(url1, null, null, true);
            }
        }
        finally {
            repository2.closeSession();
        }
        repository2 = this.createRepository(url1, null, null, false);
        File tmpFile = this.getDiffGenerator().createTempDirectory();
        try {
            SVNDiffStatusEditor editor = new SVNDiffStatusEditor(basePath, target1, repository2, rev1, handler);
            ISVNReporterBaton reporter = new ISVNReporterBaton(){

                @Override
                public void report(ISVNReporter reporter) throws SVNException {
                    reporter.setPath("", null, rev1, SVNDepth.INFINITY, false);
                    reporter.finishReport();
                }
            };
            repository1.diff(url2, rev2, rev1, target1, !useAncestry, depth, false, reporter, SVNCancellableEditor.newInstance(editor, this, this.getDebugLog()));
        }
        finally {
            if (tmpFile != null) {
                SVNFileUtil.deleteAll(tmpFile, true, null);
            }
            repository2.closeSession();
        }
    }

    private int getAdminDepth(SVNDepth depth) {
        int admDepth = -1;
        if (depth == SVNDepth.IMMEDIATES) {
            admDepth = 1;
        } else if (depth == SVNDepth.EMPTY || depth == SVNDepth.FILES) {
            admDepth = 0;
        }
        return admDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getLocationFromPathAndRevision(File path, SVNURL url, SVNRevision pegRevision) throws SVNException {
        SVNWCAccess wcAccess = null;
        SVNRepository repos = null;
        SVNAdminArea adminArea = null;
        try {
            if (path != null && (pegRevision == SVNRevision.BASE || pegRevision == SVNRevision.WORKING || pegRevision == SVNRevision.COMMITTED || pegRevision == SVNRevision.UNDEFINED)) {
                int admLockLevel = this.getLevelsToLockFromDepth(SVNDepth.EMPTY);
                wcAccess = this.createWCAccess();
                wcAccess.probeOpen(path, false, admLockLevel);
            }
            long[] rev = new long[]{-1L};
            repos = this.createRepository(url, path, adminArea, pegRevision, pegRevision, rev);
            Object[] objectArray = new Object[]{repos.getLocation(), SVNRevision.create(rev[0])};
            return objectArray;
        }
        finally {
            if (wcAccess != null) {
                wcAccess.close();
            }
            if (repos != null) {
                repos.closeSession();
            }
        }
    }

    private void getLogMergedMergeInfoImpl(File path, SVNURL url, SVNRevision pegRevision, SVNURL mergeSrcURL, File mergeSrcPath, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        Map targetMergeInfo;
        SVNURL[] reposRoot = new SVNURL[1];
        Object[] location = this.getLocationFromPathAndRevision(mergeSrcPath, mergeSrcURL, srcPegRevision);
        SVNURL realMergeSrcURL = (SVNURL)location[0];
        SVNRevision realSrcPegRevision = (SVNRevision)location[1];
        Map map = targetMergeInfo = path != null ? this.getMergeInfo(path, pegRevision, reposRoot) : this.getMergeInfo(url, pegRevision, reposRoot);
        if (targetMergeInfo == null) {
            return;
        }
        Map srcHistory = this.getHistoryAsMergeInfo(realMergeSrcURL, null, realSrcPegRevision, -1L, -1L, null, null);
        Map<String, SVNMergeRangeList> mergeInfo = SVNMergeInfoUtil.intersectMergeInfo(targetMergeInfo, srcHistory, false);
        SVNMergeRangeList rangeList = new SVNMergeRangeList(new SVNMergeRange[0]);
        long youngestRev = -1L;
        String logTarget = null;
        for (String mergeSrc : mergeInfo.keySet()) {
            SVNMergeRangeList list = mergeInfo.get(mergeSrc);
            SVNMergeRange[] listRanges = list.getRanges();
            SVNMergeRange range = listRanges[listRanges.length - 1];
            if (!SVNRevision.isValidRevisionNumber(youngestRev) || range.getEndRevision() > youngestRev) {
                youngestRev = range.getEndRevision();
                logTarget = mergeSrc;
            }
            rangeList = rangeList.merge(list);
        }
        if (rangeList.isEmpty()) {
            return;
        }
        this.getLogsForMergeInfoRangeList(reposRoot[0], new String[]{logTarget}, rangeList, discoverChangedPaths, revisionProperties, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLogEligibleMergeInfoImpl(File path, SVNURL url, SVNRevision pegRevision, SVNURL mergeSrcURL, File mergeSrcPath, SVNRevision srcPegRevision, boolean discoverChangedPaths, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        SVNURL[] reposRoot = new SVNURL[1];
        Object[] location = this.getLocationFromPathAndRevision(mergeSrcPath, mergeSrcURL, srcPegRevision);
        SVNURL realMergeSrcURL = (SVNURL)location[0];
        SVNRevision realSrcPegRevision = (SVNRevision)location[1];
        Map<String, SVNMergeRangeList> mergeInfo = path != null ? this.getMergeInfo(path, pegRevision, reposRoot) : this.getMergeInfo(url, pegRevision, reposRoot);
        Map history = this.getHistoryAsMergeInfo(url, path, pegRevision, -1L, -1L, null, null);
        mergeInfo = mergeInfo == null ? history : SVNMergeInfoUtil.mergeMergeInfos(mergeInfo, history);
        SVNRepository repos = null;
        Map sourceHistory = null;
        try {
            repos = this.createRepository(realMergeSrcURL, null, null, true);
            sourceHistory = this.getHistoryAsMergeInfo(realMergeSrcURL, null, realSrcPegRevision, -1L, -1L, repos, null);
        }
        finally {
            if (repos != null) {
                repos.closeSession();
            }
        }
        Map<String, SVNMergeRangeList> availableMergeInfo = SVNMergeInfoUtil.removeMergeInfo(mergeInfo, sourceHistory, false);
        SVNMergeRangeList rangeList = new SVNMergeRangeList(new SVNMergeRange[0]);
        long youngestRev = -1L;
        String logTarget = null;
        for (String mergeSrc : availableMergeInfo.keySet()) {
            SVNMergeRangeList availableRangeList = availableMergeInfo.get(mergeSrc);
            SVNMergeRange[] ranges = availableRangeList.getRanges();
            SVNMergeRange range = ranges[ranges.length - 1];
            if (!SVNRevision.isValidRevisionNumber(youngestRev) || range.getEndRevision() > youngestRev) {
                youngestRev = range.getEndRevision();
                logTarget = mergeSrc;
            }
            rangeList = rangeList.merge(availableRangeList);
        }
        if (rangeList.isEmpty()) {
            return;
        }
        this.getLogsForMergeInfoRangeList(reposRoot[0], new String[]{logTarget}, rangeList, discoverChangedPaths, revisionProperties, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPatches(File absPatchPath, File absWCPath, boolean dryRun, int stripCount, SVNAdminArea wc) throws SVNException, IOException {
        try (SVNPatchFileStream patchFile = SVNPatchFileStream.openReadOnly(absPatchPath);){
            SVNPatch patch;
            ArrayList<SVNPatchTarget> targets = new ArrayList<SVNPatchTarget>();
            do {
                this.checkCancelled();
                patch = SVNPatch.parseNextPatch(patchFile);
                if (patch == null) continue;
                SVNPatchTarget target = SVNPatchTarget.applyPatch(patch, absWCPath, stripCount, wc);
                targets.add(target);
            } while (patch != null);
            Iterator i = targets.iterator();
            while (i.hasNext()) {
                this.checkCancelled();
                SVNPatchTarget target = (SVNPatchTarget)i.next();
                if (!target.isSkipped()) {
                    target.installPatchedTarget(absWCPath, dryRun, wc);
                }
                target.sendPatchNotification(wc);
                target.getPatch().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPatch(File absPatchPath, File localAbsPath, boolean dryRun, int stripCount) throws SVNException {
        if (stripCount < 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "strip count must be positive");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        try (SVNWCAccess wcAccess = this.createWCAccess();){
            wcAccess.setEventHandler(this);
            SVNAdminArea wc = wcAccess.open(localAbsPath, true, -1);
            this.applyPatches(absPatchPath, localAbsPath, dryRun, stripCount, wc);
        }
    }
}

