from mercurial import hg, util, error
from mercurial.i18n import _
try:
    from mercurial.url import passwordmgr
except:
    from mercurial.httprepo import passwordmgr

from urllib2 import AbstractBasicAuthHandler, AbstractDigestAuthHandler

import cStringIO
import subprocess
import urllib2


############################################################

def monkeypatch_method(cls,fname=None):
    def decorator(func):
        local_fname = fname
        if local_fname is None:
            local_fname = func.__name__
        setattr(func, "orig", getattr(cls, local_fname, None))
        setattr(cls, local_fname, func)
        return func
    return decorator

############################################################

def call_smartgit(command, authuri, ui):
    try:
        return subprocess.check_output(
            [ui.config("smartgit", "java"),
            "-cp", ui.config("smartgit", "classpath"),
            ui.config("smartgit", "mainClass"),
            command, authuri])
    except Exception as e:
        raise util.Abort(_('requesting password from SmartGit failed: %s') % e)


############################################################

@monkeypatch_method(passwordmgr)
def find_user_password(self, realm, authuri):
    try:
        return find_user_password.orig(self, realm, authuri)
    except error.Abort:
        result = cStringIO.StringIO(call_smartgit("get", authuri, self.ui))
        return (result.readline().strip(), result.readline().strip())

@monkeypatch_method(AbstractBasicAuthHandler, "http_error_auth_reqed")
def basic_http_error_auth_reqed(self, authreq, host, req, headers):
    # for whatever reasons, looping until there is no more HTTPError
    # goes to infinite cycle after 5 failed authentications,
    # hence, do not loop at all.
    try:
        return basic_http_error_auth_reqed.orig(self, authreq, host, req, headers)
    except urllib2.HTTPError:
        call_smartgit("fail", host, self.passwd.ui)
        