/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.db2.tab;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BasePreparedStatementTab;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.db2.sql.DB2Sql;

public class IndexDetailsTab
extends BasePreparedStatementTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(IndexDetailsTab.class);
    private static final ILogger s_log = LoggerController.createLogger(IndexDetailsTab.class);
    private final DB2Sql db2Sql;

    public IndexDetailsTab(DB2Sql db2Sql) {
        super(i18n.TITLE, i18n.HINT, true);
        this.db2Sql = db2Sql;
    }

    protected PreparedStatement createStatement() throws SQLException {
        ISession session = this.getSession();
        IDatabaseObjectInfo doi = this.getDatabaseObjectInfo();
        String sql = this.db2Sql.getIndexDetailsSql();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Running SQL for index details: " + sql));
            s_log.debug((Object)("schema=" + doi.getSchemaName()));
            s_log.debug((Object)("index name=" + doi.getSimpleName()));
        }
        PreparedStatement pstmt = session.getSQLConnection().prepareStatement(sql);
        pstmt.setString(1, doi.getSchemaName());
        pstmt.setString(2, doi.getSimpleName());
        return pstmt;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface i18n {
        public static final String TITLE = IndexDetailsTab.access$000().getString("IndexDetailsTab.title");
        public static final String HINT = IndexDetailsTab.access$000().getString("IndexDetailsTab.hint");
    }
}

