/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.gui.db.AliasTreePasteMode;
import net.sourceforge.squirrel_sql.client.gui.db.AliasTreePasteState;
import net.sourceforge.squirrel_sql.client.gui.db.aliascolor.AliasTreeColorer;

public class AliasTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final AliasTreePasteState _aliasPasteState;
    private final AliasTreeColorer _aliasColorer;

    public AliasTreeCellRenderer(AliasTreePasteState aliasPasteState, AliasTreeColorer aliasColorer) {
        this._aliasPasteState = aliasPasteState;
        this._aliasColorer = aliasColorer;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return this.modifyRenderer(this, super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus), value);
    }

    private Component modifyRenderer(DefaultTreeCellRenderer defaultTreeCellRenderer, Component component, Object node) {
        JLabel ret = (JLabel)component;
        ret.setEnabled(true);
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)node;
        this._aliasColorer.colorAliasRendererComponent(defaultTreeCellRenderer, dmtn, ret);
        if (null != this._aliasPasteState.getPathsToPaste() && AliasTreePasteMode.CUT.equals((Object)this._aliasPasteState.getPasteMode())) {
            boolean found = false;
            for (TreePath treePath : this._aliasPasteState.getPathsToPaste()) {
                if (treePath.getLastPathComponent() != dmtn) continue;
                found = true;
                break;
            }
            ret.setEnabled(!found);
            ret.setDisabledIcon(ret.getIcon());
        }
        return component;
    }
}

