/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BaseDataSetViewerDestination;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DataSetViewerTextFileDestination
extends BaseDataSetViewerDestination {
    private final ILogger s_log = LoggerController.createLogger(DataSetViewerTextFileDestination.class);
    private File _outFile;
    private PrintWriter _outFileWtr;
    private int _rowCount = 0;

    public DataSetViewerTextFileDestination(File outFile) {
        if (outFile == null) {
            throw new IllegalArgumentException("File == null");
        }
        this._outFile = outFile;
    }

    @Override
    public Component getComponent() {
        throw new UnsupportedOperationException("DataSetViewerTextFileDestination.getComponent()");
    }

    @Override
    public void clear() {
    }

    @Override
    protected void addRow(Object[] row) throws DataSetException {
        PrintWriter wtr = this.getWriter();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < row.length; ++i) {
            buf.append("\"").append(row[i] != null ? row[i].toString() : "null").append("\"");
            if (i >= row.length - 1) continue;
            buf.append(",");
        }
        wtr.println(buf.toString());
        ++this._rowCount;
    }

    @Override
    protected void allRowsAdded() throws DataSetException {
        this.closeWriter();
    }

    @Override
    public void moveToTop() {
    }

    @Override
    public int getRowCount() {
        return this._rowCount;
    }

    private PrintWriter getWriter() throws DataSetException {
        if (this._outFileWtr == null) {
            try {
                this._outFileWtr = new PrintWriter(new FileWriter(this._outFile));
            }
            catch (IOException ex) {
                this.s_log.error("Error closing file writer", ex);
                throw new DataSetException(ex);
            }
        }
        return this._outFileWtr;
    }

    private void closeWriter() throws DataSetException {
        this.getWriter().close();
        this._outFileWtr = null;
        this._rowCount = 0;
    }
}

