/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.ui.FontSelector;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.RColorSwatchesButton;
import org.fife.ui.UIUtil;
import org.fife.ui.rtextarea.RTextArea;

public class GutterOptionPanel
extends OptionsDialogPanel
implements PropertyChangeListener,
ActionListener,
ItemListener {
    private JCheckBox lnEnabledCB;
    private FontSelector fontSelector;
    private RColorSwatchesButton lnColorButton;
    private JCheckBox enableBookmarkingCB;
    private RColorSwatchesButton borderColorButton;
    private RColorSwatchesButton foldBackgroundButton;
    private RColorSwatchesButton armedFoldBackgroundButton;
    private static final String PROPERTY = "property";

    public GutterOptionPanel() {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rtextarea.GutterOptionPanel");
        this.setName(msg.getString("Title"));
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box topPanel = new Box(1);
        Box lineNumbersPanel = new Box(1);
        lineNumbersPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("LineNumbers")));
        this.lnEnabledCB = new JCheckBox(msg.getString("Enabled"));
        this.lnEnabledCB.addItemListener(this);
        JComponent temp = new JPanel(new BorderLayout());
        temp.add((Component)this.lnEnabledCB, "Before");
        lineNumbersPanel.add(temp);
        JPanel fontPanel = new JPanel(new BorderLayout());
        this.fontSelector = new FontSelector();
        this.fontSelector.setColorSelectable(true);
        this.fontSelector.addPropertyChangeListener("font", (PropertyChangeListener)this);
        this.fontSelector.addPropertyChangeListener("fontColor", (PropertyChangeListener)this);
        fontPanel.add((Component)this.fontSelector);
        lineNumbersPanel.add(fontPanel);
        lineNumbersPanel.add(Box.createVerticalStrut(5));
        JLabel lnColorLabel = new JLabel(msg.getString("Color"));
        this.lnColorButton = new RColorSwatchesButton();
        this.lnColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        lnColorLabel.setLabelFor((Component)this.lnColorButton);
        temp = new Box(2);
        temp.add(lnColorLabel);
        temp.add(Box.createHorizontalStrut(5));
        temp.add((Component)this.lnColorButton);
        temp.add(Box.createHorizontalGlue());
        JPanel temp2 = new JPanel(new BorderLayout());
        temp2.add((Component)temp, "Before");
        lineNumbersPanel.add(temp2);
        topPanel.add(lineNumbersPanel);
        topPanel.add(Box.createVerticalStrut(5));
        Box foldPanel = new Box(1);
        foldPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("FoldArea")));
        JLabel foldBackgroundLabel = new JLabel(msg.getString("FoldBackground"));
        this.foldBackgroundButton = new RColorSwatchesButton();
        this.foldBackgroundButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        foldBackgroundLabel.setLabelFor((Component)this.foldBackgroundButton);
        temp = new Box(2);
        temp.add(foldBackgroundLabel);
        temp.add(Box.createHorizontalStrut(5));
        temp.add((Component)this.foldBackgroundButton);
        temp.add(Box.createHorizontalGlue());
        temp2 = new JPanel(new BorderLayout());
        temp2.add((Component)temp, "Before");
        foldPanel.add(temp2);
        JLabel armedFoldBackgroundLabel = new JLabel(msg.getString("ArmedFoldBackground"));
        this.armedFoldBackgroundButton = new RColorSwatchesButton();
        this.armedFoldBackgroundButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        armedFoldBackgroundLabel.setLabelFor((Component)this.armedFoldBackgroundButton);
        temp = new Box(2);
        temp.add(armedFoldBackgroundLabel);
        temp.add(Box.createHorizontalStrut(5));
        temp.add((Component)this.armedFoldBackgroundButton);
        temp.add(Box.createHorizontalGlue());
        temp2 = new JPanel(new BorderLayout());
        temp2.add((Component)temp, "Before");
        foldPanel.add(temp2);
        topPanel.add(foldPanel);
        topPanel.add(Box.createVerticalStrut(5));
        Box otherPanel = new Box(1);
        otherPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("Other")));
        JLabel borderColorLabel = new JLabel(msg.getString("BorderColor"));
        this.borderColorButton = new RColorSwatchesButton();
        this.borderColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        borderColorLabel.setLabelFor((Component)this.borderColorButton);
        temp = new Box(2);
        temp.add(borderColorLabel);
        temp.add(Box.createHorizontalStrut(5));
        temp.add((Component)this.borderColorButton);
        temp.add(Box.createHorizontalGlue());
        temp2 = new JPanel(new BorderLayout());
        temp2.add((Component)temp, "Before");
        otherPanel.add(temp2);
        this.enableBookmarkingCB = new JCheckBox(msg.getString("EnableBookmarks"));
        this.enableBookmarkingCB.addItemListener(this);
        temp = new JPanel(new BorderLayout());
        temp.add((Component)this.enableBookmarkingCB, "Before");
        otherPanel.add(temp);
        topPanel.add(otherPanel);
        topPanel.add(Box.createVerticalStrut(5));
        JButton rdButton = new JButton(msg.getString("RestoreDefaults"));
        rdButton.setActionCommand("RestoreDefaults");
        rdButton.addActionListener(this);
        this.addLeftAligned(topPanel, rdButton);
        topPanel.add(Box.createVerticalGlue());
        this.add(topPanel, "North");
        this.applyComponentOrientation(orientation);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("RestoreDefaults".equals(command)) {
            Font defaultFont = RTextArea.getDefaultFont();
            Color defBorderColor = new Color(221, 221, 221);
            if (!(this.lnEnabledCB.isSelected() && defaultFont.equals(this.fontSelector.getDisplayedFont()) && Color.GRAY.equals(this.lnColorButton.getColor()) && this.enableBookmarkingCB.isSelected() && defBorderColor.equals(this.borderColorButton.getColor()) && Color.WHITE.equals(this.foldBackgroundButton.getColor()) && Color.WHITE.equals(this.armedFoldBackgroundButton.getColor()))) {
                this.lnEnabledCB.setSelected(true);
                this.fontSelector.setDisplayedFont(defaultFont, false);
                this.lnColorButton.setColor(Color.GRAY);
                this.enableBookmarkingCB.setSelected(true);
                this.borderColorButton.setColor(new Color(221, 221, 221));
                this.foldBackgroundButton.setColor(Color.WHITE);
                this.armedFoldBackgroundButton.setColor(Color.WHITE);
                this.hasUnsavedChanges = true;
                this.firePropertyChange(PROPERTY, false, true);
            }
        }
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setLineNumbersEnabled(this.lnEnabledCB.isSelected());
        mainView.setLineNumberFont(this.fontSelector.getDisplayedFont());
        mainView.setLineNumberColor(this.lnColorButton.getColor());
        mainView.setGutterBorderColor(this.borderColorButton.getColor());
        mainView.setBookmarksEnabled(this.enableBookmarkingCB.isSelected());
        mainView.setFoldBackground(this.foldBackgroundButton.getColor());
        mainView.setArmedFoldBackground(this.armedFoldBackgroundButton.getColor());
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    public JComponent getTopJComponent() {
        return this.lnEnabledCB;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.hasUnsavedChanges = true;
        this.firePropertyChange(PROPERTY, false, true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.hasUnsavedChanges = true;
        this.firePropertyChange(PROPERTY, e.getOldValue(), e.getNewValue());
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.lnEnabledCB.setSelected(mainView.getLineNumbersEnabled());
        this.fontSelector.setDisplayedFont(mainView.getLineNumberFont(), false);
        this.lnColorButton.setColor(mainView.getLineNumberColor());
        this.borderColorButton.setColor(mainView.getGutterBorderColor());
        this.enableBookmarkingCB.setSelected(mainView.getBookmarksEnabled());
        this.foldBackgroundButton.setColor(mainView.getFoldBackground());
        this.armedFoldBackgroundButton.setColor(mainView.getArmedFoldBackground());
    }
}

