/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy;

import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.TableInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbcopy.SessionInfoProvider;

public class SessionInfoProviderImpl
implements SessionInfoProvider {
    private ISession _copyDestSession = null;
    private List<IDatabaseObjectInfo> _selectedDatabaseObjects = null;
    private IDatabaseObjectInfo _selectedDestDatabaseObject = null;
    private String _pasteToTableName;
    private String _whereClause;
    private ISession _copySourceSession = null;
    private static final ILogger s_log = LoggerController.createLogger(SessionInfoProviderImpl.class);

    @Override
    public void setSourceDatabaseObjects(List<IDatabaseObjectInfo> dbObjList) {
        if (dbObjList != null) {
            this._selectedDatabaseObjects = dbObjList;
            int sourceObjectCount = 0;
            if (s_log.isDebugEnabled()) {
                for (IDatabaseObjectInfo info : dbObjList) {
                    s_log.debug((Object)("setSelectedDatabaseObjects: IDatabaseObjectInfo[" + sourceObjectCount++ + "]=" + info));
                }
            }
        }
    }

    @Override
    public ISession getSourceSession() {
        return this._copySourceSession;
    }

    @Override
    public void initCopy(ISession copySourceSession) {
        if (copySourceSession != null) {
            this._copySourceSession = copySourceSession;
            this._pasteToTableName = null;
            this._whereClause = null;
            this._selectedDestDatabaseObject = null;
        }
    }

    public ISession getCopySourceSession() {
        return this._copySourceSession;
    }

    public void dispose() {
        this._copySourceSession = null;
    }

    @Override
    public List<IDatabaseObjectInfo> getSourceDatabaseObjects() {
        return this._selectedDatabaseObjects;
    }

    @Override
    public ISession getDestSession() {
        return this._copyDestSession;
    }

    @Override
    public void setPasteToTableName(String pasteToTableName) {
        this._pasteToTableName = pasteToTableName;
    }

    @Override
    public String getPasteToTableName() {
        return this._pasteToTableName;
    }

    @Override
    public void setWhereClause(String whereClause) {
        this._whereClause = whereClause;
    }

    @Override
    public String getWhereClause() {
        return this._whereClause;
    }

    @Override
    public TableInfo getPasteToTableInfo(ISQLConnection destConn, String destSchema, String destCatalog) {
        if (null == this._pasteToTableName) {
            return null;
        }
        if (1 != this._selectedDatabaseObjects.size() || !(this._selectedDatabaseObjects.get(0) instanceof TableInfo)) {
            throw new IllegalStateException("Invalid paste table as state");
        }
        TableInfo ret = new TableInfo(destCatalog, destSchema, this._pasteToTableName, "TABLE", null, (ISQLDatabaseMetaData)destConn.getSQLMetaData());
        return ret;
    }

    @Override
    public boolean isCopiedFormDestinationSession() {
        return this._copyDestSession.equals(this._copySourceSession);
    }

    @Override
    public void setDestSession(ISession session) {
        this._copyDestSession = session;
    }

    @Override
    public IDatabaseObjectInfo getDestDatabaseObject() {
        return this._selectedDestDatabaseObject;
    }

    @Override
    public void setDestDatabaseObject(IDatabaseObjectInfo info) {
        this._selectedDestDatabaseObject = info;
    }
}

