/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.exportconfig;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JMenu;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.plugin.DefaultPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResourcesFactory;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.exportconfig.ExportConfigPreferences;
import net.sourceforge.squirrel_sql.plugins.exportconfig.action.ExportAliasesAction;
import net.sourceforge.squirrel_sql.plugins.exportconfig.action.ExportConfigurationAction;
import net.sourceforge.squirrel_sql.plugins.exportconfig.action.ExportDriversAction;
import net.sourceforge.squirrel_sql.plugins.exportconfig.action.ExportSettingsAction;

public class ExportConfigPlugin
extends DefaultPlugin {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ExportConfigPlugin.class);
    private static final ILogger s_log = LoggerController.createLogger(ExportConfigPlugin.class);
    private static final String USER_PREFS_FILE_NAME = "prefs.xml";
    private FileWrapper _userSettingsFolder;
    private IResources _resources;
    private IPluginResourcesFactory _resourcesFactory = new PluginResourcesFactory();
    private JMenu _exportMenu;
    private ExportConfigPreferences _prefs;

    public void setResourcesFactory(IPluginResourcesFactory resourcesFactory) {
        this._resourcesFactory = resourcesFactory;
    }

    public String getInternalName() {
        return "exportconfig";
    }

    public String getDescriptiveName() {
        return "Export Configuration Plugin";
    }

    public String getVersion() {
        return "0.10";
    }

    public String getAuthor() {
        return "Colin Bell";
    }

    public String getContributors() {
        return "Rob Manning";
    }

    public synchronized void load(IApplication app) throws PluginException {
        super.load(app);
        try {
            this._userSettingsFolder = this.getPluginUserSettingsFolder();
        }
        catch (IOException ex) {
            throw new PluginException((Exception)ex);
        }
        this._resources = this._resourcesFactory.createResource(((Object)((Object)this)).getClass().getName(), (IPlugin)this);
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        coll.add((Action)((Object)new ExportAliasesAction(app, this._resources, this)));
        coll.add((Action)((Object)new ExportConfigurationAction(app, this._resources, this)));
        coll.add((Action)((Object)new ExportDriversAction(app, this._resources, this)));
        coll.add((Action)((Object)new ExportSettingsAction(app, this._resources, this)));
        this.loadPrefs();
        this._exportMenu = this.createExportMenu();
        app.addToMenu(1, this._exportMenu);
    }

    public void unload() {
        this.savePrefs();
        super.unload();
    }

    public ExportConfigPreferences getPreferences() {
        return this._prefs;
    }

    private void loadPrefs() {
        try {
            XMLBeanReader doc = new XMLBeanReader();
            doc.load(this.fileWrapperFactory.create(this._userSettingsFolder, USER_PREFS_FILE_NAME), ((Object)((Object)this)).getClass().getClassLoader());
            Iterator it = doc.iterator();
            if (it.hasNext()) {
                this._prefs = (ExportConfigPreferences)it.next();
            }
        }
        catch (FileNotFoundException ignore) {
            s_log.info((Object)s_stringMgr.getString("exportconfig.fileWillBeCreated", new Object[]{USER_PREFS_FILE_NAME}));
        }
        catch (Exception ex) {
            s_log.error((Object)s_stringMgr.getString("exportconfig.errorCreatingFile", new Object[]{USER_PREFS_FILE_NAME}), (Throwable)ex);
        }
        if (this._prefs == null) {
            this._prefs = new ExportConfigPreferences();
        }
    }

    private void savePrefs() {
        try {
            XMLBeanWriter wtr = new XMLBeanWriter((Object)this._prefs);
            wtr.save(this.fileWrapperFactory.create(this._userSettingsFolder.getAbsolutePath(), USER_PREFS_FILE_NAME));
        }
        catch (Exception ex) {
            s_log.error((Object)s_stringMgr.getString("exportconfig.errorWritingPrefs", new Object[]{USER_PREFS_FILE_NAME}), (Throwable)ex);
        }
    }

    private JMenu createExportMenu() {
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        JMenu exportMenu = this._resources.createMenu("export");
        this._resources.addToMenu(coll.get(ExportConfigurationAction.class), exportMenu);
        this._resources.addToMenu(coll.get(ExportAliasesAction.class), exportMenu);
        this._resources.addToMenu(coll.get(ExportDriversAction.class), exportMenu);
        this._resources.addToMenu(coll.get(ExportSettingsAction.class), exportMenu);
        app.addToMenu(2, exportMenu);
        return exportMenu;
    }

    public static interface IMenuResourceKeys {
        public static final String EXPORT = "export";
    }
}

