/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Aggregate_Function;
import unity.functions.Expression;

public class D_Avg
extends Aggregate_Function {
    private static final long serialVersionUID = 1L;
    protected double currentTotal;
    protected long currentTotalLong;
    protected long currentCount;
    protected boolean isIntType;
    protected HashSet<Object> values;

    public D_Avg(Expression expression) {
        this.children = new ArrayList(1);
        this.children.add(expression);
        this.computedExpr = expression;
        this.returnType = expression.getReturnType();
        this.isIntType = this.returnType == 4 || this.returnType == -5;
        this.values = new HashSet();
    }

    @Override
    public void reset() {
        this.currentTotal = 0.0;
        this.currentTotalLong = 0L;
        this.currentCount = 0L;
        this.values = new HashSet();
    }

    @Override
    public Object compute() {
        if (this.currentCount == 0L) {
            return null;
        }
        if (this.isIntType) {
            return new Double((double)this.currentTotalLong * 1.0 / (double)this.currentCount);
        }
        return new Double(this.currentTotal / (double)this.currentCount);
    }

    @Override
    public void add(Tuple tuple) throws SQLException {
        Object object = this.computedExpr.evaluate(tuple);
        if (object != null) {
            if (this.values.contains(object)) {
                return;
            }
            if (this.isIntType) {
                this.currentTotalLong += ((Number)object).longValue();
            } else {
                this.currentTotal += ((Number)object).doubleValue();
            }
            ++this.currentCount;
            this.values.add(object);
        }
    }

    @Override
    public String toString(Relation relation, Attribute attribute) {
        return "AVG(DISTINCT " + this.computedExpr.toString(relation) + ") AS " + attribute.getName();
    }
}

