/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.functions.Interval;

public class F_Dateadd
extends Expression {
    private static final long serialVersionUID = 1L;
    private Expression datepart;
    private Expression number;
    private Expression date;

    public F_Dateadd(Expression expression, Expression expression2, Expression expression3) {
        this.datepart = expression;
        this.number = expression2;
        this.date = expression3;
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        Object object = this.date.evaluate(tuple);
        if (object == null) {
            return null;
        }
        Object object2 = this.datepart.evaluate(tuple);
        if (object2 == null) {
            return object;
        }
        Object object3 = this.number.evaluate(tuple);
        if (object3 == null) {
            return object;
        }
        if (object instanceof Date || object instanceof Timestamp) {
            Date date = (Date)object;
            String string = object2.toString();
            Interval interval = null;
            if (string.equals("year") || string.equals("yy")) {
                interval = new Interval(object3, 10000);
            } else if (string.equals("quarter") || string.equals("qq")) {
                interval = new Interval(object3, 10001);
            } else if (string.equals("month") || string.equals("mm")) {
                interval = new Interval(object3, 10002);
            } else if (string.equals("dayofyear") || string.equals("dy") || string.equals("day") || string.equals("dd") || string.equals("dayofweek") || string.equals("dw")) {
                interval = new Interval(object3, 10004);
            } else if (string.equals("week") || string.equals("ww")) {
                interval = new Interval(object3, 10003);
            } else if (string.equals("hour") || string.equals("hh")) {
                interval = new Interval(object3, 10005);
            } else if (string.equals("minute") || string.equals("mm")) {
                interval = new Interval(object3, 10006);
            } else if (string.equals("second") || string.equals("ss")) {
                interval = new Interval(object3, 10007);
            } else if (string.equals("millisecond") || string.equals("ms")) {
                interval = new Interval((Integer)object3 * 1000, 10008);
            }
            if (interval == null) {
                return object;
            }
            return interval.add(date, true);
        }
        return null;
    }

    @Override
    public int getReturnType() {
        return 91;
    }

    public static int[] getParamListTypes() {
        return new int[]{12, 4, 91};
    }

    public static String getFunctionName() {
        return "DATEADD";
    }

    @Override
    public String toString(Relation relation) {
        return "DATEADD(" + this.datepart.toString(relation) + ", " + this.number.toString(relation) + ", " + this.date.toString(relation) + ")";
    }
}

