/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.functions.Function;

public class F_Tan
extends Function {
    private static final long serialVersionUID = 1L;
    private Expression expr;

    public F_Tan(Expression expression) {
        this.expr = expression;
        this.returnType = this.getReturnType();
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        Object object = this.expr.evaluate(tuple);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return new Double(Math.atan(d));
        }
        return null;
    }

    @Override
    public int getReturnType() {
        return 8;
    }

    public static int[] getParamListTypes() {
        return new int[]{99999};
    }

    public static String getFunctionName() {
        return "TAN";
    }

    @Override
    public String toString(Relation relation) {
        return "TAN(" + this.expr.toString(relation) + ")";
    }
}

