/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import unity.annotation.GlobalSchema;
import unity.cache.Cache;
import unity.io.FileManager;
import unity.jdbc.UnityConnection;
import unity.mapping.DatabaseMapping;
import unity.util.CipherParamImpl;
import unity.util.LicenseParamImpl;
import unity.util.PublicKeyStoreParamImpl;
import unity.util.UsageTracker;

public class UnityDriver
implements Driver {
    public static final Locale locale = Locale.getDefault();
    public static ResourceBundle i18n = ResourceBundle.getBundle("resources/unity", locale);
    public static final int _MAJORVERSION = 4;
    public static final int _MINORVERSION = 2;
    public static final int _BUILD = 243;
    public static final boolean NO_TRIAL_EXCEPTION = true;
    private static boolean TRIAL = true;
    private static boolean CLIENT_VERSION = false;
    private static final int CONNECTION_LIMIT = 3;
    private static final int MAX_RESULTS = 100;
    public static final String DRIVER_NAME = "UnityJDBC";
    public static boolean DEBUG = false;
    private static Cache cache = null;
    private static DatabaseMapping mapper = null;
    public static final String VIRTUAL_NAME = "virtual";
    public static final String SOURCES_PROPERTY = "sources";
    public static final String JDBC_URL = "jdbc:unity://";
    public static ClassLoader classLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnityDriver() throws SQLException {
        Object object;
        Object object2;
        PublicKeyStoreParamImpl publicKeyStoreParamImpl = new PublicKeyStoreParamImpl();
        CipherParamImpl cipherParamImpl = new CipherParamImpl();
        LicenseParamImpl licenseParamImpl = new LicenseParamImpl(publicKeyStoreParamImpl, cipherParamImpl);
        LicenseManager licenseManager = new LicenseManager(licenseParamImpl);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("license.lic");
        LicenseContent licenseContent = null;
        String string = "testuser@unityjdbc.com";
        if (inputStream != null) {
            try {
                licenseManager.install(inputStream);
                licenseContent = licenseManager.verify();
                object2 = (Boolean[])licenseContent.getExtra();
                if (object2 != null) {
                    CLIENT_VERSION = object2[1];
                    TRIAL = object2[0];
                    object = licenseContent.getHolder().toString();
                    int n = ((String)object).indexOf("EMAILADDRESS=");
                    if (n > 0) {
                        string = ((String)object).substring(n + 13);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            FileManager.closeStream(inputStream);
        }
        if (mapper == null) {
            object2 = null;
            try {
                object = this.getClass().getClassLoader().getResourceAsStream("unity/mapping/.mapping");
                if (object == null) {
                    throw new SQLException(i18n.getString("UnityDriver.MapFileNotFound"));
                }
                classLoader = this.getClass().getClassLoader();
                object2 = new BufferedReader(new InputStreamReader(FileManager.getDecryptedStream((InputStream)object, "UnityDriver.class", "PBKDF2WithHmacSHA1", "AES", 65536, 128, "AES/CBC/PKCS5Padding"), Charset.forName("UTF-8")));
                mapper = new DatabaseMapping();
                DatabaseMapping.load((BufferedReader)object2);
            }
            catch (IOException iOException) {
                throw new SQLException(i18n.getString("UnityDriver.ErrorLoadMapFile"));
            }
            finally {
                try {
                    if (object2 != null) {
                        ((BufferedReader)object2).close();
                    }
                }
                catch (Exception exception) {}
            }
            object2 = null;
            try {
                object = this.getClass().getClassLoader().getResourceAsStream("mapping.xml");
                if (object != null) {
                    object2 = new BufferedReader(new InputStreamReader((InputStream)object, Charset.forName("UTF-8")));
                    DatabaseMapping.load((BufferedReader)object2);
                    if (DEBUG) {
                        System.out.println(i18n.getString("UnityDriver.ReadUserMapFile"));
                    }
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            finally {
                try {
                    if (object2 != null) {
                        ((BufferedReader)object2).close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        object2 = new UsageTracker(string);
        ((Thread)object2).start();
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        int n = string.toLowerCase().indexOf(JDBC_URL);
        return n >= 0;
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string2 = string;
        if (!this.acceptsURL(string2)) {
            return null;
        }
        boolean bl = false;
        int n = string2.indexOf("?");
        if (n > 0) {
            String string3 = string2.substring(n + 1);
            object4 = new StringTokenizer(string3, "=&;");
            while (((StringTokenizer)object4).hasMoreTokens()) {
                object3 = ((StringTokenizer)object4).nextToken();
                if (((String)object3).equalsIgnoreCase("debug")) {
                    if (!((StringTokenizer)object4).hasMoreTokens() || !((String)(object3 = ((StringTokenizer)object4).nextToken())).equalsIgnoreCase("true")) continue;
                    DEBUG = true;
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("cache")) {
                    if (!((StringTokenizer)object4).hasMoreTokens()) continue;
                    object3 = ((StringTokenizer)object4).nextToken();
                    properties.setProperty("cache", (String)object3);
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("new")) {
                    if (((StringTokenizer)object4).hasMoreTokens()) {
                        object3 = ((StringTokenizer)object4).nextToken();
                        properties.setProperty("new", (String)object3);
                    } else {
                        properties.setProperty("new", "true");
                    }
                    bl = true;
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("sort_buffer_size")) {
                    if (!((StringTokenizer)object4).hasMoreTokens()) continue;
                    object3 = ((StringTokenizer)object4).nextToken();
                    properties.setProperty("sort_buffer_size", (String)object3);
                    continue;
                }
                if (((String)object3).equalsIgnoreCase("join_buffer_size")) {
                    if (!((StringTokenizer)object4).hasMoreTokens()) continue;
                    object3 = ((StringTokenizer)object4).nextToken();
                    properties.setProperty("join_buffer_size", (String)object3);
                    continue;
                }
                object2 = object3;
                if (!((StringTokenizer)object4).hasMoreTokens()) continue;
                object3 = ((StringTokenizer)object4).nextToken();
                properties.setProperty((String)object2, (String)object3);
            }
            string2 = string2.substring(0, n);
        }
        int n2 = string2.toLowerCase().indexOf(JDBC_URL);
        object4 = string2.substring(n2 + 13);
        object3 = null;
        if (DEBUG) {
            System.out.println("UnityJDBC Version " + this.getMajorVersion() + "." + this.getMinorVersion() + "." + 243);
            System.out.println("Sources file: " + (String)object4);
        }
        object2 = new GlobalSchema();
        if (((String)object4).equals(VIRTUAL_NAME)) {
            object = properties.getProperty(SOURCES_PROPERTY);
            ((GlobalSchema)object2).parseSources((String)object, properties);
        } else {
            boolean bl2 = false;
            try {
                String string4 = properties.getProperty("password");
                if (string4 != null && !string4.equals("")) {
                    bl2 = true;
                    InputStream inputStream = FileManager.getDecryptedStream((String)object4, string4, properties);
                    object3 = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
                } else {
                    object3 = new BufferedReader(new InputStreamReader(FileManager.getStream((String)object4), Charset.forName("UTF-8")));
                }
            }
            catch (IOException iOException) {
                if (bl) {
                    try {
                        ((GlobalSchema)object2).exportSources((String)object4);
                        object3 = new BufferedReader(new InputStreamReader(FileManager.getStream((String)object4), Charset.forName("UTF-8")));
                    }
                    catch (IOException iOException2) {
                        throw new SQLException("Unable to create new connection information at: " + (String)object4);
                    }
                }
                throw new SQLException("Unable to retrieve connection information at: " + (String)object4 + " Encrypted: " + bl2 + " Error: " + iOException);
            }
            ((GlobalSchema)object2).parseSourcesFile((BufferedReader)object3, string2, properties);
            try {
                if (object3 != null) {
                    ((BufferedReader)object3).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = new UnityConnection((GlobalSchema)object2, properties);
        ((UnityConnection)object).initCache(cache);
        return object;
    }

    @Override
    public int getMajorVersion() {
        return 4;
    }

    @Override
    public int getMinorVersion() {
        return 2;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[6];
        String string2 = "false";
        if (properties.containsKey("debug")) {
            string2 = properties.get("debug").toString();
        }
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("debug", string2);
        driverPropertyInfo.choices = new String[]{"true", "false"};
        driverPropertyInfo.description = "The debug property will cause the driver to print out debug information to the console during its operation.";
        driverPropertyInfo.required = false;
        driverPropertyInfoArray[0] = driverPropertyInfo;
        string2 = "false";
        if (properties.containsKey("new")) {
            string2 = properties.get("new").toString();
        }
        driverPropertyInfo = new DriverPropertyInfo("new", string2);
        driverPropertyInfo.choices = new String[]{"true", "false"};
        driverPropertyInfo.description = "The new property will create a new empty sources file at location given if none exists.";
        driverPropertyInfo.required = false;
        driverPropertyInfoArray[1] = driverPropertyInfo;
        string2 = "0";
        if (properties.containsKey("cache")) {
            string2 = properties.get("cache").toString();
        }
        driverPropertyInfo = new DriverPropertyInfo("cache", string2);
        driverPropertyInfo.choices = new String[]{"0", "1", "2"};
        driverPropertyInfo.description = "The cache property indicates if connection will use a cache.  Values: 0 (NO_CACHE), 1 (READ/WRITE CACHE), 2 (READ-ONLY CACHE).  A cache is shared for all connections.";
        driverPropertyInfo.required = false;
        driverPropertyInfoArray[2] = driverPropertyInfo;
        string2 = "0";
        if (properties.containsKey("cachetime")) {
            string2 = properties.get("cachetime").toString();
        }
        driverPropertyInfo = new DriverPropertyInfo("cachetime", string2);
        driverPropertyInfo.choices = new String[]{"1", "2", "A positive integer >=0"};
        driverPropertyInfo.description = "The cachetime property is the number of milliseconds a cache entry is valid before it is expired and removed from the cache.";
        driverPropertyInfo.required = false;
        driverPropertyInfoArray[3] = driverPropertyInfo;
        string2 = "20000000";
        if (properties.containsKey("join_buffer_size")) {
            string2 = properties.get("join_buffer_size").toString();
        }
        driverPropertyInfo = new DriverPropertyInfo("join_buffer_size", string2);
        driverPropertyInfo.choices = new String[]{"A positive integer >= 1000000"};
        driverPropertyInfo.description = "The join buffer size is used by hash joins when buffering the build table.  The value is specified in bytes.";
        driverPropertyInfo.required = false;
        driverPropertyInfoArray[4] = driverPropertyInfo;
        string2 = "20000000";
        if (properties.containsKey("sort_buffer_size")) {
            string2 = properties.get("sort_buffer_size").toString();
        }
        driverPropertyInfo = new DriverPropertyInfo("join_buffer_size", string2);
        driverPropertyInfo.choices = new String[]{"A positive integer >= 1000000"};
        driverPropertyInfo.description = "The sort buffer size is used by sorting operations.  The value is specified in bytes.";
        driverPropertyInfo.required = false;
        driverPropertyInfoArray[5] = driverPropertyInfo;
        return driverPropertyInfoArray;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException(i18n.getString("UnityDriver.NoLogging"));
    }

    public static int getConnectionLimit() {
        return 3;
    }

    public static boolean isClientVersion() {
        return CLIENT_VERSION;
    }

    public static int getMaxResults() {
        return 100;
    }

    public static void createCache() {
        if (cache == null) {
            cache = new Cache(1000, 5000);
            if (DEBUG) {
                System.out.println("Created query cache.");
            }
        }
    }

    public static void clearCache() {
        if (cache != null) {
            cache.clear();
        }
    }

    public static void setExpiryTime(int n) {
        cache.setExpiryTime(n);
    }

    public static String getVersion() {
        String string = DRIVER_NAME;
        string = TRIAL ? string + " Trial " : string + " Full ";
        string = CLIENT_VERSION ? string + "Client " : string + "Server ";
        string = string + "4.2.243";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLicense() {
        String string = "No license";
        PublicKeyStoreParamImpl publicKeyStoreParamImpl = new PublicKeyStoreParamImpl();
        CipherParamImpl cipherParamImpl = new CipherParamImpl();
        LicenseParamImpl licenseParamImpl = new LicenseParamImpl(publicKeyStoreParamImpl, cipherParamImpl);
        LicenseManager licenseManager = new LicenseManager(licenseParamImpl);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("license.lic");
        LicenseContent licenseContent = null;
        String string2 = "testuser@unityjdbc.com";
        String string3 = "Trial User";
        String string4 = DRIVER_NAME;
        if (inputStream != null) {
            try {
                licenseManager.install(inputStream);
                licenseContent = licenseManager.verify();
                Boolean[] booleanArray = (Boolean[])licenseContent.getExtra();
                if (booleanArray != null) {
                    CLIENT_VERSION = booleanArray[1];
                    TRIAL = booleanArray[0];
                    String string5 = licenseContent.getHolder().toString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string5, ",=");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string6 = stringTokenizer.nextToken().trim();
                        if (string6.equals("EMAILADDRESS")) {
                            string2 = stringTokenizer.nextToken();
                            continue;
                        }
                        if (string6.equals("CN")) {
                            string3 = stringTokenizer.nextToken();
                            continue;
                        }
                        if (!string6.equals("O")) continue;
                        string4 = stringTokenizer.nextToken();
                    }
                    string = "Licensed to: \n" + string3 + "\n" + string4 + "\n" + string2;
                }
            }
            catch (Exception exception) {
            }
            finally {
                FileManager.closeStream(inputStream);
            }
        }
        return string;
    }

    public static ResultSet translate(String string) {
        return null;
    }

    public static String getURLFilePath(String string) {
        int n = string.lastIndexOf(63);
        if (n >= 0) {
            return string.substring(string.toLowerCase().indexOf(JDBC_URL) + 13, n);
        }
        return string.substring(string.toLowerCase().indexOf(JDBC_URL) + 13);
    }

    public static boolean isTrial() {
        return TRIAL;
    }

    static {
        try {
            DriverManager.registerDriver(new UnityDriver());
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Failed to register UnityJDBC Driver: " + sQLException);
        }
    }
}

