/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.operators.Operator;
import unity.util.Convert;

public class HadoopScan
extends Operator {
    private static final long serialVersionUID = 1L;
    private FileSystem fileSystem;
    private boolean dataComplete;
    private BufferedReader br;
    private FileStatus[] files;
    private int fileLoc;
    private String path;

    public HadoopScan(String string, Relation relation) {
        this.path = string;
        this.setOutputRelation(relation);
    }

    @Override
    public void init() throws SQLException {
        this.fileLoc = 0;
        this.dataComplete = false;
        try {
            this.fileSystem = FileSystem.get((Configuration)new Configuration());
            this.files = this.fileSystem.listStatus(new Path(this.path));
            this.getNextFile();
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        try {
            return this.readRow(tuple);
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.fileSystem.close();
        }
        catch (IOException iOException) {
            throw new SQLException(iOException);
        }
    }

    public String toString() {
        return "HDFS SCAN: (Path=" + this.path + ")";
    }

    @Override
    public String getName() {
        return "HDFS SCAN";
    }

    @Override
    public String getDescription() {
        return "";
    }

    private void getNextFile() throws IOException {
        this.br = null;
        while (this.files != null && this.fileLoc < this.files.length) {
            FileStatus fileStatus;
            if ((fileStatus = this.files[this.fileLoc++]).isDir() || fileStatus.getPath().toString().contains("_SUCCESS")) continue;
            FSDataInputStream fSDataInputStream = this.fileSystem.open(fileStatus.getPath());
            this.br = new BufferedReader(new InputStreamReader((InputStream)fSDataInputStream));
            break;
        }
        if (this.br == null) {
            this.dataComplete = true;
        }
    }

    private boolean readRow(Tuple tuple) throws Exception {
        while (!this.dataComplete) {
            String string = this.br.readLine();
            System.out.println(string);
            if (string == null) {
                this.getNextFile();
                this.dataComplete = this.br == null;
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|\t");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            Object[] objectArray = new Object[this.outputRelation.getNumAttributes()];
            for (int i = 0; i < this.outputRelation.getNumAttributes(); ++i) {
                objectArray[i] = Convert.convertStringToObject((String)arrayList.get(i), this.outputRelation.getAttributeType(i), "yyyy-MM-dd", "HH:mm:ss", "yyyy-MM-dd HH:mm:ss");
            }
            tuple.setValues(objectArray);
            return true;
        }
        return false;
    }
}

