/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.map;

import edu.berkeley.nlp.lm.array.LongArray;
import edu.berkeley.nlp.lm.util.Annotations;
import java.io.Serializable;

class CompressedMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Annotations.PrintMemoryCount
    LongArray compressedKeys;
    @Annotations.PrintMemoryCount
    private LongArray uncompressedKeys;
    private long numKeys;

    CompressedMap() {
    }

    public long add(long key) {
        this.uncompressedKeys.addWithFixedCapacity(key);
        return this.uncompressedKeys.size();
    }

    public long size() {
        return this.uncompressedKeys == null ? this.numKeys : this.uncompressedKeys.size();
    }

    public void init(long l) {
        this.uncompressedKeys = LongArray.StaticMethods.newLongArray(Long.MAX_VALUE, l, l);
    }

    public void trim() {
        this.uncompressedKeys.trim();
    }

    public void clearUncompressedKeys() {
        this.numKeys = this.uncompressedKeys.size();
        this.uncompressedKeys = null;
    }

    public LongArray getUncompressedKeys() {
        return this.uncompressedKeys;
    }
}

