/* This is a dummy code file that only contains doxygen main page
   documentation.  It has a .cxx extension so that emacs will happily
   autoindent correctly. */

/** \mainpage SimGear
 * Simulation, Visualization, and Game development libraries.

 * \section intro Introduction
 *
 * SimGear is a collection of libraries which provide a variety of
 * functionality useful for building simulations, visualizations, and
 * even games.  All the SimGear code is designed to be portable across
 * a wide variety of platforms and compilers.  It has primarily been
 * developed in support of the FlightGear project, but as development
 * moves forward, we are generalizing the code to make more of it
 * useful for other types of applications.
 *
 * Some of the functionality provide includes
 *
 * - Compiler and platform abstractions for many tricky differences.
 * - A whole earth tiling/indexing scheme.
 * - A console debugging output scheme that tracks severity and
 *   category that can be completely compiled out for a final build release.
 * - Code to manage "real" time and time zones.
 * - Code to calculate accurate positions of sun, moon, stars, and
 *   planets for a given time, date, season, earth location, etc.
 * - Simple serial, file, and network I/O abstractions
 * - Code to calculate magnetic variation.
 * - A variety of coordinate conversion, vector, matrix type math routines.
 * - An abstraction to hide platform dependent path naming schemes.
 * - A C++ streams wrapper to handle compress input/output streams.
 * - An optimized "property manager" which associates ascii property
 *   names with their corresponding value.  This can be a great way to build
 *   loose linkages between modules, or build linkages/connections that can
 *   be determined from config files or at runtime.
 * - Scene management and drawing routines:
 *   - material property management
 *   - object management
 *   - terrain tile management and paging
 *   - sky dome rendering (with ephemeral objects)
 * - Code to handle screen dumps (and ultra-hires tile rendered screen dumps)
 * - A sound effects manager.
 * - A threading abstraction.
 * - A simple but highly functional XML parser that interfaces nicely
 *   with the property manager.

 * \section supports Supported Platforms
 * SimGear has been built on the following platforms:
 *
 *   - Linux (x86)
 *   - Windows (MSVC, Cygwin, Mingwin)
 *   - SGI (native compilers)
 *   - Mac OS X
 *   - FreeBSD
 
 * \section depends Dependencies
 *
 * SimGear depends on several other open source packages.  These must
 * be installed before SimGear can be installed:
 *
 *   - glut and opengl
 *   - plib (http://plib.sf.net)
 *   - metakit
 *   - zlib
 *   - libjpeg (optional)
 *   - pthread (optional)
 
 * \section license Licensing
 *
 * SimGear is licensed under the terms of the LGPL

 * \section install Installation
 *
 * \subsection step1 Step 1: Opening the box
 *  
 * etc...
 */

