// moon.hxx -- model earth's moon
//
// Written by Durk Talsma. Originally started October 1997, for distribution  
// with the FlightGear project. Version 2 was written in August and 
// September 1998. This code is based upon algorithms and data kindly 
// provided by Mr. Paul Schlyter. (pausch@saaf.se). 
//
// Separated out rendering pieces and converted to ssg by Curt Olson,
// March 2000
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA  02111-1307, USA.
//
// $Id: moon.hxx,v 1.2 2004/01/09 10:19:00 ehofman Exp $


#ifndef _SG_MOON_HXX_
#define _SG_MOON_HXX_


#include <plib/ssg.h>

#include <simgear/misc/sg_path.hxx>


class SGMoon {

    ssgTransform *moon_transform;
    ssgSimpleState *orb_state;
    ssgSimpleState *halo_state;

    ssgColourArray *cl;

    ssgVertexArray *halo_vl;
    ssgTexCoordArray *halo_tl;

    double prev_moon_angle;

public:

    // Constructor
    SGMoon( void );

    // Destructor
    ~SGMoon( void );

    // build the moon object
    ssgBranch *build( SGPath path, double moon_size );

    // repaint the moon colors based on current value of moon_anglein
    // degrees relative to verticle
    // 0 degrees = high noon
    // 90 degrees = moon rise/set
    // 180 degrees = darkest midnight
    bool repaint( double moon_angle );

    // reposition the moon at the specified right ascension and
    // declination, offset by our current position (p) so that it
    // appears fixed at a great distance from the viewer.  Also add in
    // an optional rotation (i.e. for the current time of day.)
    bool reposition( sgVec3 p, double angle,
		     double rightAscension, double declination,
		     double moon_dist  );
};


#endif // _SG_MOON_HXX_
