# Copyright (C) 2011, Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import datetime
from gettext import gettext as _
from os.path import exists

from sugar_server import env, registry
from sugar_server.rest import XMLRest


etc = env.import_from('etc')
_logger = env.get_logger('inventario')


def CMD_sync(args):
    rest = XMLRest(etc.inventario_url.value,
            etc.inventario_user.value, etc.inventario_password.value)

    cp_path = env.var_path('inventario.checkpoint')
    if exists(cp_path):
        cp = int(os.stat(cp_path).st_mtime)
    else:
        cp = 0

    stolen = set([i['serial-number'] for i in \
            rest.get('/laptops/requestBlackList').get('record', [])])
    registered = []
    activated = {}
    revealed = []

    for row in registry.find('machines'):
        if row.get('registered', 0) > cp:
            registered.append({'serial-number': row['machine_sn']})
        if row.get('activated', 0) > cp:
            activated[row['machine_sn']] = \
                    datetime.date.fromtimestamp(int(row['activated']))
        if row.get('revealed', 0) > cp or \
                row['machine_sn'] in stolen and \
                row.get('activation_requested', 0) > cp:
            revealed.append({'serial-number': row['machine_sn']})

    if not registered and not activated and not revealed:
        _logger.info('No data to send to inventario')
        return

    _logger.info('Inventario notifications for %s, ' \
            'registered=%r activated=%r revealed=%r',
            rest.url, registered, activated, revealed)

    if registered:
        rest.post('/places/reportLaptops',
            {'laptops-serials': registered})
    if activated:
        rest.post('/laptops/reportActivatedLaptops',
            {'laptops-info': activated, 'hostname': env.hostname.value})
    if revealed:
        rest.post('/laptops/reportStolenLaptops',
            {'stolen-laptops': revealed, 'hostname': env.hostname.value})

    file(cp_path, 'w').close()
    _logger.info('Inventario notifications were sent successfully')
