# Copyright (C) 2012, Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# pylint: disable-msg=E1101,E0102

import active_document as ad

from sugar_network_server import env
from sugar_network_server.resources.resource import Resource, Vote


class Context(Resource):

    @ad.active_property(slot=1, prefix='T',
            permissions=ad.ACCESS_CREATE | ad.ACCESS_READ,
            typecast=env.CONTEXT_TYPES)
    def type(self, value):
        return value

    @ad.active_property(slot=2, prefix='N', full_text=True,
            permissions=ad.ACCESS_READ, default='')
    def name(self, value):
        return value

    @ad.active_property(prefix='M',
            full_text=True, default=[], typecast=[])
    def implement(self, value):
        return value

    @implement.setter
    def implement(self, value):
        return value

    @ad.active_property(slot=3, prefix='S', full_text=True)
    def title(self, value):
        return value

    @title.setter
    def title(self, value):
        return value

    @ad.active_property(slot=4, prefix='R', full_text=True)
    def summary(self, value):
        return value

    @summary.setter
    def summary(self, value):
        return value

    @ad.active_property(prefix='D', full_text=True)
    def description(self, value):
        return value

    @description.setter
    def description(self, value):
        return value

    @ad.active_property(slot=5, prefix='H', default='', full_text=True)
    def homepage(self, value):
        return value

    @homepage.setter
    def homepage(self, value):
        return value

    @ad.active_property(ad.BlobProperty)
    def icon(self, value):
        return value

    @ad.active_property(ad.CounterProperty, slot=6)
    def rating(self, value):
        return value

    @ad.active_property(Vote, counter='rating')
    def vote(self, value):
        return value

    @vote.setter
    def vote(self, value):
        return value
