# Copyright (C) 2012, Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# pylint: disable-msg=E1101,E0102

from gettext import gettext as _

import active_document as ad
import restful_document as rd

enforce = ad.util.enforce


class Resource(rd.Document):

    @ad.active_property(prefix='OA', typecast=[])
    def author(self, value):
        return value

    @author.setter
    def author(self, value):
        return value

    @ad.active_property(prefix='OT', full_text=True, default=[], typecast=[])
    def tags(self, value):
        return value

    @tags.setter
    def tags(self, value):
        return value

    @rd.restful_method(method='PUT')
    def restful_put(self, prop=None, url=None):
        enforce(rd.principal.user in self['author'],
                rd.Forbidden, _('Access is not permitted for not authors'))
        rd.Document.restful_put(self, prop, url)

    @rd.restful_method(method='DELETE')
    def restful_delete(self, prop=None):
        enforce(rd.principal.user in self['author'],
                rd.Forbidden, _('Access is not permitted for not authors'))
        rd.Document.restful_delete(self, prop)


class Vote(ad.AggregatorProperty):

    @property
    def value(self):
        #return rd.principal.user
        return 'foo'
