# Copyright (C) 2011, Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gobject
from gettext import gettext as _

from sugar_client import printf


def register(url=None):
    from sugar_client import server
    return _call(server.Service, True,
            lambda service: service.Register(url or ''))


def update_status():
    from sugar_client import server
    return _call(server.Service, False,
            lambda service: service.update_status())


def backup_journal(url=None):
    import sugar_client.backup as backup_
    return _call(backup_.Service, True,
            lambda service: service.Backup(url or ''))


def restore_journal(url=None, date=None):
    import sugar_client.backup as backup_
    return _call(backup_.Service, True,
            lambda service: service.Restore(url or '', date or 0))


def update_system():
    from sugar_client import system
    return _call(system.Service, True,
            lambda service: service.Update())


def monitor():
    from sugar_client import stats
    return _call(stats.Service, True,
            lambda service: service.ping())


def _call(service_class, wait, cb):
    service = service_class()
    mainloop = gobject.MainLoop()
    state = []

    def progress_cb(iface, changed_props, invalidated_props):
        if 'Info' in changed_props:
            printf.info(changed_props['Info'])
        if 'Progress' in changed_props:
            printf.progress('%d%%' % changed_props['Progress'])
        if 'State' in changed_props and changed_props['State'] < 10:
            state.append(int(changed_props['State']))
            mainloop.quit()

    service.PropertiesChanged = progress_cb

    result = cb(service)
    if not wait:
        return result

    try:
        mainloop.run()
        return 0 if state[0] == 0 else 1
    except KeyboardInterrupt:
        if hasattr(service, 'Cancel'):
            service.Cancel()
        printf.info(_('Aborted'))
        return 1
