#!/bin/sh

# chkconfig: - 80 30
# description: sugar-network-server

### BEGIN INIT INFO
# Provides:          sugar-network
# Required-Start:    $all
# Required-Stop:     $network
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: sugar-network
# Description:       sugar-network
### END INIT INFO

PROG="sugar-network-server"
NAME="sugar-network"
USER="sugar-network"
RETVAL=0

case "$1" in
    start)
        echo -n "Starting $NAME..."
        su $USER -c "$PROG start"
        RETVAL=$?
        if [ $RETVAL -eq 0 ]; then
            echo "ok"
        else
            echo "failed"
        fi
        ;;
    status)
        $PROG status
        RETVAL=$?
        ;;
    stop)
        echo -n "Stopping $NAME..."
        $PROG stop
        RETVAL=$?
        if [ $RETVAL -eq 0 ]; then
            echo "ok"
        else
            echo "failed"
        fi
        ;;
    restart)
        $0 stop
        sleep 3
        $0 start
        RETVAL=$?
        ;;
    reload)
        $0 reload
        RETVAL=$?
        ;;
    *)
        echo "Usage: $0 {start|stop|status|restart}"
        exit 1
esac

exit $RETVAL
