# Copyright (C) 2012, Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# pylint: disable-msg=E1101,E0102

import active_document as ad

from sugar_network_server.resources.resource import Resource, Vote


class Idea(Resource):

    @ad.active_property(prefix='C',
            permissions=ad.ACCESS_CREATE | ad.ACCESS_READ)
    def context(self, value):
        return value

    @ad.active_property(slot=2, prefix='S', full_text=True)
    def title(self, value):
        return value

    @title.setter
    def title(self, value):
        return value

    @ad.active_property(full_text=True)
    def content(self, value):
        return value

    @content.setter
    def content(self, value):
        return value

    @ad.active_property(ad.CounterProperty, slot=3)
    def rating(self, value):
        return value

    @ad.active_property(Vote, counter='rating')
    def vote(self, value):
        return value

    @vote.setter
    def vote(self, value):
        return value
