#!/usr/bin/env python

import logging
import gobject
import dbus.mainloop.glib

import sugar_stats


class _Collector(object):

    def __init__(self, sniffers_, *args):
        self.sniffers = {}
        for cls in sniffers_:
            sniffer = self.sniffers[cls.__module__] = cls(self)
            sniffer.start()

    def sniffer(self, name):
        return self.sniffers[name]

    def close(self):
        pass

    def update(self, stat, value, instance=None):
        postfix = ''
        if instance is not None:
            postfix = instance
        print '%-20s%-10s%s' % (stat, value, postfix)

logging.basicConfig(level=logging.DEBUG)

gobject.threads_init()
dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)

sugar_stats.start(None, _Collector)

mainloop = gobject.MainLoop()
try:
    mainloop.run()
except KeyboardInterrupt:
    pass
finally:
    sugar_stats.stop()
