#!/usr/bin/env python
# sugar-lint: disable

import time

import gobject

from __init__ import tests

import active_document as ad
import restful_document as rd

from sugar_stats import server


class ServerTest(tests.Test):

    def setUp(self):
        tests.Test.setUp(self)
        server.stats.value = True
        server.stats_root.value = 'stats'
        server.stats_step.value = 1
        rd.principal._user = 'fake-user'
        ad.data_root.value = 'db'

    def test_stats(self):
        ts = int(time.time())
        user = server.User('fake-user')

        self.assertEqual(
                {
                    'enable': True,
                    'status': {},
                    'rras': server.stats_client_rras.value,
                    'step': server.stats_step.value,
                    },
                user._stats_info())

        rd.request.content = {
                'name': 'test',
                'values': [(ts + 1, {'field': '1'})],
                }
        user._stats_upload()

        self.assertEqual(
                {
                    'enable': True, 'status': {
                        'test': ts + 2,
                        },
                    'rras': server.stats_client_rras.value,
                    'step': server.stats_step.value,
                    },
                user._stats_info())

        rd.request.content = {
                'name': 'test',
                'values': [(ts + 2, {'field': '2'})],
                }
        user._stats_upload()

        self.assertEqual(
                {
                    'enable': True, 'status': {
                        'test': ts + 3,
                        },
                    'rras': server.stats_client_rras.value,
                    'step': server.stats_step.value,
                    },
                user._stats_info())

        rd.request.content = {
                'name': 'test2',
                'values': [(ts + 3, {'field': '3'})],
                }
        user._stats_upload()

        self.assertEqual(
                {
                    'enable': True, 'status': {
                        'test': ts + 3,
                        'test2': ts + 4,
                        },
                    'rras': server.stats_client_rras.value,
                    'step': server.stats_step.value,
                    },
                user._stats_info())


if __name__ == '__main__':
    tests.main()
