# sugar-lint: disable

import os
import sys
import pwd
import time
import shutil
import signal
import logging
import httplib
import urlparse
import unittest
import traceback
import subprocess
import BaseHTTPServer
from os.path import dirname, join, exists, abspath

import gobject
import dbus.glib
import dbus.mainloop.glib

from sugar_client import env as _env
_env.BaseService = _env.LocalService

import sugar_client
from sugar_client import util as _util, service as _service, pms as _pms


root = abspath(dirname(__file__))
tmproot = join(root, '.tmp')
tmpdir = None

gobject.threads_init()
dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)


class Pwd(object):

    def __init__(self, pw):
        self.pw_name = pw.pw_name
        self.pw_uid = pw.pw_uid
        self.pw_gid = pw.pw_gid
        self.pw_dir = pw.pw_dir


class Pms(object):

    updates = []
    updated = []
    reboot_packages = []
    relogin_packages = []

    def __init__(self, update_args, environ):
        Pms.update_args = update_args
        Pms.environ = environ

    def update_metadata(self):
        pass

    def to_update(self):
        return Pms.updates

    def cleanup(self):
        pass

    def update(self):
        Pms.updated.append(True)
        del Pms.updates[:]


def main():
    shutil.rmtree(tmproot, ignore_errors=True)
    unittest.main()


class Test(unittest.TestCase):

    httpd_pids = {}

    def setUp(self):
        self._overriden = []

        global tmpdir
        tmpdir = join(tmproot, '.'.join(self.id().split('.')[1:]))
        shutil.rmtree(tmpdir, ignore_errors=True)
        os.makedirs(tmpdir)
        os.chdir(tmpdir)

        logfile = tmpdir + '.log'
        if exists(logfile):
            os.unlink(logfile)

        self._logfile = file(logfile + '.out', 'a')
        sys.stdout = sys.stderr = self._logfile

        for handler in logging.getLogger().handlers:
            logging.getLogger().removeHandler(handler)
        logging.basicConfig(level=logging.DEBUG, filename=logfile)

        os.environ['TMPDIR'] = join(tmpdir, 'tmp')
        os.makedirs('tmp')

        sugar_client.set_profile_dir(join(tmpdir, 'sugar'))
        _env.debug.value = True
        _env.backup_timeout.value = 0
        _env.update_timeout.value = 0
        _env.uid.value = None
        _env.schoolserver.value = None
        _env.nickname.value = 'test'

        Pms.updates = []
        Pms.updated = []
        Pms.reboot_packages = []
        Pms.relogin_packages = []
        self.override(_pms, 'get', lambda *args: Pms(*args))

    def tearDown(self):
        errors = []
        while Test.httpd_pids:
            errors.extend(self.httpdown(Test.httpd_pids.keys()[0]))

        while self._overriden:
            mod, name, old_handler = self._overriden.pop(0)
            setattr(mod, name, old_handler)

        sys.stdout.flush()

        self.assertEqual([], errors)

    def override(self, mod, name, new_handler):
        self._overriden.append((mod, name, getattr(mod, name)))
        setattr(mod, name, new_handler)

    def touch(self, *files):
        for i in files:
            if isinstance(i, str):
                if i.endswith(os.sep):
                    i = i + '.stamp'
                path = i
                if exists(path):
                    content = file(path).read()
                else:
                    content = i
            else:
                path, content = i
                if isinstance(content, list):
                    content = '\n'.join(content)
            path = join(tmpdir, path)

            if not exists(dirname(path)):
                os.makedirs(dirname(path))
            if exists(path):
                os.unlink(path)

            f = file(path, 'w')
            f.write(str(content))
            f.close()

    def httpd(self, port, *files):
        if port in Test.httpd_pids:
            self.httpdown(port)

        child_pid = os.fork()
        if child_pid:
            time.sleep(0.25)
            Test.httpd_pids[port] = child_pid
            return

        try:
            files = list(files)
            sys.stdout = file(join(tmpdir, 'httpd.%s' % port), 'w')
            sys.stderr = sys.stdout
            server = BaseHTTPServer.HTTPServer(('localhost', port),
                    lambda * args: _HTTPHandler(files, *args))
            for __ in range(len(files) + 1):
                server.handle_request()
                sys.stdout.flush()
        except Exception:
            traceback.print_exc()
        os._exit(0)

    def httpdown(self, port):
        pid = Test.httpd_pids[port]
        del Test.httpd_pids[port]

        errors = []

        try:
            conn = httplib.HTTPConnection('localhost', port)
            conn.request('GET', '/ping')
            assert conn.getresponse().status == 200, \
                    'Not all requests were valid to %s' % port
        except Exception, error:
            errors.append(error)
        finally:
            os.kill(pid, signal.SIGTERM)
            os.waitpid(pid, 0)

        return errors


class _HTTPHandler(BaseHTTPServer.BaseHTTPRequestHandler):

    _fail = False

    def __init__(self, files, request, client_address, server):
        self._files = files
        BaseHTTPServer.BaseHTTPRequestHandler.__init__(self,
                request, client_address, server)

    def do_GET(self):
        parsed = urlparse.urlparse(self.path)

        if parsed.path == '/ping':
            if _HTTPHandler._fail or self._files:
                self._404('pong')
            else:
                self._reply(200, 'pong')
            return

        if not self._files:
            self._404('Empty requests queue on %s' % parsed.path)
        else:
            path, content = self._files.pop(0)
            if parsed.geturl() != path:
                self._404('Expected %s; got %s' % (path, parsed.geturl()))
            elif isinstance(content, int):
                self._reply(content, content)
            else:
                self._reply(200, content)

    def do_POST(self):
        parsed = urlparse.urlparse(self.path)

        if not self._files:
            self._404('Empty requests queue on %s' % parsed.query)
        else:
            path, content = self._files.pop(0)
            if not path.startswith('POST:') or \
                    path.split(':', 1)[-1] != parsed.geturl():
                self._404('Expected %s; got %s' % (path, parsed.geturl()))
            else:
                self._reply(200, content)

    def _404(self, error):
        self.send_error(404, error)
        _HTTPHandler._fail = True

    def _reply(self, code, content):
        self.send_response(code)
        self.end_headers()
        self.wfile.write(content)
        self.wfile.flush()
