#!/usr/bin/env python

# sugar-lint: disable

import gconf
import gobject

from __init__ import tests

from sugar_client import env, server
from sugar_client.rest import JSONRest


class Ticket3269Test(tests.Test):

    def setUp(self):
        tests.Test.setUp(self)
        self.mainloop = gobject.MainLoop()
        self.service = server.Service()

        def on_finished():
            if self.mainloop.is_running():
                self.mainloop.quit()

        self.service.on_finished = on_finished

    def test_Register(self):
        request = {}
        env._XO_SERIAL_PATH = 'sn'
        env._XO_UUID_PATH = 'uuid'
        env.nickname.value = None

        self.touch(
                ('sn', 'sn'),
                ('uuid', 'uuid'),
                )

        def cb(rest, key, args):
            request.update(args)
            return {'success': 'OK', 'uid': 'UID'}

        self.override(JSONRest, 'post', cb)
        self.touch(('sugar/owner.key.pub', 'ssh-dss pubkey'))

        self.service.Register('http://localhost:8080')
        self.mainloop.run()
        self.assertEqual(0, self.service.State)
        self.assertEqual('sn', request.get('machine_sn'))
        self.assertEqual('uuid', request.get('machine_uuid'))

        gconf_client = gconf.client_get_default()
        self.assertEqual(gconf_client.get_string(env._NICKNAME_GCONF), request.get('nickname'))


if __name__ == '__main__':
    tests.main()
