#!/usr/bin/env python

# sugar-lint: disable

import gtk

from __init__ import tests

from sugar_client import env, system


class SystemTest(tests.Test):

    def setUp(self):
        tests.Test.setUp(self)

        def on_finished():
            gtk.main_quit()

        self.service = system.Service()
        self.service.on_finished = on_finished

    def tearDown(self):
        self.service.remove_from_connection()
        self.service = None
        tests.Test.tearDown(self)

    def test_Update_NoUpdates(self):
        self.service.Update()
        gtk.main()
        self.assertEqual(0, self.service.State)
        self.assertEqual([], tests.Pms.updated)

    def test_Update(self):
        tests.Pms.updates = ['foo']
        self.service.Update()
        gtk.main()
        self.assertEqual(0, self.service.State)
        self.assertEqual(1, len(tests.Pms.updated))

    def test_Update_NeedToReboot(self):
        self.service.Reboot = gtk.main_quit
        tests.Pms.reboot_packages = ['reboot']
        tests.Pms.updates = ['reboot']
        self.service.on_finished = None
        self.service.Update()
        gtk.main()

    def test_Update_NeedToRebootCompat(self):
        self.service._compat.Reboot = gtk.main_quit
        tests.Pms.reboot_packages = ['reboot']
        tests.Pms.updates = ['reboot']
        self.service.on_finished = None
        self.service.Update()
        gtk.main()

    def test_Update_NeedToRelogin(self):
        self.service.Relogin = gtk.main_quit
        tests.Pms.relogin_packages = ['relogin']
        tests.Pms.updates = ['relogin']
        self.service.on_finished = None
        self.service.Update()
        gtk.main()

    def test_Update_NeedToReloginCompat(self):
        self.service._compat.Relogin = gtk.main_quit
        tests.Pms.relogin_packages = ['relogin']
        tests.Pms.updates = ['relogin']
        self.service.on_finished = None
        self.service.Update()
        gtk.main()


if __name__ == '__main__':
    tests.main()
