# Copyright (C) 2012, Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from active_document import data_root, index_flush_timeout, \
        index_flush_threshold, index_write_queue, find_limit

from restful_document import host, port, debug, foreground, logdir, rundir, \
        trust_users, auth, keyfile, certfile, master

from sugar_stats_server import stats, stats_root, stats_step, \
        stats_server_rras, stats_client_rras

from sugar_network_server.resources import resources

from sugar_network_server.licenses import GOOD_LICENSES


def config(**kwargs):
    from gettext import gettext as _
    import restful_document

    return restful_document.config(
            name='sugar-network-server',
            description=_('Sugar Network server'),
            version='0.1',
            homepage='http://wiki.sugarlabs.org/go/Sugar_Network',
            **kwargs)
