# Copyright (C) 2012, Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# pylint: disable-msg=E1101,E0102

import active_document as ad
from sugar_stats_server import User as StatsUser


class User(StatsUser):

    @ad.active_property(prefix='T', full_text=True, default=[], typecast=[])
    def tags(self, value):
        return value

    @tags.setter
    def tags(self, value):
        return value

    @ad.active_property(ad.CounterProperty, slot=1)
    def reputation(self, value):
        return value

    @ad.active_property(slot=2, prefix='L', full_text=True, default='')
    def location(self, value):
        return value

    @location.setter
    def location(self, value):
        return value

    @ad.active_property(slot=3, prefix='B', default=0, typecast=int)
    def birthday(self, value):
        return value

    @birthday.setter
    def birthday(self, value):
        return value
