#!/usr/bin/env python

# sugar-lint: disable

import os
import sys
import time
import json
import signal
import random
import restkit
import logging


processes = 30
timeout = 2
time_to_stop = 300

assert len(sys.argv) == 2
url = 'http://%s' % sys.argv[1]

guids = {}
stat = {}
rest = None

control = {
        'C': [1, 0],
        'U': [0, 0],
        'F': [8, 0],
        'G': [0, 0],
        }

template = file('COPYING').read().split()


def randstr():
    result = []
    for i in range(10):
        result.append(template[random.randint(0, len(template) - 1)])
    return ' '.join(result)


def next(index):
    if not control[index][0]:
        return
    control[index][1] += 1
    if control[index][1] > control[index][0]:
        control[index][1] = 0
        stat.setdefault(index, [])
        yield


def sleep():
    time.sleep(timeout)


def iteration():
    document = '/document_%s' % random.randint(1, 9)

    for _ in next('C'):
        print '%-7s C' % os.getpid(), document
        ts = time.time()
        reply = json.loads(rest.post(document, payload=json.dumps({
            'prop_1': randstr(),
            'prop_2': randstr(),
            'prop_3': randstr(),
            'prop_4': randstr(),
            'prop_5': randstr(),
            'prop_6': randstr(),
            'prop_7': randstr(),
            'prop_8': randstr(),
            'prop_9': randstr(),
            }),
            headers={'Content-Type': 'application/json'},
            ).body_string())
        stat['C'].append(time.time() - ts)
        guids.setdefault(document, [])
        guids[document].append(reply['guid'])
        sleep()

    for _ in next('F'):
        print '%-7s F' % os.getpid(), document
        ts = time.time()
        reply = json.loads(rest.get(document,
            headers={'Content-Type': 'application/json'},
            limit=15).body_string())
        stat['F'].append(time.time() - ts)
        offset = len(reply['documents'])
        total = reply['total']
        while offset < total:
            sleep()
            ts = time.time()
            rest.get(document, headers={'Content-Type': 'application/json'},
                    offset=offset, limit=15)
            stat['F'].append(time.time() - ts)
            offset += 15
        sleep()

    for _ in next('G'):
        if document not in guids:
            continue
        print '%-7s G' % os.getpid(), document
        guid = guids[document][random.randint(0, len(guids[document]) - 1)]
        ts = time.time()
        rest.get(document + '/' + guid,
                headers={'Content-Type': 'application/json'})
        stat['G'].append(time.time() - ts)
        sleep()

    for _ in next('U'):
        if document not in guids:
            continue
        print '%-7s U' % os.getpid(), document
        guid = guids[document][random.randint(0, len(guids[document]) - 1)]
        ts = time.time()
        rest.put(document + '/' + guid, payload=json.dumps({
            'prop_1': randstr(),
            'prop_2': randstr(),
            'prop_3': randstr(),
            'prop_4': randstr(),
            'prop_5': randstr(),
            'prop_6': randstr(),
            'prop_7': randstr(),
            'prop_8': randstr(),
            'prop_9': randstr(),
            }),
            headers={'Content-Type': 'application/json'},
            )
        stat['U'].append(time.time() - ts)
        sleep()


def main():
    global rest
    manager = restkit.Manager(max_conn=10)
    rest = restkit.Resource(url, manager=manager)

    try:
        while True:
            iteration()
    except Exception:
        #logging.exception('!')
        pass
    except KeyboardInterrupt:
        pass
    finally:
        for name, times in stat.items():
            print '%s: %-10s %-18s %-18s %-18s' % (
                    name, len(times), min(times), sum(times) / len(times),
                    max(times))

seed = time.time()
pids = []
for i in range(processes):
    time.sleep(.1)
    random.seed(seed)
    seed += 1
    pid = os.fork()
    if not pid:
        main()
        exit(0)
    pids.append(pid)

try:
    time.sleep(time_to_stop)
except KeyboardInterrupt:
    pass

for pid in pids:
    os.kill(pid, signal.SIGINT)
    os.waitpid(pid, 0)
