/* shell.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Hight-level interface to interact with sugar shell process
 */
public class Sugar.Shell : Object {
    /**
     * Is activity active
     *
     * Activity is active when it is selected in activities list in the shell.
     */
    public bool active { get; private set; default = false; }

    construct {
        try {
            _shell = ShellService.instance ();
        } catch (Error error) {
            warning ("Cannot connecto to shell: %s", error.message);
        }

        try {
            _activity = new ActivityService ();
            _activity.object.set_active_cb = _set_active_cb;
        } catch (Error error) {
            warning ("Cannot create activity DBus service: %s", error.message);
        }
    }

    /**
     * Get activity info by bundle_id
     */
    public bool get_activity (string bundle_id, out ActivityInfo result) {
        if (_shell == null)
            return false;

        string bundle_path;

        try {
            bundle_path = _shell.object.GetBundlePath (bundle_id);
        } catch (Error error) {
            warning ("Cannot GetBundlePath from the shell for %s: %s",
                    bundle_id, error.message);
            return false;
        }

        if (bundle_path == null || bundle_path[0] == '\0') {
            debug ("Cannot find activity with bundle_id '%s'", bundle_id);
            return false;
        }

        return ActivityInfo.get (bundle_path, out result);
    }

    /**
     * Get activity info by bundle_id
     */
    /*
     * public Array<ActivityInfo> for_mime_type (string mime_type) {
     * return new Array<ActivityInfo> (false, true, 0);
     * registry = bundleregistry.get_registry()
     * result = registry.get_activities_for_type(mime_type)
     * if not result:
     * for parent_mime in mime.get_mime_parents(mime_type):
     * for activity in registry.get_activities_for_type(parent_mime):
     * if activity not in result:
     * result.append(activity)
     * return result
     * }
     */

    private void _set_active_cb (bool active) {
        this.active = active;
    }

    private ShellService _shell;
    private ActivityService _activity;
}
