/* datastore.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

private class Sugar.Datastore : Object {
    public signal void updated (string object_id);

    public DBus.Connection connection;
    public dynamic DBus.Object service;

    private Datastore () throws Error {
        connection = DBus.Bus.get (DBus.BusType.SESSION);
        service = connection.get_object (_NAME, _PATH, _INTERFACE);
        service.Updated.connect (_Updated_cb);
    }

    public static Datastore instance () throws Error {
        if (_instance == null)
            _instance = new Datastore ();
        return _instance;
    }

    private void _Updated_cb (DBus.Object sender, string object_id) {
        updated (object_id);
    }

    private const string _NAME = "org.laptop.sugar.DataStore";
    private const string _INTERFACE = "org.laptop.sugar.DataStore";
    private const string _PATH = "/org/laptop/sugar/DataStore";

    private static Datastore _instance;
}
