/* profile.c generated by valac 0.12.1, the Vala compiler
 * generated from profile.vala, do not modify */

/* profile.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/env.h"
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))

#define SUGAR_TYPE_CONFIG (sugar_config_get_type ())
#define SUGAR_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_TYPE_CONFIG, SugarConfig))
#define SUGAR_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_TYPE_CONFIG, SugarConfigClass))
#define SUGAR_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_TYPE_CONFIG))
#define SUGAR_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_TYPE_CONFIG))
#define SUGAR_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_TYPE_CONFIG, SugarConfigClass))

typedef struct _SugarConfig SugarConfig;
typedef struct _SugarConfigClass SugarConfigClass;
#define _sugar_config_unref0(var) ((var == NULL) ? NULL : (var = (sugar_config_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _sugar_xo_color_free0(var) ((var == NULL) ? NULL : (var = (sugar_xo_color_free (var), NULL)))
typedef struct _SugarParamSpecProfile SugarParamSpecProfile;

struct _SugarParamSpecProfile {
	GParamSpec parent_instance;
};


static gpointer sugar_profile_parent_class = NULL;

enum  {
	SUGAR_PROFILE_DUMMY_PROPERTY
};
static SugarProfile* sugar_profile_new (void);
static SugarProfile* sugar_profile_construct (GType object_type);
gpointer sugar_config_ref (gpointer instance);
void sugar_config_unref (gpointer instance);
GParamSpec* sugar_param_spec_config (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sugar_value_set_config (GValue* value, gpointer v_object);
void sugar_value_take_config (GValue* value, gpointer v_object);
gpointer sugar_value_get_config (const GValue* value);
GType sugar_config_get_type (void) G_GNUC_CONST;
SugarConfig* sugar_config_instance (void);
gchar* sugar_config_get_color (SugarConfig* self, GError** error);
gchar* sugar_config_get_nickname (SugarConfig* self, GError** error);
static void sugar_profile_finalize (SugarProfile* obj);

static const SugarXoColor SUGAR_PROFILE__default_color = {{1.0, (guint16) 0x0000, (guint16) 0x0000, (guint16) 0x0000}, {1.0, (guint16) 0xFFFF, (guint16) 0xFFFF, (guint16) 0xFFFF}};

static SugarProfile* sugar_profile_construct (GType object_type) {
	SugarProfile* self = NULL;
	self = (SugarProfile*) g_type_create_instance (object_type);
	return self;
}


static SugarProfile* sugar_profile_new (void) {
	return sugar_profile_construct (SUGAR_TYPE_PROFILE);
}


const gchar* sugar_profile_get_name (void) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* value;
	const gchar* _tmp2_ = NULL;
	_tmp0_ = g_getenv ("SUGAR_PROFILE");
	_tmp1_ = g_strdup (_tmp0_);
	value = _tmp1_;
	if (value == NULL) {
		_tmp2_ = "default";
	} else {
		_tmp2_ = value;
	}
	result = _tmp2_;
	_g_free0 (value);
	return result;
}


gchar* sugar_profile_get_path (void) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = sugar_profile_get_name ();
	_tmp2_ = g_build_filename (_tmp0_, SUGAR_ENVIRON_ROOT_DIRECTORY, _tmp1_, NULL);
	result = _tmp2_;
	return result;
}


void sugar_profile_get_color (SugarXoColor* result) {
	gchar* colors;
	SugarConfig* _tmp0_ = NULL;
	SugarConfig* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	SugarXoColor* _tmp5_ = NULL;
	SugarXoColor* xo_color;
	SugarXoColor* _tmp6_;
	SugarXoColor _tmp7_;
	GError * _inner_error_ = NULL;
	colors = NULL;
	_tmp0_ = sugar_config_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = sugar_config_get_color (_tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	_sugar_config_unref0 (_tmp1_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	_g_free0 (colors);
	colors = _tmp4_;
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("profile.vala:57: Cannot get color profile info: %s", e->message);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (colors);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (colors == NULL) {
		g_warning ("profile.vala:61: User color is empty, will use default");
		*result = SUGAR_PROFILE__default_color;
		_g_free0 (colors);
		return;
	}
	_tmp5_ = sugar_xo_color_from_string (colors);
	xo_color = _tmp5_;
	if (xo_color == NULL) {
		g_warning ("profile.vala:68: Cannot parse user color, will use default");
		*result = SUGAR_PROFILE__default_color;
		_sugar_xo_color_free0 (xo_color);
		_g_free0 (colors);
		return;
	}
	_tmp6_ = xo_color;
	_tmp7_ = *_tmp6_;
	_sugar_xo_color_free0 (_tmp6_);
	*result = _tmp7_;
	_g_free0 (colors);
	return;
}


gchar* sugar_profile_get_nickname (void) {
	gchar* result;
	SugarConfig* _tmp0_ = NULL;
	SugarConfig* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	_tmp0_ = sugar_config_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = sugar_config_get_nickname (_tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	_sugar_config_unref0 (_tmp1_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	result = _tmp4_;
	return result;
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("profile.vala:84: Cannot get nickname profile info: %s", e->message);
		_tmp5_ = g_strdup ("");
		result = _tmp5_;
		_g_error_free0 (e);
		return result;
	}
	__finally3:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void sugar_value_profile_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void sugar_value_profile_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		sugar_profile_unref (value->data[0].v_pointer);
	}
}


static void sugar_value_profile_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sugar_profile_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer sugar_value_profile_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* sugar_value_profile_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SugarProfile* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sugar_profile_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* sugar_value_profile_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SugarProfile** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sugar_profile_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* sugar_param_spec_profile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SugarParamSpecProfile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SUGAR_TYPE_PROFILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer sugar_value_get_profile (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_TYPE_PROFILE), NULL);
	return value->data[0].v_pointer;
}


void sugar_value_set_profile (GValue* value, gpointer v_object) {
	SugarProfile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_TYPE_PROFILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SUGAR_TYPE_PROFILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sugar_profile_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sugar_profile_unref (old);
	}
}


void sugar_value_take_profile (GValue* value, gpointer v_object) {
	SugarProfile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_TYPE_PROFILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SUGAR_TYPE_PROFILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sugar_profile_unref (old);
	}
}


static void sugar_profile_class_init (SugarProfileClass * klass) {
	sugar_profile_parent_class = g_type_class_peek_parent (klass);
	SUGAR_PROFILE_CLASS (klass)->finalize = sugar_profile_finalize;
}


static void sugar_profile_instance_init (SugarProfile * self) {
	self->ref_count = 1;
}


static void sugar_profile_finalize (SugarProfile* obj) {
	SugarProfile * self;
	self = SUGAR_PROFILE (obj);
}


/**
 * Current user profile
 */
GType sugar_profile_get_type (void) {
	static volatile gsize sugar_profile_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_profile_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { sugar_value_profile_init, sugar_value_profile_free_value, sugar_value_profile_copy_value, sugar_value_profile_peek_pointer, "p", sugar_value_profile_collect_value, "p", sugar_value_profile_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SugarProfileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_profile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarProfile), 0, (GInstanceInitFunc) sugar_profile_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType sugar_profile_type_id;
		sugar_profile_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SugarProfile", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&sugar_profile_type_id__volatile, sugar_profile_type_id);
	}
	return sugar_profile_type_id__volatile;
}


gpointer sugar_profile_ref (gpointer instance) {
	SugarProfile* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void sugar_profile_unref (gpointer instance) {
	SugarProfile* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SUGAR_PROFILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



