/* label.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

public class Sugar.Label : Gtk.Label {
    public int max_line_count {
        get {
            return _max_line_count;
        }
        set {
            value = int.max (0, value);
            if (value == max_line_count)
                return;

            _max_line_count = value;

            if (_max_lined)
                queue_resize ();
        }
    }

    public override void size_request (out Gtk.Requisition requisition) {
        base.size_request (out requisition);

        if (_max_lined) {
            int requested_width;
            get_size_request (out requested_width, null);

            if (requested_width > 0) {
                var layout = get_layout ();
                layout.set_width (requested_width * Pango.SCALE);
                layout.set_height (max_line_count * _line_height * Pango.SCALE);
                layout.get_pixel_size (
                        out requisition.width, out requisition.height);
            } else {
                Pango.Rectangle logical_rect;
                var layout = get_layout ();
                layout.get_extents (null, out logical_rect);
                requisition.width = _pixels (logical_rect.width);
            }
        }
    }

    public override void size_allocate (Gdk.Rectangle allocation) {
        if (_max_lined) {
            var layout = get_layout ();
            layout.set_width (allocation.width * Pango.SCALE);
            layout.set_height (max_line_count * _line_height * Pango.SCALE);
        }

        base.size_allocate (allocation);
    }

    private bool _max_lined {
        get {
            return ellipsize != Pango.EllipsizeMode.NONE &&
                    have_transform == 0 && !single_line_mode &&
                    max_line_count > 0;
        }
    }

    private int _line_height {
        get {
            var metrics = get_layout ().get_context ().get_metrics (
                    style.font_desc,
                    get_layout ().get_context ().get_language ());
            return _pixels (metrics.get_ascent () + metrics.get_descent ());
        }
    }

    private int _pixels (int pango_units) {
        /* PANGO_PIXELS */
        return (pango_units + 512) >> 10;
    }

    private int _max_line_count = 0;
}
