/* tooltext.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Plain string ToolItem
 *
 * Widget is aligned with go-*-paired icons.
 * For example it is possible to place toolbar buttons like:
 *
 *  go-previous-paired|ToolText|go-next-paired
 *
 */
public class Sugar.ToolText : Gtk.ToolItem {
    construct {
        _tool_widget = new PaintBin ();
        _tool_widget.modify_bg (Gtk.StateType.NORMAL,
                color_type_to_rgb (Color.WHITE));
        _tool_widget.show ();
        add (_tool_widget);

        _label_widget = new Gtk.Label ("");
        _label_widget.modify_fg (Gtk.StateType.NORMAL,
                color_type_to_rgb (Color.TOOLBAR_GREY));

        _label_widget.show ();
        _tool_widget.add (_label_widget);

        // TODO calculate font height according to actual widget size
        var font = Pango.FontDescription.from_string (
                Font.get (Font.NORMAL).name);
        font.set_absolute_size (Metrics.get (Metrics.STANDARD_ICON_SIZE) *
                0.6 * Pango.SCALE);
        _label_widget.modify_font (font);
    }

    public string text {
        get { return _label_widget.label; }
        set { _label_widget.label = value; }
    }

    public override void size_allocate (Gdk.Rectangle allocation) {
        int gap = (int) (allocation.height * _TEXT_GAP);
        int height = (int) (allocation.height * _TEXT_HEIGHT);

        _tool_widget.border_top = gap;
        _tool_widget.border_bottom = allocation.height - gap - height;

        base.size_allocate (allocation);
    }

    /** Padding factor between top margin and text bar */
    private static double _TEXT_GAP = 0.212;
    /** Height factor of text bar */
    private static double _TEXT_HEIGHT = 0.625;

    private PaintBin _tool_widget;
    private Gtk.Label _label_widget;
}
