##
# Exported variables:
#
#   PYTHONINTERP_FOUND
#   PYTHON_EXECUTABLE
#
#   PYTHONLIBS_FOUND
#   PYTHON_CFLAGS
#   PYTHON_LIBRARIES
#
#   PYTHON_CODEGEN_FOUND
#   PYTHON_CODEGEN
#   PYTHON_DEFSDIR
#
#   PYTHON_H2DEF_FOUND
#   PYTHON_H2DEF
##

find_package (PythonInterp)
find_package (PythonLibs)

# FindPythonLibs from cmake-2.8.1 is failed to find python-2.7

if (PYTHONLIBS_FOUND)
    if (PYTHON_INCLUDE_PATH)
        set (PYTHON_CFLAGS "-I${PYTHON_INCLUDE_PATH}")
    else ()
        set (PYTHON_CFLAGS "-I${PYTHON_INCLUDE_DIRS}")
    endif ()
else ()
    find_program (_python_config python-config)
    if (_python_config)
        message (STATUS "Found python-config: ${_python_config}")
        set (PYTHONLIBS_FOUND TRUE)

        execute_process (
            COMMAND ${_python_config} --includes
            OUTPUT_VARIABLE PYTHON_CFLAGS)
        string (STRIP "${PYTHON_CFLAGS}" PYTHON_CFLAGS)

        execute_process (
            COMMAND ${_python_config} --libs
            OUTPUT_VARIABLE PYTHON_LIBRARIES)
        string (STRIP "${PYTHON_LIBRARIES}" PYTHON_LIBRARIES)
    endif ()
endif ()

# Find codegen.py

if (PYTHONINTERP_FOUND)
    execute_process (
        COMMAND ${PKG_CONFIG_EXECUTABLE} --variable=codegendir pygobject-2.0
        OUTPUT_VARIABLE _codegendir)

    string (STRIP "${_codegendir}" _codegendir)

    if (EXISTS "${_codegendir}/codegen.py")
        set (PYTHON_CODEGEN "${_codegendir}/codegen.py")
    else ()
        set (PYTHON_CODEGEN "")
    endif ()

    find_package_handle_standard_args (PYTHON_CODEGEN DEFAULT_MSG PYTHON_CODEGEN)

    if (PYTHON_CODEGEN_FOUND)
        set (PYTHON_CODEGEN "${PYTHON_EXECUTABLE} ${PYTHON_CODEGEN}")

        execute_process (
            COMMAND ${PKG_CONFIG_EXECUTABLE} --variable=defsdir pygtk-2.0
            OUTPUT_VARIABLE PYTHON_DEFSDIR)

        string (STRIP "${PYTHON_DEFSDIR}" PYTHON_DEFSDIR)

        if (NOT PYTHON_DEFSDIR)
            message (FATAL_ERROR "Cannot get defsdir from pkg-config")
        endif ()
    endif ()
endif ()

# Find h2def.py

if (PYTHONINTERP_FOUND)
    execute_process (
        COMMAND ${PKG_CONFIG_EXECUTABLE} --variable=codegendir pygobject-2.0
        OUTPUT_VARIABLE _codegendir)

    string (STRIP "${_codegendir}" _codegendir)

    if (EXISTS "${_codegendir}/h2def.py")
        set (PYTHON_H2DEF "${_codegendir}/h2def.py")
    else ()
        set (PYTHON_H2DEF "")
    endif ()

    find_package_handle_standard_args (PYTHON_H2DEF DEFAULT_MSG PYTHON_H2DEF)

    if (PYTHON_H2DEF_FOUND)
        set (PYTHON_H2DEF "${PYTHON_EXECUTABLE} ${PYTHON_H2DEF}")
    endif ()
endif ()
