##
# Setup Vala environment
#
# Exported variables:
#
#   VALA_FOUND
#   VALA_C
#   VALA_VERSION
#
##

include (FindPackageHandleStandardArgs)

find_program (VALA_C NAMES valac)
mark_as_advanced (VALA_C)

find_package_handle_standard_args (Vala DEFAULT_MSG VALA_C)

if (VALA_FOUND)
    execute_process (COMMAND ${VALA_C} "--version"
        OUTPUT_VARIABLE VALA_VERSION)
    string (REPLACE "Vala" "" VALA_VERSION "${VALA_VERSION}")
    string (STRIP "${VALA_VERSION}" VALA_VERSION)

    if (Vala_FIND_VERSION)
        if ("${VALA_VERSION}" VERSION_LESS "${Vala_FIND_VERSION}")
            message (STATUS "Vala version '${VALA_VERSION}' is too old, "
                "'${Vala_FIND_VERSION}' is required")
            unset (VALA_FOUND)
            unset (VALA_C)
            unset (VALA_VERSION)
        endif ()
    endif ()
endif ()
