#!/usr/bin/env python

import __init__
import gtk
import gobject
import gui

class BoxPalette(gui.Palette):

    def __init__(self):
        gui.Palette.__init__(self)
        self.props.primary_text = 'primary_text'
        self.props.secondary_text = 'secondary_text'

        self.props.secondary = gtk.VBox()

        item = gui.MenuItem()
        item.props.label = 'item #1'
        self.props.secondary.add(item)

        item = gui.MenuItem()
        item.props.label = 'item #2'
        item.props.icon_name = 'go-left'
        self.props.secondary.add(item)

        item = gui.MenuItem()
        item.props.label = 'item #3'
        item.props.icon_name = 'go-right'
        self.props.secondary.add(item)

        item = gui.MenuItem()
        item.props.label = 'item #4'
        item.props.icon_name = 'go-up'
        self.props.secondary.add(item)

        item = gui.MenuItem()
        item.props.label = 'item #5 item #5 item #5 item #5 item #5 item #5'
        self.props.secondary.add(item)

        self.props.secondary.show_all()

class ActionsPalette(gui.Palette):

    def __init__(self):
        gui.Palette.__init__(self)
        self.props.primary_text = 'primary_text'
        self.props.secondary_text = 'secondary_text'

        self.props.secondary = gui.Menu()
        self.props.secondary.props.width = 300

        action = gtk.Action('1', 'action #1', None, None)
        self.props.secondary.insert_action(action)

        action = gtk.Action('2', 'action #2', None, None)
        action.props.icon_name = 'go-left'
        self.props.secondary.insert_action(action)

        action = gtk.Action('3', 'action #3', None, None)
        action.props.icon_name = 'go-right'
        self.props.secondary.insert_action(action)

        action = gtk.Action('4', 'action #4', None, None)
        action.props.icon_name = 'go-up'
        self.props.secondary.insert_action(action)

        action = gtk.Action('5', 'action #5 action #5 action #5', None, None)
        self.props.secondary.insert_action(action)

        self.props.secondary.show_all()

class CheckboxPalette(gui.Palette):

    def __init__(self):
        gui.Palette.__init__(self)
        self.props.primary_text = 'primary_text'
        self.props.secondary_text = 'secondary_text'

        self.props.secondary = gui.Menu()
        self.props.secondary.props.width = 300

        action = gtk.ToggleAction('1', 'action #1', None, None)
        self.props.secondary.insert_action(action)

        action = gtk.ToggleAction('2', 'action #2', None, None)
        self.props.secondary.insert_action(action)

        action = gtk.ToggleAction('3', 'action #3', None, None)
        self.props.secondary.insert_action(action)

        self.props.secondary.show_all()

class RadioPalette(gui.Palette):

    def __init__(self):
        gui.Palette.__init__(self)
        self.props.primary_text = 'primary_text'
        self.props.secondary_text = 'secondary_text'

        self.props.secondary = gui.Menu()

        group = gtk.RadioAction('1', 'action #1', None, None, 1)
        group.props.icon_name = 'emblem-warning'
        self.props.secondary.insert_action(group)

        action = gtk.RadioAction('2', 'action #2', None, None, 2)
        action.props.group = group
        action.props.icon_name = 'emblem-question'
        self.props.secondary.insert_action(action)

        action = gtk.RadioAction('3', 'action #3 action #3 action #3',
                None, None, 3)
        action.props.group = group
        self.props.secondary.insert_action(action)

        self.props.secondary.show_all()

class MenuPalette(gui.Palette):

    def __init__(self):
        gui.Palette.__init__(self)
        self.props.primary_text = 'primary_text'
        self.props.secondary_text = 'secondary_text'

        def cb(trigger, initiator):
            print initiator.props.tag.foo()

        self.props.menu_trigger.connect('activate', cb)

        menu = gui.Menu()
        menu.props.width = 300
        self.props.secondary = menu

        box = gtk.VBox()
        menu.add(box)

        class Foo(gobject.GObject):

            def foo(self):
                print 'foo'

        item = gui.MenuItem()
        item.props.label = 'item #1'
        item.props.tag = Foo()
        box.add(item)

        item = gui.MenuItem()
        item.props.label = 'item #2'
        item.props.icon_name = 'go-left'
        box.add(item)

        item = gui.MenuItem()
        item.props.label = 'item #3'
        item.props.icon_name = 'go-right'
        box.add(item)

        menu.insert_separator (-1);

        table = gui.Table()
        menu.insert_scrolled(table, 10, -1, -1)

        item = gui.MenuItem()
        item.props.label = 'item #1'
        table.add(item)

        item = gui.MenuItem()
        item.props.label = 'item #2'
        item.props.icon_name = 'go-left'
        table.add(item)

        item = gui.MenuItem()
        item.props.label = 'item #3'
        item.props.icon_name = 'go-right'
        table.add(item)

        menu.insert_separator (-1);

        table = gui.Table()
        menu.insert_scrolled(table, 1000, 300, -1)

        for i in range(33):
            item = gui.MenuItem()
            item.props.label = 'item #%s' % i
            item.props.icon_name = 'go-right'
            table.add(item)

        menu.show_all()

window = gui.Window()
window.connect('destroy', lambda sender: gtk.main_quit())

vbox = gtk.VBox()
window.add(vbox)

tool_bar = gtk.Toolbar()
vbox.pack_start(tool_bar, False)

button = gui.ToolButton()
button.props.icon_name = 'go-down'
button.props.invoker.props.palette = BoxPalette()
tool_bar.insert (button, -1);

button = gui.ToolButton()
button.props.icon_name = 'go-down'
button.props.invoker.props.palette = ActionsPalette()
tool_bar.insert (button, -1);

button = gui.ToolButton()
button.props.icon_name = 'go-down'
button.props.invoker.props.palette = CheckboxPalette()
tool_bar.insert (button, -1);

button = gui.ToolButton()
button.props.icon_name = 'go-down'
button.props.invoker.props.palette = RadioPalette()
tool_bar.insert (button, -1);

button = gui.ComboToolButton()
button.props.icon_name = 'go-down'
button.props.invoker.props.palette = MenuPalette()
tool_bar.insert (button, -1);

window.show_all()
gtk.main()
