#!/usr/bin/env python

import __init__
import gtk
import gui

window = gtk.Window()
window.connect('destroy', lambda sender: gtk.main_quit())

box = gtk.VBox()
window.add(box)

toolbox = gui.ToolbarBox()
box.pack_start (toolbox, False)

item = gui.ToolbarButton()
item.props.icon_name = 'emblem-busy'
item.props.page = gtk.Button('#1')
toolbox.props.toolbar.insert(item, -1)

item = gui.ToolbarButton()
item.props.icon_name = 'emblem-charging'
item.props.page = gtk.Button('#2')
toolbox.props.toolbar.insert(item, -1)

tool_bar = gtk.Toolbar()

button = gui.ToolButton()
button.show()
button.props.icon_name = 'go-left'
button.props.tooltip = 'tooltip';
tool_bar.insert (button, -1);

button = gui.ToolButton()
button.show()
button.props.icon_name = 'go-right'
button.props.tooltip = 'tooltip';
tool_bar.insert (button, -1);

item = gtk.ToolItem()
item.add(gtk.Entry())
item.show_all()
tool_bar.insert (item, -1);

item = gui.ToolbarButton()
item.props.icon_name = 'emblem-favorite'
item.props.page = tool_bar
toolbox.props.toolbar.insert(item, -1)

show = gui.ToolButton()
show.show()
show.props.icon_name = 'go-left'
show.props.tooltip = 'show';
def cb(sender):
    if hide.props.parent is None:
        toolbox.props.toolbar.insert(hide, -1)
show.connect('clicked', cb)
toolbox.props.toolbar.insert(show, -1)

hide = gui.ToolButton()
hide.show()
hide.props.icon_name = 'go-right'
hide.props.tooltip = 'hide';
def cb(sender):
    toolbox.props.toolbar.remove(hide)
hide.connect('clicked', cb)
toolbox.props.toolbar.insert(hide, -1)

window.show_all()
gtk.main()
