include (Util)
include (ParseArguments)

##
# Initilize component scale variables
#
# Exported variables:
#
#   GEN_DIR
#   CURRENT_GEN_DIR
#
macro (component_vars _component)
    if (VALA_FOUND AND MAINTAINER_MODE)
        set (GEN_DIR ${CMAKE_BINARY_DIR})
        set (CURRENT_GEN_DIR ${CMAKE_CURRENT_BINARY_DIR})
    else ()
        set (GEN_DIR ${CMAKE_SOURCE_DIR})
        set (CURRENT_GEN_DIR ${CMAKE_CURRENT_SOURCE_DIR})
    endif ()
endmacro ()

##
# Add component library target
# Makes regular routines like add_library() and install().
#
# add_component (
# C_SOURCES <c-files>
# VALA_SOURCES <vala-files>
# [VALA_PKGS <valac-command-arguments>]
# [REQUIRES_COMPONENTS <polyol-components>]
# [VALA_PATCHES <shell-code-to-patch-vala-generated-files>])
#
# In VALA_PATCHES, use "::" insead of ";".
#
macro (add_component)
    parse_arguments (ARG "COMPONENT;C_SOURCES;VALA_SOURCES;VALAC_ARGS;REQUIRES_COMPONENTS;VALA_PATCHES" "" ${ARGN})

    component_vars (${ARG_COMPONENT})

    set (_dist_name "${CMAKE_PROJECT_NAME}-${ARG_COMPONENT}")
    set (_sources "")
    _valac (_sources)

    add_library (${_dist_name} SHARED ${_sources})

    foreach (_component ${ARG_REQUIRES_COMPONENTS})
        add_definitions (-I${GEN_DIR}/src/${_component})
        target_link_libraries (${_dist_name} ${CMAKE_PROJECT_NAME}-${_component})
    endforeach ()

    set_target_properties (${_dist_name} PROPERTIES
        VERSION ${MAJOR_VERSION}.1.${MINOR_VERSION}
        SOVERSION ${MAJOR_VERSION})

    install (TARGETS ${_dist_name} DESTINATION lib)
    install (FILES ${CURRENT_GEN_DIR}/${_dist_name}.vapi DESTINATION share/vala/vapi)
    install (FILES ${CURRENT_GEN_DIR}/${ARG_COMPONENT}.h DESTINATION include/${CMAKE_PROJECT_NAME})

    if (EXISTS ${CMAKE_CURRENT_SOURCE_DIR}/component.pc.in)
        configure_file (${CMAKE_CURRENT_SOURCE_DIR}/component.pc.in ${CMAKE_CURRENT_BINARY_DIR}/${_dist_name}.pc @ONLY)
        install (FILES ${CMAKE_CURRENT_BINARY_DIR}/${_dist_name}.pc DESTINATION lib/pkgconfig)
    endif ()

    if (NOT EXISTS ${CMAKE_CURRENT_BINARY_DIR}/polyol)
        execute_process (COMMAND ln -fs . ${CMAKE_CURRENT_BINARY_DIR}/polyol)
    endif ()
endmacro ()

macro (_valac _sources)
    set (_in_files "")
    set (_out_files "")
    set (_deps "")
    set (_args "")

    foreach (_arg ${ARG_VALAC_ARGS})
        list (APPEND _args ${_arg})
    endforeach ()

    foreach (_component ${ARG_REQUIRES_COMPONENTS})
        list (APPEND _args "--vapidir=${GEN_DIR}/src/${_component}")
        list (APPEND _args "--pkg=${CMAKE_PROJECT_NAME}-${_component}")
        list (APPEND _deps "${GEN_DIR}/src/${_component}/${CMAKE_PROJECT_NAME}-${_component}.vapi")
        list (APPEND _deps "${GEN_DIR}/src/${_component}/${_component}.h")
    endforeach ()

    foreach (_c ${ARG_C_SOURCES})
        list (APPEND ${_sources} "${CURRENT_GEN_DIR}/${_c}")
        list (APPEND _deps "${_c}")
    endforeach ()

    foreach (_vala ${ARG_VALA_SOURCES})
        list (APPEND _in_files "${CMAKE_CURRENT_SOURCE_DIR}/${_vala}")
        list (APPEND _deps "${_vala}")
        string (REPLACE ".vala" ".c" _vala ${_vala})
        list (APPEND ${_sources} "${CURRENT_GEN_DIR}/${_vala}")
        list (APPEND _out_files "${CURRENT_GEN_DIR}/${_vala}")
    endforeach ()

    if (ARG_VALA_PATCHES)
        set (_patches "")
        foreach (_patch ${ARG_VALA_PATCHES})
            string (REPLACE "::" ";" _patch "${_patch}")
            set (_patches "${_patches} ${_patch}")
        endforeach ()
    else ()
        set (_patches "true")
    endif ()

    list (APPEND _out_files "${CURRENT_GEN_DIR}/${_dist_name}.vapi")
    list (APPEND _out_files "${CURRENT_GEN_DIR}/${ARG_COMPONENT}.h")

    if (VALA_FOUND AND MAINTAINER_MODE)
        add_custom_command (
            OUTPUT
                ${_out_files}
            COMMAND
                true
            DEPENDS
                ${CMAKE_CURRENT_BINARY_DIR}/${_dist_name}.stamp
            COMMENT
                --
            VERBATIM)

        add_custom_command (
            OUTPUT
                ${CMAKE_CURRENT_BINARY_DIR}/${_dist_name}.stamp
            COMMAND
                ${VALA_C}
            ARGS
                ${_args}
                --ccode
                --basedir ${CMAKE_CURRENT_SOURCE_DIR}
                --directory ${CURRENT_GEN_DIR}
                --library ${_dist_name}
                --use-header --header ${CMAKE_PROJECT_NAME}/${ARG_COMPONENT}.h
                --includedir ${CMAKE_PROJECT_NAME}
                --debug
                ${_in_files}
            COMMAND
                sh -c "${_patches}"
            COMMAND
                touch ${CMAKE_CURRENT_BINARY_DIR}/${_dist_name}.stamp
            DEPENDS
                ${_deps}
            VERBATIM)
    else ()
        foreach (_c_file ${_out_files})
            if (NOT EXISTS "${_c_file}")
                message (FATAL_ERROR "Vala was not found or "
                    "MAINTAINER_MODE is FALSE, thus there is no way "
                    "to generate ${_c_file}")
            endif ()
        endforeach ()
    endif ()
endmacro ()
