macro (setiif _variable _default_value)
    if (NOT DEFINED ${_variable})
        set (${_variable} ${_default_value})
    endif ()
    set (${_variable} ${${_variable}} CACHE INTERNAL "")
endmacro ()

macro (spec_get _output _option)
    file (STRINGS ${CMAKE_SOURCE_DIR}/sweets.recipe ${_output} LIMIT_COUNT 1 REGEX "^${_option} *=")
    string (REGEX REPLACE "^[^=]*=" " " ${_output} ${${_output}})
    string (STRIP ${${_output}} ${_output})
endmacro ()

macro (pkg_check _output _required)
    pkg_check_modules (${_output} ${_required} ${ARGN})

    if (${_required} STREQUAL REQUIRED)
        set (${_output} "")
    else ()
        string (REGEX REPLACE "([a-zA-Z0-9])(<|>|<=|>=|=)${_i}([a-zA-Z0-9])" "\\1 \\2 \\3" ${_output} "${_required}")
    endif ()

    foreach (_pkg ${ARGN})
        string (REGEX REPLACE "([a-zA-Z0-9])(<|>|<=|>=|=)${_i}([a-zA-Z0-9])" "\\1 \\2 \\3" _out "${_pkg}")
        if (${_output})
            set (${_output} "${${_output}} ${_out}")
        else ()
            set (${_output} "${_out}")
        endif ()
    endforeach ()
endmacro ()
