#!/usr/bin/env python

import __init__
import gtk
import random
import gui

window = gtk.Window()
window.connect('destroy', lambda sender: gtk.main_quit())

box = gtk.HBox()
window.add(box)

table_box = gtk.VBox()
box.pack_start (table_box, False)

frame = gtk.Frame()
table_box.pack_end (frame)

table = gui.Table()
table.props.width = 400
table_box.pack_start (table, False)

def add(count):
    label = '-'.join(['WWW'] * count)
    button = gtk.Button('<' + label + '>');
    button.show()
    table.add(button)

toolbar = gtk.VBox()
box.pack_end (toolbar, False)

expand = True
button = gtk.Button('*')
def cb(sender):
    global expand
    table_box.remove (table)
    table_box.pack_start (table, expand)
    expand = not expand

button.connect('clicked', cb)
toolbar.pack_start(button)

button = gtk.Button('0')
def cb(sender):
    while len(table.get_children()) > 0:
        table.remove(table.get_children()[0])
button.connect('clicked', cb)
toolbar.pack_start(button)

button = gtk.Button('1')
button.connect('clicked', lambda sender: add(1))
toolbar.pack_start(button)

button = gtk.Button('3')
button.connect('clicked', lambda sender: add(3))
toolbar.pack_start(button)

button = gtk.Button('10')
button.connect('clicked', lambda sender: add(10))
toolbar.pack_start(button)

button = gtk.Button('?')
button.connect('clicked', lambda sender: add(random.randint(1, 10)))
toolbar.pack_start(button)

for i in range(10):
    add(i + 1)

window.show_all()
gtk.main()
