/* connection.c generated by valac 0.12.1, the Vala compiler
 * generated from connection.vala, do not modify */

/* connection.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/collab.h"
#include <polyol/env.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <glib/gi18n-lib.h>


#define SUGAR_COLLAB_TYPE_BACKEND (sugar_collab_backend_get_type ())
#define SUGAR_COLLAB_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_COLLAB_TYPE_BACKEND, SugarCollabBackend))
#define SUGAR_COLLAB_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_COLLAB_TYPE_BACKEND, SugarCollabBackendClass))
#define SUGAR_COLLAB_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_COLLAB_TYPE_BACKEND))
#define SUGAR_COLLAB_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_COLLAB_TYPE_BACKEND))
#define SUGAR_COLLAB_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_COLLAB_TYPE_BACKEND, SugarCollabBackendClass))

typedef struct _SugarCollabBackend SugarCollabBackend;
typedef struct _SugarCollabBackendClass SugarCollabBackendClass;
#define _sugar_collab_backend_unref0(var) ((var == NULL) ? NULL : (var = (sugar_collab_backend_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SugarCollabBackendPrivate SugarCollabBackendPrivate;

#define SUGAR_COLLAB_TYPE_PS (sugar_collab_ps_get_type ())
#define SUGAR_COLLAB_PS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_COLLAB_TYPE_PS, SugarCollabPS))
#define SUGAR_COLLAB_PS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_COLLAB_TYPE_PS, SugarCollabPSClass))
#define SUGAR_COLLAB_IS_PS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_COLLAB_TYPE_PS))
#define SUGAR_COLLAB_IS_PS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_COLLAB_TYPE_PS))
#define SUGAR_COLLAB_PS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_COLLAB_TYPE_PS, SugarCollabPSClass))

typedef struct _SugarCollabPS SugarCollabPS;
typedef struct _SugarCollabPSClass SugarCollabPSClass;

struct _SugarConnectionPrivate {
	gboolean _connected;
	SugarShareScope _scope;
	SugarShareScope _prev_scope;
	gboolean _scope_changing;
	SugarCollabBackend* _backend;
};

typedef void (*SugarCollabBackendStateFallback) (SugarShareScope scope, void* user_data);
typedef void (*SugarCollabBackendStateChanged) (gboolean success, void* user_data);
typedef void (*SugarCollabBackendChannelStatus) (SugarChannel* channel, gboolean online, void* user_data);
typedef void (*SugarCollabBackendOfferFailed) (const gchar* bus_name, void* user_data);
struct _SugarCollabBackend {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SugarCollabBackendPrivate * priv;
	gboolean initiator;
	gchar* title;
	SugarCollabBackendStateFallback fallback_cb;
	gpointer fallback_cb_target;
	GDestroyNotify fallback_cb_target_destroy_notify;
	SugarCollabBackendStateChanged scope_changed_cb;
	gpointer scope_changed_cb_target;
	GDestroyNotify scope_changed_cb_target_destroy_notify;
	SugarCollabBackendChannelStatus channel_status_cb;
	gpointer channel_status_cb_target;
	GDestroyNotify channel_status_cb_target_destroy_notify;
	SugarCollabBackendOfferFailed offer_failed;
	gpointer offer_failed_target;
	GDestroyNotify offer_failed_target_destroy_notify;
};

struct _SugarCollabBackendClass {
	GTypeClass parent_class;
	void (*finalize) (SugarCollabBackend *self);
	gboolean (*connect) (SugarCollabBackend* self, GError** error);
	void (*set_scope) (SugarCollabBackend* self, SugarShareScope scope);
	void (*on_title_changing) (SugarCollabBackend* self);
	void (*offer_channel) (SugarCollabBackend* self, const gchar* bus_name);
	gboolean (*is_shared) (SugarCollabBackend* self);
};


static gpointer sugar_connection_parent_class = NULL;

gpointer sugar_collab_backend_ref (gpointer instance);
void sugar_collab_backend_unref (gpointer instance);
GParamSpec* sugar_collab_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sugar_collab_value_set_backend (GValue* value, gpointer v_object);
void sugar_collab_value_take_backend (GValue* value, gpointer v_object);
gpointer sugar_collab_value_get_backend (const GValue* value);
GType sugar_collab_backend_get_type (void) G_GNUC_CONST;
#define SUGAR_CONNECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_CONNECTION, SugarConnectionPrivate))
enum  {
	SUGAR_CONNECTION_DUMMY_PROPERTY,
	SUGAR_CONNECTION_SCOPE,
	SUGAR_CONNECTION_SCOPE_CHANGING,
	SUGAR_CONNECTION_INITIATOR,
	SUGAR_CONNECTION_TITLE,
	SUGAR_CONNECTION_SHARED
};
void sugar_collab_backend_offer_channel (SugarCollabBackend* self, const gchar* bus_name);
static gboolean _sugar_connection_connect (SugarConnection* self);
gboolean sugar_collab_backend_connect (SugarCollabBackend* self, GError** error);
static void _sugar_connection_scope_fallback_cb (SugarConnection* self, SugarShareScope new_scope);
static void sugar_connection_set_scope_changing (SugarConnection* self, gboolean value);
static void _sugar_connection_scope_changed_cb (SugarConnection* self, gboolean success);
static void _sugar_connection_channel_status_cb (SugarConnection* self, SugarChannel* channel, gboolean online);
static void _sugar_connection_offer_failed_cb (SugarConnection* self, const gchar* bus_name);
void sugar_collab_backend_set_scope (SugarCollabBackend* self, SugarShareScope scope);
void sugar_collab_backend_on_title_changing (SugarCollabBackend* self);
gboolean sugar_collab_backend_is_shared (SugarCollabBackend* self);
static void g_cclosure_user_marshal_VOID__ENUM_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * sugar_connection_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
SugarCollabPS* sugar_collab_ps_new (void);
SugarCollabPS* sugar_collab_ps_construct (GType object_type);
GType sugar_collab_ps_get_type (void) G_GNUC_CONST;
static void __sugar_connection_scope_fallback_cb_sugar_collab_backend_state_fallback (SugarShareScope scope, gpointer self);
static void __sugar_connection_scope_changed_cb_sugar_collab_backend_state_changed (gboolean success, gpointer self);
static void __sugar_connection_channel_status_cb_sugar_collab_backend_channel_status (SugarChannel* channel, gboolean online, gpointer self);
static void __sugar_connection_offer_failed_cb_sugar_collab_backend_offer_failed (const gchar* bus_name, gpointer self);
static void sugar_connection_finalize (GObject* obj);
static void _vala_sugar_connection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_connection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* SUGAR_CONNECTION__scope_names[3] = {"Private", "Invite Only", "Public"};

/**
     * Create a channel to start interaction process
     *
     * To get Channel ready to use object that represents newly created channel,
     * connect to channel_appeared signal before invoking this method. If
     * channel for given name was already created, method will do nothing i.e.
     * won't emit channel_appeared signal (it was already emited). So, to make
     * robust code, connect to channel_appeared signal before making Connection
     * scope public and assume that you can get channel you need before invoking
     * this method.
     *
     * @param bus_name  A string representing the channel that will be used over
     *                  the connection. It should be a well-known D-Bus service
     *                  name, of the form org.example.ServiceName
     */
void sugar_connection_offer_channel (SugarConnection* self, const gchar* bus_name) {
	SugarShareScope _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bus_name != NULL);
	_tmp0_ = sugar_connection_get_scope (self);
	if (_tmp0_ == SUGAR_SHARE_SCOPE_PRIVATE) {
		g_warning ("connection.vala:191: Cannot get channel if scope is private");
	} else {
		gboolean _tmp1_;
		_tmp1_ = sugar_connection_get_scope_changing (self);
		if (_tmp1_) {
			g_warning ("connection.vala:193: Cannot get channel if scope is changing");
		} else {
			sugar_collab_backend_offer_channel (self->priv->_backend, bus_name);
		}
	}
}


static gboolean _sugar_connection_connect (SugarConnection* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_connected) {
		result = TRUE;
		return result;
	}
	_tmp0_ = sugar_collab_backend_connect (self->priv->_backend, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	self->priv->_connected = _tmp1_;
	goto __finally0;
	__catch0_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("connection.vala:204: Cannot connect: %s", _error_->message);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = self->priv->_connected;
	return result;
}


static void _sugar_connection_scope_fallback_cb (SugarConnection* self, SugarShareScope new_scope) {
	SugarShareScope _tmp0_;
	SugarShareScope prev_scope;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_connection_get_scope (self);
	prev_scope = _tmp0_;
	self->priv->_scope = new_scope;
	g_object_notify ((GObject*) self, "scope");
	_tmp1_ = sugar_connection_get_scope_changing (self);
	if (_tmp1_) {
		SugarShareScope _tmp2_;
		_tmp2_ = sugar_connection_get_scope (self);
		self->priv->_prev_scope = _tmp2_;
		sugar_connection_set_scope_changing (self, FALSE);
	}
	if (prev_scope != new_scope) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _error_;
		_tmp3_ = _ ("Fallback to %s share scope");
		_tmp4_ = _ (SUGAR_CONNECTION__scope_names[new_scope]);
		_tmp5_ = g_strdup_printf (_tmp3_, _tmp4_);
		_error_ = _tmp5_;
		g_signal_emit_by_name (self, "scope-changed", prev_scope, _error_);
		_g_free0 (_error_);
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _sugar_connection_scope_changed_cb (SugarConnection* self, gboolean success) {
	gboolean _tmp0_;
	SugarShareScope _tmp7_;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_connection_get_scope_changing (self);
	if (!_tmp0_) {
		return;
	}
	if (success) {
		SugarShareScope _tmp1_;
		sugar_connection_set_scope_changing (self, FALSE);
		g_signal_emit_by_name (self, "scope-changed", self->priv->_prev_scope, NULL);
		_tmp1_ = sugar_connection_get_scope (self);
		self->priv->_prev_scope = _tmp1_;
	} else {
		SugarShareScope _tmp2_;
		SugarShareScope prev_scope;
		const gchar* _tmp3_ = NULL;
		SugarShareScope _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _error_;
		_tmp2_ = sugar_connection_get_scope (self);
		prev_scope = _tmp2_;
		self->priv->_scope = self->priv->_prev_scope;
		g_object_notify ((GObject*) self, "scope");
		sugar_connection_set_scope_changing (self, FALSE);
		_tmp3_ = _ ("Cannot change share scope to %s");
		_tmp4_ = sugar_connection_get_scope (self);
		_tmp5_ = _ (SUGAR_CONNECTION__scope_names[_tmp4_]);
		_tmp6_ = g_strdup_printf (_tmp3_, _tmp5_);
		_error_ = _tmp6_;
		g_signal_emit_by_name (self, "scope-changed", prev_scope, _error_);
		_g_free0 (_error_);
	}
	_tmp7_ = sugar_connection_get_scope (self);
	_tmp8_ = string_to_string (SUGAR_CONNECTION__scope_names[_tmp7_]);
	_tmp9_ = g_strconcat ("Share scope was set to ", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	g_debug ("connection.vala:245: %s", _tmp10_);
	_g_free0 (_tmp10_);
}


static void _sugar_connection_channel_status_cb (SugarConnection* self, SugarChannel* channel, gboolean online) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	if (online) {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = sugar_channel_get_bus_name (channel);
		g_debug ("connection.vala:250: Channel %s appeared", _tmp0_);
		g_signal_emit_by_name (self, "channel-appeared", channel);
	} else {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = sugar_channel_get_bus_name (channel);
		g_debug ("connection.vala:253: Channel %s disappeared", _tmp1_);
		g_signal_emit_by_name (self, "channel-disappeared", channel);
	}
}


static void _sugar_connection_offer_failed_cb (SugarConnection* self, const gchar* bus_name) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (bus_name != NULL);
	g_debug ("connection.vala:259: Channel %s was failed to appear", bus_name);
	g_signal_emit_by_name (self, "offer-failed", bus_name);
}


SugarConnection* sugar_connection_construct (GType object_type) {
	SugarConnection * self = NULL;
	self = (SugarConnection*) g_object_new (object_type, NULL);
	return self;
}


SugarConnection* sugar_connection_new (void) {
	return sugar_connection_construct (SUGAR_TYPE_CONNECTION);
}


SugarShareScope sugar_connection_get_scope (SugarConnection* self) {
	SugarShareScope result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_scope;
	return result;
}


void sugar_connection_set_scope (SugarConnection* self, SugarShareScope value) {
	SugarShareScope _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_connection_get_scope (self);
	if (value == _tmp0_) {
		return;
	}
	_tmp1_ = sugar_connection_get_scope_changing (self);
	if (_tmp1_) {
		g_warning ("connection.vala:94: Cannot set new scope in scope_changing mode");
		return;
	}
	_tmp2_ = _sugar_connection_connect (self);
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		SugarShareScope _tmp6_;
		_tmp3_ = string_to_string (SUGAR_CONNECTION__scope_names[value]);
		_tmp4_ = g_strconcat ("Setting share scope to ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		g_debug ("connection.vala:99: %s", _tmp5_);
		_g_free0 (_tmp5_);
		self->priv->_scope = value;
		sugar_connection_set_scope_changing (self, TRUE);
		_tmp6_ = sugar_connection_get_scope (self);
		sugar_collab_backend_set_scope (self->priv->_backend, _tmp6_);
	}
	g_object_notify ((GObject *) self, "scope");
}


gboolean sugar_connection_get_scope_changing (SugarConnection* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_scope_changing;
	return result;
}


static void sugar_connection_set_scope_changing (SugarConnection* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_scope_changing = value;
	g_object_notify ((GObject *) self, "scope-changing");
}


gboolean sugar_connection_get_initiator (SugarConnection* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_backend->initiator;
	return result;
}


const gchar* sugar_connection_get_title (SugarConnection* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_backend->title;
	return result;
}


void sugar_connection_set_title (SugarConnection* self, const gchar* value) {
	gchar* _tmp0_;
	SugarShareScope _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_backend->title);
	self->priv->_backend->title = _tmp0_;
	_tmp1_ = sugar_connection_get_scope (self);
	if (_tmp1_ != SUGAR_SHARE_SCOPE_PRIVATE) {
		sugar_collab_backend_on_title_changing (self->priv->_backend);
	}
	g_object_notify ((GObject *) self, "title");
}


gboolean sugar_connection_get_shared (SugarConnection* self) {
	gboolean result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = _sugar_connection_connect (self);
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = sugar_collab_backend_is_shared (self->priv->_backend);
	result = _tmp1_;
	return result;
}


static void g_cclosure_user_marshal_VOID__ENUM_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__ENUM_STRING) (gpointer data1, gint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__ENUM_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__ENUM_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_enum (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void __sugar_connection_scope_fallback_cb_sugar_collab_backend_state_fallback (SugarShareScope scope, gpointer self) {
	_sugar_connection_scope_fallback_cb (self, scope);
}


static void __sugar_connection_scope_changed_cb_sugar_collab_backend_state_changed (gboolean success, gpointer self) {
	_sugar_connection_scope_changed_cb (self, success);
}


static void __sugar_connection_channel_status_cb_sugar_collab_backend_channel_status (SugarChannel* channel, gboolean online, gpointer self) {
	_sugar_connection_channel_status_cb (self, channel, online);
}


static void __sugar_connection_offer_failed_cb_sugar_collab_backend_offer_failed (const gchar* bus_name, gpointer self) {
	_sugar_connection_offer_failed_cb (self, bus_name);
}


static GObject * sugar_connection_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarConnection * self;
	gboolean _tmp0_;
	SugarCollabPS* _tmp1_ = NULL;
	parent_class = G_OBJECT_CLASS (sugar_connection_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_CONNECTION (obj);
	_tmp0_ = sugar_environ_get_initialized ();
	g_assert (_tmp0_);
	_tmp1_ = sugar_collab_ps_new ();
	_sugar_collab_backend_unref0 (self->priv->_backend);
	self->priv->_backend = (SugarCollabBackend*) _tmp1_;
	(self->priv->_backend->fallback_cb_target_destroy_notify == NULL) ? NULL : (self->priv->_backend->fallback_cb_target_destroy_notify (self->priv->_backend->fallback_cb_target), NULL);
	self->priv->_backend->fallback_cb = NULL;
	self->priv->_backend->fallback_cb_target = NULL;
	self->priv->_backend->fallback_cb_target_destroy_notify = NULL;
	self->priv->_backend->fallback_cb = __sugar_connection_scope_fallback_cb_sugar_collab_backend_state_fallback;
	self->priv->_backend->fallback_cb_target = g_object_ref (self);
	self->priv->_backend->fallback_cb_target_destroy_notify = g_object_unref;
	(self->priv->_backend->scope_changed_cb_target_destroy_notify == NULL) ? NULL : (self->priv->_backend->scope_changed_cb_target_destroy_notify (self->priv->_backend->scope_changed_cb_target), NULL);
	self->priv->_backend->scope_changed_cb = NULL;
	self->priv->_backend->scope_changed_cb_target = NULL;
	self->priv->_backend->scope_changed_cb_target_destroy_notify = NULL;
	self->priv->_backend->scope_changed_cb = __sugar_connection_scope_changed_cb_sugar_collab_backend_state_changed;
	self->priv->_backend->scope_changed_cb_target = g_object_ref (self);
	self->priv->_backend->scope_changed_cb_target_destroy_notify = g_object_unref;
	(self->priv->_backend->channel_status_cb_target_destroy_notify == NULL) ? NULL : (self->priv->_backend->channel_status_cb_target_destroy_notify (self->priv->_backend->channel_status_cb_target), NULL);
	self->priv->_backend->channel_status_cb = NULL;
	self->priv->_backend->channel_status_cb_target = NULL;
	self->priv->_backend->channel_status_cb_target_destroy_notify = NULL;
	self->priv->_backend->channel_status_cb = __sugar_connection_channel_status_cb_sugar_collab_backend_channel_status;
	self->priv->_backend->channel_status_cb_target = g_object_ref (self);
	self->priv->_backend->channel_status_cb_target_destroy_notify = g_object_unref;
	(self->priv->_backend->offer_failed_target_destroy_notify == NULL) ? NULL : (self->priv->_backend->offer_failed_target_destroy_notify (self->priv->_backend->offer_failed_target), NULL);
	self->priv->_backend->offer_failed = NULL;
	self->priv->_backend->offer_failed_target = NULL;
	self->priv->_backend->offer_failed_target_destroy_notify = NULL;
	self->priv->_backend->offer_failed = __sugar_connection_offer_failed_cb_sugar_collab_backend_offer_failed;
	self->priv->_backend->offer_failed_target = g_object_ref (self);
	self->priv->_backend->offer_failed_target_destroy_notify = g_object_unref;
	return obj;
}


static void sugar_connection_class_init (SugarConnectionClass * klass) {
	sugar_connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarConnectionPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_connection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_connection_set_property;
	G_OBJECT_CLASS (klass)->constructor = sugar_connection_constructor;
	G_OBJECT_CLASS (klass)->finalize = sugar_connection_finalize;
	/**
	     * Current connection scope that was set by user
	     *
	     * After setting this property, Connection object will initiate scope
	     * changing (scope_changing property will be set to true).  Thus, do not
	     * judge about real connection scope on this value, listen this property
	     * notification only for scope indication puposes. To do real connection
	     * scope based work, connect to scope-changed signal.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_CONNECTION_SCOPE, g_param_spec_enum ("scope", "scope", "scope", SUGAR_TYPE_SHARE_SCOPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Connection is in scope changing mode
	     *
	     * This prerty is tru when scope value was changed and Connection object
	     * is in low level scope changing mode. When low level scope is changed,
	     * scope_changing signal will be sent and this property will be false.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_CONNECTION_SCOPE_CHANGING, g_param_spec_boolean ("scope-changing", "scope-changing", "scope-changing", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * If current buddy is an initiator of shared connection
	     *
	     * If current user was the first who made shared connection online, this
	     * property will be true. If while going online, this Connection object
	     * joined to already existed public connection, this property will be false.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_CONNECTION_INITIATOR, g_param_spec_boolean ("initiator", "initiator", "initiator", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Name of connection to advertise in the public
	     *
	     * This is the same value like "title" field in Journal entry.
	     * Before switching to online modes, set this property. In most cases
	     * it could be Title of activity. Also set this property after Title
	     * was changed.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_CONNECTION_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Is connection already shared
	     *
	     * Property will return true If someone already has shared the same
	     * activity_id connection.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_CONNECTION_SHARED, g_param_spec_boolean ("shared", "shared", "shared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Connection scope was changed
	     *
	     * Signal will be sent not right after changing scope property but
	     * when connection was really changed i.e. scope_changing property is false.
	     *
	     * @param prev_scope    Previous scope property value
	     * @param error         If changing was a reaction on failure
	     *                      localized text that could be used in GUI alerts
	     */
	g_signal_new ("scope_changed", SUGAR_TYPE_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_STRING, G_TYPE_NONE, 2, SUGAR_TYPE_SHARE_SCOPE, G_TYPE_STRING);
	/**
	     * New channel is arrived
	     *
	     * @param channel   channel which just appeared
	     */
	g_signal_new ("channel_appeared", SUGAR_TYPE_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SUGAR_TYPE_CHANNEL);
	/**
	     * One of recent offer_channel calls is failed
	     *
	     * @param bus_name  argument passed to failed offer_channel invocation
	     */
	g_signal_new ("offer_failed", SUGAR_TYPE_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	/**
	     * Channel was closed
	     *
	     * @param channel   closed channel, object is till valid but offline
	     */
	g_signal_new ("channel_disappeared", SUGAR_TYPE_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SUGAR_TYPE_CHANNEL);
}


static void sugar_connection_instance_init (SugarConnection * self) {
	self->priv = SUGAR_CONNECTION_GET_PRIVATE (self);
	self->priv->_scope = SUGAR_SHARE_SCOPE_PRIVATE;
	self->priv->_prev_scope = SUGAR_SHARE_SCOPE_PRIVATE;
	self->priv->_scope_changing = FALSE;
}


static void sugar_connection_finalize (GObject* obj) {
	SugarConnection * self;
	self = SUGAR_CONNECTION (obj);
	_sugar_collab_backend_unref0 (self->priv->_backend);
	G_OBJECT_CLASS (sugar_connection_parent_class)->finalize (obj);
}


/**
 * Handle all things needed to make sugar shared connection
 *
 * The purpose of this class is to simplify Telepathy usage taking into
 * account activity development process i.e. targeting workflow is only
 * programmable Activity<->Activity interaction. It is not intended to support
 * all Telepathy features, if you need some of them, just fallback to pure
 * Telepathy.
 *
 * Class represents Telepathy connection (what ever it could mean). Only one
 * connection is allowed within activity launch session. Connection is
 * identified by Environ.activity_id value.
 *
 * To start interaction process between joined buddies, call on of offer_*
 * methods. Connection class supports two kinds of interactions, channels and
 * streams. Sugar.Channel class which is based of Telepathy DBus Tubes
 * (http://telepathy.freedesktop.org/spec/Channel_Type_DBus_Tube.html) and
 * intended to be programmable DBus based interfaces. Sugar.Stream class
 * (http://telepathy.freedesktop.org/spec/Channel_Type_Stream_Tube.html)
 * is for low level data transfer similar to sockets.
 */
GType sugar_connection_get_type (void) {
	static volatile gsize sugar_connection_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_connection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarConnection), 0, (GInstanceInitFunc) sugar_connection_instance_init, NULL };
		GType sugar_connection_type_id;
		sugar_connection_type_id = g_type_register_static (G_TYPE_OBJECT, "SugarConnection", &g_define_type_info, 0);
		g_once_init_leave (&sugar_connection_type_id__volatile, sugar_connection_type_id);
	}
	return sugar_connection_type_id__volatile;
}


static void _vala_sugar_connection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarConnection * self;
	self = SUGAR_CONNECTION (object);
	switch (property_id) {
		case SUGAR_CONNECTION_SCOPE:
		g_value_set_enum (value, sugar_connection_get_scope (self));
		break;
		case SUGAR_CONNECTION_SCOPE_CHANGING:
		g_value_set_boolean (value, sugar_connection_get_scope_changing (self));
		break;
		case SUGAR_CONNECTION_INITIATOR:
		g_value_set_boolean (value, sugar_connection_get_initiator (self));
		break;
		case SUGAR_CONNECTION_TITLE:
		g_value_set_string (value, sugar_connection_get_title (self));
		break;
		case SUGAR_CONNECTION_SHARED:
		g_value_set_boolean (value, sugar_connection_get_shared (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_connection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarConnection * self;
	self = SUGAR_CONNECTION (object);
	switch (property_id) {
		case SUGAR_CONNECTION_SCOPE:
		sugar_connection_set_scope (self, g_value_get_enum (value));
		break;
		case SUGAR_CONNECTION_SCOPE_CHANGING:
		sugar_connection_set_scope_changing (self, g_value_get_boolean (value));
		break;
		case SUGAR_CONNECTION_TITLE:
		sugar_connection_set_title (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



