/* activity_info.c generated by valac 0.12.1, the Vala compiler
 * generated from activity_info.vala, do not modify */

/* activity_info.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/env.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))



#define SUGAR_ACTIVITY_INFO__ACTIVITY_GROUP "Activity"


/**
     * Get activity info by path to activity sources
     *
     * @param path  full path to activity sources root directory
     * @param info  variable to store result
     *
     * @return      true on success when info contains valid object
     */
gboolean sugar_activity_info_get (const gchar* path, SugarActivityInfo* _result_) {
	SugarActivityInfo _result = {0};
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* activity_info;
	gboolean _tmp1_;
	SugarActivityInfo _tmp2_ = {0};
	SugarActivityInfo info;
	GKeyFile* _tmp3_ = NULL;
	GKeyFile* ini;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	SugarActivityInfo _tmp24_;
	SugarActivityInfo _tmp25_ = {0};
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = g_build_filename (path, "activity", "activity.info", NULL);
	activity_info = _tmp0_;
	_tmp1_ = g_file_test (activity_info, G_FILE_TEST_EXISTS);
	if (!_tmp1_) {
		g_warning ("activity_info.vala:54: Cannot find activity.info file in %s", path);
		result = FALSE;
		_g_free0 (activity_info);
		if (_result_) {
			*_result_ = _result;
		} else {
			sugar_activity_info_destroy (&_result);
		}
		return result;
	}
	info = _tmp2_;
	_tmp3_ = g_key_file_new ();
	ini = _tmp3_;
	g_key_file_load_from_file (ini, activity_info, G_KEY_FILE_NONE, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	_tmp4_ = g_key_file_has_key (ini, SUGAR_ACTIVITY_INFO__ACTIVITY_GROUP, "bundle_id", &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	if (_tmp5_) {
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp6_ = g_key_file_get_value (ini, SUGAR_ACTIVITY_INFO__ACTIVITY_GROUP, "bundle_id", &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_g_free0 (info.bundle_id);
		info.bundle_id = _tmp7_;
	} else {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = g_key_file_has_key (ini, SUGAR_ACTIVITY_INFO__ACTIVITY_GROUP, "service_name", &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		if (_tmp9_) {
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			g_debug ("activity_info.vala:67: Deprecated service_name key in %s, use bundle_i" \
"d", activity_info);
			_tmp10_ = g_key_file_get_value (ini, SUGAR_ACTIVITY_INFO__ACTIVITY_GROUP, "service_name", &_inner_error_);
			_tmp11_ = _tmp10_;
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
			_g_free0 (info.bundle_id);
			info.bundle_id = _tmp11_;
		} else {
			g_warning ("activity_info.vala:72: Malformed %s: lack of bundle_id key", activity_info);
			result = FALSE;
			_g_key_file_free0 (ini);
			sugar_activity_info_destroy (&info);
			_g_free0 (activity_info);
			if (_result_) {
				*_result_ = _result;
			} else {
				sugar_activity_info_destroy (&_result);
			}
			return result;
		}
	}
	_tmp12_ = g_key_file_has_key (ini, SUGAR_ACTIVITY_INFO__ACTIVITY_GROUP, "name", &_inner_error_);
	_tmp13_ = _tmp12_;
	if (_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	if (_tmp13_) {
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp14_ = g_key_file_get_value (ini, SUGAR_ACTIVITY_INFO__ACTIVITY_GROUP, "name", &_inner_error_);
		_tmp15_ = _tmp14_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_g_free0 (info.name);
		info.name = _tmp15_;
	} else {
		g_warning ("activity_info.vala:79: Malformed %s: lack of name key", activity_info);
		result = FALSE;
		_g_key_file_free0 (ini);
		sugar_activity_info_destroy (&info);
		_g_free0 (activity_info);
		if (_result_) {
			*_result_ = _result;
		} else {
			sugar_activity_info_destroy (&_result);
		}
		return result;
	}
	_tmp16_ = g_key_file_has_key (ini, SUGAR_ACTIVITY_INFO__ACTIVITY_GROUP, "icon", &_inner_error_);
	_tmp17_ = _tmp16_;
	if (_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	if (_tmp17_) {
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_ = NULL;
		_tmp18_ = g_key_file_get_value (ini, SUGAR_ACTIVITY_INFO__ACTIVITY_GROUP, "icon", &_inner_error_);
		_tmp19_ = _tmp18_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp20_, ".svg", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_build_filename (path, "activity", _tmp22_, NULL);
		_g_free0 (info.icon);
		info.icon = _tmp23_;
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
	} else {
		g_warning ("activity_info.vala:87: Malformed %s: lack of icon key", activity_info);
		result = FALSE;
		_g_key_file_free0 (ini);
		sugar_activity_info_destroy (&info);
		_g_free0 (activity_info);
		if (_result_) {
			*_result_ = _result;
		} else {
			sugar_activity_info_destroy (&_result);
		}
		return result;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("activity_info.vala:91: Cannot parse %s: %s", activity_info, _error_->message);
		result = FALSE;
		_g_error_free0 (_error_);
		_g_key_file_free0 (ini);
		sugar_activity_info_destroy (&info);
		_g_free0 (activity_info);
		if (_result_) {
			*_result_ = _result;
		} else {
			sugar_activity_info_destroy (&_result);
		}
		return result;
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (ini);
		sugar_activity_info_destroy (&info);
		_g_free0 (activity_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	sugar_activity_info_copy (&info, &_tmp25_);
	_tmp24_ = _tmp25_;
	sugar_activity_info_destroy (&_result);
	_result = _tmp24_;
	result = TRUE;
	_g_key_file_free0 (ini);
	sugar_activity_info_destroy (&info);
	_g_free0 (activity_info);
	if (_result_) {
		*_result_ = _result;
	} else {
		sugar_activity_info_destroy (&_result);
	}
	return result;
}


void sugar_activity_info_copy (const SugarActivityInfo* self, SugarActivityInfo* dest) {
	dest->bundle_id = g_strdup (self->bundle_id);
	dest->icon = g_strdup (self->icon);
	dest->name = g_strdup (self->name);
}


void sugar_activity_info_destroy (SugarActivityInfo* self) {
	_g_free0 ((*self).bundle_id);
	_g_free0 ((*self).icon);
	_g_free0 ((*self).name);
}


SugarActivityInfo* sugar_activity_info_dup (const SugarActivityInfo* self) {
	SugarActivityInfo* dup;
	dup = g_new0 (SugarActivityInfo, 1);
	sugar_activity_info_copy (self, dup);
	return dup;
}


void sugar_activity_info_free (SugarActivityInfo* self) {
	sugar_activity_info_destroy (self);
	g_free (self);
}


GType sugar_activity_info_get_type (void) {
	static volatile gsize sugar_activity_info_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_activity_info_type_id__volatile)) {
		GType sugar_activity_info_type_id;
		sugar_activity_info_type_id = g_boxed_type_register_static ("SugarActivityInfo", (GBoxedCopyFunc) sugar_activity_info_dup, (GBoxedFreeFunc) sugar_activity_info_free);
		g_once_init_leave (&sugar_activity_info_type_id__volatile, sugar_activity_info_type_id);
	}
	return sugar_activity_info_type_id__volatile;
}



