/* alignment.c generated by valac 0.12.1, the Vala compiler
 * generated from alignment.vala, do not modify */

/* alignment.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/gui.h"
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>


struct _SugarAlignmentPrivate {
	gfloat _xalign;
	gfloat _yalign;
	gfloat _xscale;
	gfloat _yscale;
	gboolean _xignore;
	gboolean _yignore;
	gint _xoffset;
	gint _yoffset;
	gint _child_width;
	gint _child_height;
	GtkRequisition _child_requisition;
};


static gpointer sugar_alignment_parent_class = NULL;

#define SUGAR_ALIGNMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_ALIGNMENT, SugarAlignmentPrivate))
enum  {
	SUGAR_ALIGNMENT_DUMMY_PROPERTY,
	SUGAR_ALIGNMENT_XALIGN,
	SUGAR_ALIGNMENT_YALIGN,
	SUGAR_ALIGNMENT_XSCALE,
	SUGAR_ALIGNMENT_YSCALE,
	SUGAR_ALIGNMENT_XIGNORE,
	SUGAR_ALIGNMENT_YIGNORE,
	SUGAR_ALIGNMENT_CHILD_X,
	SUGAR_ALIGNMENT_CHILD_Y,
	SUGAR_ALIGNMENT_CHILD_WIDTH,
	SUGAR_ALIGNMENT_CHILD_HEIGHT
};
static void sugar_alignment_real_size_request (GtkWidget* base, GtkRequisition* requisition);
static void sugar_alignment_real_size_allocate (GtkWidget* base, GdkRectangle* allocation);
static void _sugar_alignment_whether_to_resize (SugarAlignment* self, gfloat* prop, gfloat value);
static void sugar_alignment_finalize (GObject* obj);
static void _vala_sugar_alignment_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_alignment_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void sugar_alignment_real_size_request (GtkWidget* base, GtkRequisition* requisition) {
	SugarAlignment * self;
	GtkRequisition _requisition = {0};
	GtkRequisition _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	self = (SugarAlignment*) base;
	GTK_WIDGET_CLASS (sugar_alignment_parent_class)->size_request ((GtkWidget*) SUGAR_BIN (self), &_tmp0_);
	_requisition = _tmp0_;
	self->priv->_child_requisition = _requisition;
	_tmp2_ = sugar_alignment_get_xignore (self);
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_;
		_tmp3_ = sugar_alignment_get_yignore (self);
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		GtkRequisition _tmp4_ = {0};
		GtkRequisition container_requisition;
		gboolean _tmp5_;
		gboolean _tmp6_;
		container_requisition = _tmp4_;
		sugar_container_child_size_request ((SugarContainer*) self, &container_requisition);
		_tmp5_ = sugar_alignment_get_xignore (self);
		if (_tmp5_) {
			_requisition.width = container_requisition.width;
		}
		_tmp6_ = sugar_alignment_get_yignore (self);
		if (_tmp6_) {
			_requisition.height = container_requisition.height;
		}
	}
	if (requisition) {
		*requisition = _requisition;
	}
}


static void sugar_alignment_real_size_allocate (GtkWidget* base, GdkRectangle* allocation) {
	SugarAlignment * self;
	GtkWidget* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GdkRectangle _tmp17_ = {0};
	GdkRectangle child_allocation;
	GtkWidget* _tmp18_ = NULL;
	self = (SugarAlignment*) base;
	((GtkWidget*) self)->allocation = (GtkAllocation) (*allocation);
	_tmp0_ = sugar_bin_get_child ((SugarBin*) self);
	if (_tmp0_ == NULL) {
		return;
	}
	if (SUGAR_CONTAINER_CLASS (sugar_alignment_parent_class)->get_child_width ((SugarContainer*) SUGAR_BIN (self)) <= self->priv->_child_requisition.width) {
		_tmp1_ = TRUE;
	} else {
		gfloat _tmp2_;
		_tmp2_ = sugar_alignment_get_xscale (self);
		_tmp1_ = _tmp2_ == 1.0f;
	}
	if (_tmp1_) {
		self->priv->_child_width = SUGAR_CONTAINER_CLASS (sugar_alignment_parent_class)->get_child_width ((SugarContainer*) SUGAR_BIN (self));
		self->priv->_xoffset = 0;
	} else {
		gfloat _tmp3_;
		GtkTextDirection _tmp5_;
		_tmp3_ = sugar_alignment_get_xscale (self);
		if (_tmp3_ == 0.0f) {
			self->priv->_child_width = self->priv->_child_requisition.width;
		} else {
			gfloat _tmp4_;
			_tmp4_ = sugar_alignment_get_xscale (self);
			self->priv->_child_width = self->priv->_child_requisition.width + ((gint) ((SUGAR_CONTAINER_CLASS (sugar_alignment_parent_class)->get_child_width ((SugarContainer*) SUGAR_BIN (self)) - self->priv->_child_requisition.width) * (1.0f - _tmp4_)));
		}
		_tmp5_ = gtk_widget_get_direction ((GtkWidget*) self);
		if (_tmp5_ == GTK_TEXT_DIR_RTL) {
			gfloat _tmp6_;
			_tmp6_ = sugar_alignment_get_xalign (self);
			self->priv->_xoffset = (gint) ((SUGAR_CONTAINER_CLASS (sugar_alignment_parent_class)->get_child_width ((SugarContainer*) SUGAR_BIN (self)) - self->priv->_child_width) * (1.0f - _tmp6_));
		} else {
			gfloat _tmp7_;
			_tmp7_ = sugar_alignment_get_xalign (self);
			self->priv->_xoffset = (gint) ((SUGAR_CONTAINER_CLASS (sugar_alignment_parent_class)->get_child_width ((SugarContainer*) SUGAR_BIN (self)) - self->priv->_child_width) * _tmp7_);
		}
	}
	if (SUGAR_CONTAINER_CLASS (sugar_alignment_parent_class)->get_child_height ((SugarContainer*) SUGAR_BIN (self)) <= self->priv->_child_requisition.height) {
		_tmp8_ = TRUE;
	} else {
		gfloat _tmp9_;
		_tmp9_ = sugar_alignment_get_yscale (self);
		_tmp8_ = _tmp9_ == 1.0f;
	}
	if (_tmp8_) {
		self->priv->_child_height = SUGAR_CONTAINER_CLASS (sugar_alignment_parent_class)->get_child_height ((SugarContainer*) SUGAR_BIN (self));
		self->priv->_yoffset = 0;
	} else {
		gfloat _tmp10_;
		gfloat _tmp12_;
		_tmp10_ = sugar_alignment_get_yscale (self);
		if (_tmp10_ == 0.0f) {
			self->priv->_child_height = self->priv->_child_requisition.height;
		} else {
			gfloat _tmp11_;
			_tmp11_ = sugar_alignment_get_yscale (self);
			self->priv->_child_height = self->priv->_child_requisition.height + ((gint) ((SUGAR_CONTAINER_CLASS (sugar_alignment_parent_class)->get_child_height ((SugarContainer*) SUGAR_BIN (self)) - self->priv->_child_requisition.height) * (1.0f - _tmp11_)));
		}
		_tmp12_ = sugar_alignment_get_yalign (self);
		self->priv->_yoffset = (gint) ((SUGAR_CONTAINER_CLASS (sugar_alignment_parent_class)->get_child_height ((SugarContainer*) SUGAR_BIN (self)) - self->priv->_child_height) * _tmp12_);
	}
	_tmp13_ = sugar_container_get_child_x ((SugarContainer*) self);
	_tmp14_ = sugar_container_get_child_y ((SugarContainer*) self);
	_tmp15_ = sugar_container_get_child_width ((SugarContainer*) self);
	_tmp16_ = sugar_container_get_child_height ((SugarContainer*) self);
	_tmp17_.x = _tmp13_;
	_tmp17_.y = _tmp14_;
	_tmp17_.width = _tmp15_;
	_tmp17_.height = _tmp16_;
	child_allocation = _tmp17_;
	_tmp18_ = sugar_bin_get_child ((SugarBin*) self);
	gtk_widget_size_allocate (_tmp18_, &child_allocation);
}


static void _sugar_alignment_whether_to_resize (SugarAlignment* self, gfloat* prop, gfloat value) {
	g_return_if_fail (self != NULL);
	if (value != (*prop)) {
		*prop = value;
		gtk_widget_queue_resize ((GtkWidget*) self);
	}
}


SugarAlignment* sugar_alignment_construct (GType object_type) {
	SugarAlignment * self = NULL;
	self = (SugarAlignment*) sugar_bin_construct (object_type);
	return self;
}


SugarAlignment* sugar_alignment_new (void) {
	return sugar_alignment_construct (SUGAR_TYPE_ALIGNMENT);
}


gfloat sugar_alignment_get_xalign (SugarAlignment* self) {
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_xalign;
	return result;
}


void sugar_alignment_set_xalign (SugarAlignment* self, gfloat value) {
	g_return_if_fail (self != NULL);
	_sugar_alignment_whether_to_resize (self, &self->priv->_xalign, value);
	g_object_notify ((GObject *) self, "xalign");
}


gfloat sugar_alignment_get_yalign (SugarAlignment* self) {
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_yalign;
	return result;
}


void sugar_alignment_set_yalign (SugarAlignment* self, gfloat value) {
	g_return_if_fail (self != NULL);
	_sugar_alignment_whether_to_resize (self, &self->priv->_yalign, value);
	g_object_notify ((GObject *) self, "yalign");
}


gfloat sugar_alignment_get_xscale (SugarAlignment* self) {
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_xscale;
	return result;
}


void sugar_alignment_set_xscale (SugarAlignment* self, gfloat value) {
	g_return_if_fail (self != NULL);
	_sugar_alignment_whether_to_resize (self, &self->priv->_xscale, value);
	g_object_notify ((GObject *) self, "xscale");
}


gfloat sugar_alignment_get_yscale (SugarAlignment* self) {
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_yscale;
	return result;
}


void sugar_alignment_set_yscale (SugarAlignment* self, gfloat value) {
	g_return_if_fail (self != NULL);
	_sugar_alignment_whether_to_resize (self, &self->priv->_yscale, value);
	g_object_notify ((GObject *) self, "yscale");
}


gboolean sugar_alignment_get_xignore (SugarAlignment* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_xignore;
	return result;
}


void sugar_alignment_set_xignore (SugarAlignment* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_alignment_get_xignore (self);
	if (value == _tmp0_) {
		return;
	}
	self->priv->_xignore = value;
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "xignore");
}


gboolean sugar_alignment_get_yignore (SugarAlignment* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_yignore;
	return result;
}


void sugar_alignment_set_yignore (SugarAlignment* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_alignment_get_yignore (self);
	if (value == _tmp0_) {
		return;
	}
	self->priv->_yignore = value;
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "yignore");
}


static gint sugar_alignment_real_get_child_x (SugarContainer* base) {
	gint result;
	SugarAlignment* self;
	self = (SugarAlignment*) base;
	result = SUGAR_CONTAINER_CLASS (sugar_alignment_parent_class)->get_child_x ((SugarContainer*) SUGAR_BIN (self)) + self->priv->_xoffset;
	return result;
}


static gint sugar_alignment_real_get_child_y (SugarContainer* base) {
	gint result;
	SugarAlignment* self;
	self = (SugarAlignment*) base;
	result = SUGAR_CONTAINER_CLASS (sugar_alignment_parent_class)->get_child_y ((SugarContainer*) SUGAR_BIN (self)) + self->priv->_yoffset;
	return result;
}


static gint sugar_alignment_real_get_child_width (SugarContainer* base) {
	gint result;
	SugarAlignment* self;
	self = (SugarAlignment*) base;
	result = self->priv->_child_width;
	return result;
}


static gint sugar_alignment_real_get_child_height (SugarContainer* base) {
	gint result;
	SugarAlignment* self;
	self = (SugarAlignment*) base;
	result = self->priv->_child_height;
	return result;
}


static void sugar_alignment_class_init (SugarAlignmentClass * klass) {
	sugar_alignment_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarAlignmentPrivate));
	GTK_WIDGET_CLASS (klass)->size_request = sugar_alignment_real_size_request;
	GTK_WIDGET_CLASS (klass)->size_allocate = sugar_alignment_real_size_allocate;
	SUGAR_CONTAINER_CLASS (klass)->get_child_x = sugar_alignment_real_get_child_x;
	SUGAR_CONTAINER_CLASS (klass)->get_child_y = sugar_alignment_real_get_child_y;
	SUGAR_CONTAINER_CLASS (klass)->get_child_width = sugar_alignment_real_get_child_width;
	SUGAR_CONTAINER_CLASS (klass)->get_child_height = sugar_alignment_real_get_child_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_alignment_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_alignment_set_property;
	G_OBJECT_CLASS (klass)->finalize = sugar_alignment_finalize;
	/**
	     * The horizontal alignment
	     *
	     * Value from 0 (left) to 1 (right), reversed for RTL layouts.
	     * Makes sense only if xscale < 1.0.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ALIGNMENT_XALIGN, g_param_spec_float ("xalign", "xalign", "xalign", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The vertical alignment
	     *
	     * Value from 0 (left) to 1 (right), reversed for RTL layouts.
	     * Makes sense only if yscale < 1.0.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ALIGNMENT_YALIGN, g_param_spec_float ("yalign", "yalign", "yalign", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Scale child horizontally
	     *
	     * If available horizontal space is bigger than needed for the child,
	     * how much of it to use for the child.
	     *
	     *  0.0     use exactly what child requested
	     *  1.0     use entirely Bin space for child needs
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ALIGNMENT_XSCALE, g_param_spec_float ("xscale", "xscale", "xscale", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Scale child vertically
	     *
	     * If available vertical space is bigger than needed for the child,
	     * how much of it to use for the child.
	     *
	     *  0.0     use exactly what child requested
	     *  1.0     use entirely Bin space for child needs
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ALIGNMENT_YSCALE, g_param_spec_float ("yscale", "yscale", "yscale", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Ignore width requested by child
	     *
	     * Alignment will request 0 width in spite of child needs.
	     * Thus child could get less size then it requested, otherwise regular
	     * scheme will be preswerved.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ALIGNMENT_XIGNORE, g_param_spec_boolean ("xignore", "xignore", "xignore", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Ignore height requested by child
	     *
	     * Alignment will request 0 width in spite of child needs.
	     * Thus child could get less size then it requested, otherwise regular
	     * scheme will be preswerved.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ALIGNMENT_YIGNORE, g_param_spec_boolean ("yignore", "yignore", "yignore", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), SUGAR_ALIGNMENT_CHILD_X, "child-x");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SUGAR_ALIGNMENT_CHILD_Y, "child-y");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SUGAR_ALIGNMENT_CHILD_WIDTH, "child-width");
	g_object_class_override_property (G_OBJECT_CLASS (klass), SUGAR_ALIGNMENT_CHILD_HEIGHT, "child-height");
}


static void sugar_alignment_instance_init (SugarAlignment * self) {
	self->priv = SUGAR_ALIGNMENT_GET_PRIVATE (self);
	self->priv->_xalign = 0.5f;
	self->priv->_yalign = 0.5f;
	self->priv->_xscale = 1.0f;
	self->priv->_yscale = 1.0f;
	self->priv->_xignore = TRUE;
	self->priv->_yignore = TRUE;
	self->priv->_xoffset = 0;
	self->priv->_yoffset = 0;
	self->priv->_child_width = 0;
	self->priv->_child_height = 0;
}


static void sugar_alignment_finalize (GObject* obj) {
	SugarAlignment * self;
	self = SUGAR_ALIGNMENT (obj);
	G_OBJECT_CLASS (sugar_alignment_parent_class)->finalize (obj);
}


GType sugar_alignment_get_type (void) {
	static volatile gsize sugar_alignment_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_alignment_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarAlignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_alignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarAlignment), 0, (GInstanceInitFunc) sugar_alignment_instance_init, NULL };
		GType sugar_alignment_type_id;
		sugar_alignment_type_id = g_type_register_static (SUGAR_TYPE_BIN, "SugarAlignment", &g_define_type_info, 0);
		g_once_init_leave (&sugar_alignment_type_id__volatile, sugar_alignment_type_id);
	}
	return sugar_alignment_type_id__volatile;
}


static void _vala_sugar_alignment_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarAlignment * self;
	self = SUGAR_ALIGNMENT (object);
	switch (property_id) {
		case SUGAR_ALIGNMENT_XALIGN:
		g_value_set_float (value, sugar_alignment_get_xalign (self));
		break;
		case SUGAR_ALIGNMENT_YALIGN:
		g_value_set_float (value, sugar_alignment_get_yalign (self));
		break;
		case SUGAR_ALIGNMENT_XSCALE:
		g_value_set_float (value, sugar_alignment_get_xscale (self));
		break;
		case SUGAR_ALIGNMENT_YSCALE:
		g_value_set_float (value, sugar_alignment_get_yscale (self));
		break;
		case SUGAR_ALIGNMENT_XIGNORE:
		g_value_set_boolean (value, sugar_alignment_get_xignore (self));
		break;
		case SUGAR_ALIGNMENT_YIGNORE:
		g_value_set_boolean (value, sugar_alignment_get_yignore (self));
		break;
		case SUGAR_ALIGNMENT_CHILD_X:
		g_value_set_int (value, sugar_container_get_child_x ((SugarContainer*) self));
		break;
		case SUGAR_ALIGNMENT_CHILD_Y:
		g_value_set_int (value, sugar_container_get_child_y ((SugarContainer*) self));
		break;
		case SUGAR_ALIGNMENT_CHILD_WIDTH:
		g_value_set_int (value, sugar_container_get_child_width ((SugarContainer*) self));
		break;
		case SUGAR_ALIGNMENT_CHILD_HEIGHT:
		g_value_set_int (value, sugar_container_get_child_height ((SugarContainer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_alignment_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarAlignment * self;
	self = SUGAR_ALIGNMENT (object);
	switch (property_id) {
		case SUGAR_ALIGNMENT_XALIGN:
		sugar_alignment_set_xalign (self, g_value_get_float (value));
		break;
		case SUGAR_ALIGNMENT_YALIGN:
		sugar_alignment_set_yalign (self, g_value_get_float (value));
		break;
		case SUGAR_ALIGNMENT_XSCALE:
		sugar_alignment_set_xscale (self, g_value_get_float (value));
		break;
		case SUGAR_ALIGNMENT_YSCALE:
		sugar_alignment_set_yscale (self, g_value_get_float (value));
		break;
		case SUGAR_ALIGNMENT_XIGNORE:
		sugar_alignment_set_xignore (self, g_value_get_boolean (value));
		break;
		case SUGAR_ALIGNMENT_YIGNORE:
		sugar_alignment_set_yignore (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



