/* animator.c generated by valac 0.12.1, the Vala compiler
 * generated from animator.vala, do not modify */

/* animator.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Port from original sugar-toolkit project.
 * File:   src/sugar/graphics/animator.py
 * Commit: c9e63eb8eadb0b133b88e9feb1ca48b75d959a7c
 *
 * Copyright (C) 2007, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 * Port from original sugar-toolkit project.
 * File:   src/sugar/graphics/palettewindow.py
 * Commit: c684950ecff34e910e6da5840737a469f95a0e79
 *
 * Copyright (C) 2007, Eduardo Silva <edsiper@gmail.com>
 * Copyright (C) 2008, One Laptop Per Child
 * Copyright (C) 2009, Tomeu Vizoso
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/gui.h"
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SugarAnimatorPrivate {
	gdouble _duration;
	gint _timeout;
	gdouble _start;
	gdouble _stop;
	SugarAnimationType _type;
	guint _timeout_sid;
	SugarTimestamp _start_time;
};

struct _SugarMouseSpeedDetectorPrivate {
	gint _delay;
	gint _threshold;
	gint _state;
	guint _timeout_hid;
	gint _x;
	gint _y;
};


static gpointer sugar_animator_parent_class = NULL;
static gpointer sugar_mouse_speed_detector_parent_class = NULL;

#define SUGAR_ANIMATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_ANIMATOR, SugarAnimatorPrivate))
enum  {
	SUGAR_ANIMATOR_DUMMY_PROPERTY,
	SUGAR_ANIMATOR_ACTIVE
};
static gboolean _sugar_animator_next_frame_cb (SugarAnimator* self);
static gboolean __sugar_animator_next_frame_cb_gsource_func (gpointer self);
static void _sugar_animator_complete (SugarAnimator* self, gboolean aborted);
static void sugar_animator_finalize (GObject* obj);
static void _vala_sugar_animator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define SUGAR_MOUSE_SPEED_DETECTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_MOUSE_SPEED_DETECTOR, SugarMouseSpeedDetectorPrivate))
enum  {
	SUGAR_MOUSE_SPEED_DETECTOR_DUMMY_PROPERTY
};
#define SUGAR_MOUSE_SPEED_DETECTOR__MOTION_SLOW 1
#define SUGAR_MOUSE_SPEED_DETECTOR__MOTION_FAST 2
static void _sugar_mouse_speed_detector_init_position (SugarMouseSpeedDetector* self);
static gboolean _sugar_mouse_speed_detector_timer_cb (SugarMouseSpeedDetector* self);
static gboolean __sugar_mouse_speed_detector_timer_cb_gsource_func (gpointer self);
static gboolean _sugar_mouse_speed_detector_detect_motion (SugarMouseSpeedDetector* self);
static void sugar_mouse_speed_detector_finalize (GObject* obj);


GType sugar_animation_type_get_type (void) {
	static volatile gsize sugar_animation_type_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_animation_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SUGAR_ANIMATION_TYPE_OUT_EXPO, "SUGAR_ANIMATION_TYPE_OUT_EXPO", "out-expo"}, {SUGAR_ANIMATION_TYPE_IN_EXPO, "SUGAR_ANIMATION_TYPE_IN_EXPO", "in-expo"}, {0, NULL, NULL}};
		GType sugar_animation_type_type_id;
		sugar_animation_type_type_id = g_enum_register_static ("SugarAnimationType", values);
		g_once_init_leave (&sugar_animation_type_type_id__volatile, sugar_animation_type_type_id);
	}
	return sugar_animation_type_type_id__volatile;
}


/**
     * @param duration sec
     */
SugarAnimator* sugar_animator_construct (GType object_type, gdouble duration, gint fps, gdouble start, gdouble stop, SugarAnimationType type) {
	SugarAnimator * self = NULL;
	g_return_val_if_fail (duration > 0.0, NULL);
	g_return_val_if_fail (fps > 0, NULL);
	g_return_val_if_fail ((start >= 0.0) && (start <= 1.0), NULL);
	g_return_val_if_fail ((stop >= start) && (stop <= 1.0), NULL);
	self = (SugarAnimator*) g_object_new (object_type, NULL);
	self->priv->_duration = duration;
	self->priv->_timeout = (gint) ((1.0 / fps) * 1000);
	self->priv->_start = start;
	self->priv->_stop = stop;
	self->priv->_type = type;
	return self;
}


SugarAnimator* sugar_animator_new (gdouble duration, gint fps, gdouble start, gdouble stop, SugarAnimationType type) {
	return sugar_animator_construct (SUGAR_TYPE_ANIMATOR, duration, fps, start, stop, type);
}


static gboolean __sugar_animator_next_frame_cb_gsource_func (gpointer self) {
	gboolean result;
	result = _sugar_animator_next_frame_cb (self);
	return result;
}


void sugar_animator_start (SugarAnimator* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_timeout_sid == 0) {
		SugarTimestamp _tmp0_ = {0};
		SugarTimestamp _tmp1_ = {0};
		guint _tmp2_;
		sugar_timestamp_init (&_tmp0_);
		_tmp1_ = _tmp0_;
		self->priv->_start_time = _tmp1_;
		_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) self->priv->_timeout, __sugar_animator_next_frame_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->_timeout_sid = _tmp2_;
	}
}


void sugar_animator_abort (SugarAnimator* self) {
	g_return_if_fail (self != NULL);
	_sugar_animator_complete (self, TRUE);
}


static void _sugar_animator_complete (SugarAnimator* self, gboolean aborted) {
	g_return_if_fail (self != NULL);
	if (self->priv->_timeout_sid == 0) {
		return;
	}
	g_source_remove (self->priv->_timeout_sid);
	self->priv->_timeout_sid = (guint) 0;
	g_signal_emit_by_name (self, "completed", aborted);
}


static gboolean _sugar_animator_next_frame_cb (SugarAnimator* self) {
	gboolean result = FALSE;
	SugarTimestamp _tmp0_ = {0};
	SugarTimestamp _tmp1_ = {0};
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble offset;
	gdouble the_rest;
	gdouble frame;
	g_return_val_if_fail (self != NULL, FALSE);
	sugar_timestamp_init (&_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = sugar_timestamp_diff (&_tmp1_, &self->priv->_start_time);
	_tmp3_ = MIN (self->priv->_duration, _tmp2_);
	offset = _tmp3_;
	the_rest = self->priv->_stop - self->priv->_start;
	frame = self->priv->_stop;
	if (offset < self->priv->_duration) {
		if (self->priv->_type == SUGAR_ANIMATION_TYPE_OUT_EXPO) {
			gdouble _tmp4_;
			_tmp4_ = pow ((gdouble) 2, ((-10) * offset) / self->priv->_duration);
			frame = (the_rest * (1 - _tmp4_)) + self->priv->_start;
		} else {
			if (self->priv->_type == SUGAR_ANIMATION_TYPE_IN_EXPO) {
				gdouble _tmp5_;
				_tmp5_ = pow ((gdouble) 2, 10 * ((offset / self->priv->_duration) - 1));
				frame = (the_rest * _tmp5_) + self->priv->_start;
			}
		}
	}
	g_signal_emit_by_name (self, "next-frame", frame);
	if (offset < self->priv->_duration) {
		result = TRUE;
		return result;
	} else {
		_sugar_animator_complete (self, FALSE);
		result = FALSE;
		return result;
	}
}


gboolean sugar_animator_get_active (SugarAnimator* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_timeout_sid != 0;
	return result;
}


static void sugar_animator_class_init (SugarAnimatorClass * klass) {
	sugar_animator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarAnimatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_animator_get_property;
	G_OBJECT_CLASS (klass)->finalize = sugar_animator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ANIMATOR_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("next_frame", SUGAR_TYPE_ANIMATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
	g_signal_new ("completed", SUGAR_TYPE_ANIMATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void sugar_animator_instance_init (SugarAnimator * self) {
	self->priv = SUGAR_ANIMATOR_GET_PRIVATE (self);
	self->priv->_timeout_sid = (guint) 0;
}


static void sugar_animator_finalize (GObject* obj) {
	SugarAnimator * self;
	self = SUGAR_ANIMATOR (obj);
	G_OBJECT_CLASS (sugar_animator_parent_class)->finalize (obj);
}


GType sugar_animator_get_type (void) {
	static volatile gsize sugar_animator_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_animator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarAnimatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_animator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarAnimator), 0, (GInstanceInitFunc) sugar_animator_instance_init, NULL };
		GType sugar_animator_type_id;
		sugar_animator_type_id = g_type_register_static (G_TYPE_OBJECT, "SugarAnimator", &g_define_type_info, 0);
		g_once_init_leave (&sugar_animator_type_id__volatile, sugar_animator_type_id);
	}
	return sugar_animator_type_id__volatile;
}


static void _vala_sugar_animator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarAnimator * self;
	self = SUGAR_ANIMATOR (object);
	switch (property_id) {
		case SUGAR_ANIMATOR_ACTIVE:
		g_value_set_boolean (value, sugar_animator_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


/**
     * @param delay in msec
     * @param threshold in pixels (per tick of 'delay' msec)
     */
SugarMouseSpeedDetector* sugar_mouse_speed_detector_construct (GType object_type, gint delay, gint threshold) {
	SugarMouseSpeedDetector * self = NULL;
	self = (SugarMouseSpeedDetector*) g_object_new (object_type, NULL);
	self->priv->_delay = delay;
	self->priv->_threshold = threshold;
	return self;
}


SugarMouseSpeedDetector* sugar_mouse_speed_detector_new (gint delay, gint threshold) {
	return sugar_mouse_speed_detector_construct (SUGAR_TYPE_MOUSE_SPEED_DETECTOR, delay, threshold);
}


static gboolean __sugar_mouse_speed_detector_timer_cb_gsource_func (gpointer self) {
	gboolean result;
	result = _sugar_mouse_speed_detector_timer_cb (self);
	return result;
}


void sugar_mouse_speed_detector_start (SugarMouseSpeedDetector* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	sugar_mouse_speed_detector_stop (self);
	_sugar_mouse_speed_detector_init_position (self);
	_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) self->priv->_delay, __sugar_mouse_speed_detector_timer_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->_timeout_hid = _tmp0_;
}


void sugar_mouse_speed_detector_stop (SugarMouseSpeedDetector* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_timeout_hid != 0) {
		g_source_remove (self->priv->_timeout_hid);
		self->priv->_timeout_hid = (guint) 0;
	}
	self->priv->_state = 0;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _sugar_mouse_speed_detector_init_position (SugarMouseSpeedDetector* self) {
	GdkDisplay* _tmp0_ = NULL;
	GdkDisplay* _tmp1_;
	GdkDisplay* display;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	gdk_display_get_pointer (display, NULL, &_tmp2_, &_tmp3_, NULL);
	self->priv->_x = _tmp2_;
	self->priv->_y = _tmp3_;
	_g_object_unref0 (display);
}


static gboolean _sugar_mouse_speed_detector_timer_cb (SugarMouseSpeedDetector* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean motion;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = _sugar_mouse_speed_detector_detect_motion (self);
	motion = _tmp0_;
	if (motion) {
		_tmp1_ = self->priv->_state != SUGAR_MOUSE_SPEED_DETECTOR__MOTION_FAST;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		self->priv->_state = SUGAR_MOUSE_SPEED_DETECTOR__MOTION_FAST;
		g_signal_emit_by_name (self, "motion-fast");
	} else {
		gboolean _tmp2_ = FALSE;
		if (!motion) {
			_tmp2_ = self->priv->_state != SUGAR_MOUSE_SPEED_DETECTOR__MOTION_SLOW;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			self->priv->_state = SUGAR_MOUSE_SPEED_DETECTOR__MOTION_SLOW;
			g_signal_emit_by_name (self, "motion-slow");
		}
	}
	result = TRUE;
	return result;
}


static gboolean _sugar_mouse_speed_detector_detect_motion (SugarMouseSpeedDetector* self) {
	gboolean result = FALSE;
	gint x;
	gint y;
	gint dist2;
	g_return_val_if_fail (self != NULL, FALSE);
	x = self->priv->_x;
	y = self->priv->_y;
	_sugar_mouse_speed_detector_init_position (self);
	dist2 = ((x - self->priv->_x) * (x - self->priv->_x)) + ((y - self->priv->_y) * (y - self->priv->_y));
	result = dist2 > (self->priv->_threshold * self->priv->_threshold);
	return result;
}


static void sugar_mouse_speed_detector_class_init (SugarMouseSpeedDetectorClass * klass) {
	sugar_mouse_speed_detector_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarMouseSpeedDetectorPrivate));
	G_OBJECT_CLASS (klass)->finalize = sugar_mouse_speed_detector_finalize;
	g_signal_new ("motion_slow", SUGAR_TYPE_MOUSE_SPEED_DETECTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("motion_fast", SUGAR_TYPE_MOUSE_SPEED_DETECTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void sugar_mouse_speed_detector_instance_init (SugarMouseSpeedDetector * self) {
	self->priv = SUGAR_MOUSE_SPEED_DETECTOR_GET_PRIVATE (self);
	self->priv->_state = 0;
	self->priv->_timeout_hid = (guint) 0;
	self->priv->_x = 0;
	self->priv->_y = 0;
}


static void sugar_mouse_speed_detector_finalize (GObject* obj) {
	SugarMouseSpeedDetector * self;
	self = SUGAR_MOUSE_SPEED_DETECTOR (obj);
	G_OBJECT_CLASS (sugar_mouse_speed_detector_parent_class)->finalize (obj);
}


GType sugar_mouse_speed_detector_get_type (void) {
	static volatile gsize sugar_mouse_speed_detector_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_mouse_speed_detector_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarMouseSpeedDetectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_mouse_speed_detector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarMouseSpeedDetector), 0, (GInstanceInitFunc) sugar_mouse_speed_detector_instance_init, NULL };
		GType sugar_mouse_speed_detector_type_id;
		sugar_mouse_speed_detector_type_id = g_type_register_static (G_TYPE_OBJECT, "SugarMouseSpeedDetector", &g_define_type_info, 0);
		g_once_init_leave (&sugar_mouse_speed_detector_type_id__volatile, sugar_mouse_speed_detector_type_id);
	}
	return sugar_mouse_speed_detector_type_id__volatile;
}



