/* paletteconnector.c generated by valac 0.12.1, the Vala compiler
 * generated from paletteconnector.vala, do not modify */

/* paletteconnector.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Port from original sugar-toolkit project.
 * File:   src/sugar/graphics/palettewindow.py
 * Commit: c684950ecff34e910e6da5840737a469f95a0e79
 *
 * Copyright (C) 2007, Eduardo Silva <edsiper@gmail.com>
 * Copyright (C) 2008, One Laptop Per Child
 * Copyright (C) 2009, Tomeu Vizoso
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/gui.h"
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <polyol/env.h>
#include <float.h>
#include <math.h>
#include <string.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SugarConnectorPrivate {
	GObject* _subject;
	SugarPalettePosition _palette_position;
};


static gpointer sugar_connector_parent_class = NULL;
static gpointer sugar_widget_connector_parent_class = NULL;
static gpointer sugar_tool_connector_parent_class = NULL;

#define SUGAR_CONNECTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_CONNECTOR, SugarConnectorPrivate))
enum  {
	SUGAR_CONNECTOR_DUMMY_PROPERTY,
	SUGAR_CONNECTOR_SUBJECT,
	SUGAR_CONNECTOR_PALETTE_POSITION
};
static void _sugar_connector_get_alignment (SugarConnector* self, GtkRequisition* palette_size, SugarConnectorAlignment* result);
static void _sugar_connector_get_position_for_alignment (SugarConnector* self, SugarConnectorAlignment* alignment, GtkRequisition* palette_size, GdkRectangle* result);
static gboolean _sugar_connector_in_screen (SugarConnector* self, GdkRectangle* rect);
static void sugar_connector_real_on_popup (SugarConnector* self);
static void sugar_connector_real_on_popdown (SugarConnector* self);
static void sugar_connector_real_draw_rectangle (SugarConnector* self, GdkEventExpose* event, SugarPaletteWindow* palette);
static GtkWindow* sugar_connector_real_get_toplevel (SugarConnector* self);
static void sugar_connector_real_get_rect (SugarConnector* self, GdkRectangle* result);
static SugarConnectorAlignment* sugar_connector_real_get_alignments (SugarConnector* self, int* result_length1);
static gint _sugar_connector_get_area_in_screen (SugarConnector* self, GdkRectangle* rect);
static void sugar_connector_finalize (GObject* obj);
static void _vala_sugar_connector_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_connector_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	SUGAR_WIDGET_CONNECTOR_DUMMY_PROPERTY,
	SUGAR_WIDGET_CONNECTOR_WIDGET
};
static void sugar_widget_connector_real_draw_rectangle (SugarConnector* base, GdkEventExpose* event, SugarPaletteWindow* palette);
static void sugar_widget_connector_real_on_popup (SugarConnector* base);
static void sugar_widget_connector_real_on_popdown (SugarConnector* base);
static GtkWindow* sugar_widget_connector_real_get_toplevel (SugarConnector* base);
static void sugar_widget_connector_real_get_rect (SugarConnector* base, GdkRectangle* result);
static gboolean _sugar_widget_connector_enter_notify_event_cb (SugarWidgetConnector* self, GdkEventCrossing* event);
static gboolean _sugar_widget_connector_leave_notify_event_cb (SugarWidgetConnector* self, GdkEventCrossing* event);
static gboolean _sugar_widget_connector_button_release_event_cb (SugarWidgetConnector* self, GdkEventButton* event);
static void _sugar_widget_connector_hierarchy_changed_cb (SugarWidgetConnector* self, GtkWidget* previous_toplevel);
static gboolean __sugar_widget_connector_enter_notify_event_cb_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean __sugar_widget_connector_leave_notify_event_cb_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean __sugar_widget_connector_button_release_event_cb_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void __sugar_widget_connector_hierarchy_changed_cb_gtk_widget_hierarchy_changed (GtkWidget* _sender, GtkWidget* previous_toplevel, gpointer self);
static void _vala_sugar_widget_connector_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_widget_connector_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	SUGAR_TOOL_CONNECTOR_DUMMY_PROPERTY,
	SUGAR_TOOL_CONNECTOR_TOOL_ITEM
};
static SugarConnectorAlignment* sugar_tool_connector_real_get_alignments (SugarConnector* base, int* result_length1);
static void _vala_sugar_tool_connector_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_tool_connector_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const SugarConnectorAlignment SUGAR_CONNECTOR_ALIGNMENT_AT_CURSOR[4] = {{0.0f, 0.0f, 1.0f, 1.0f, -1}, {0.0f, -1.0f, 1.0f, 0.0f, -1}, {-1.0f, -1.0f, 0.0f, 0.0f, -1}, {-1.0f, 0.0f, 0.0f, 1.0f, -1}};
static const SugarConnectorAlignment SUGAR_CONNECTOR_ALIGNMENT_ANCHORED[8] = {{0.0f, 0.0f, 0.0f, 1.0f, (gint) GTK_POS_BOTTOM}, {-1.0f, 0.0f, 1.0f, 1.0f, (gint) GTK_POS_BOTTOM}, {0.0f, 0.0f, 1.0f, 0.0f, (gint) GTK_POS_RIGHT}, {0.0f, -1.0f, 1.0f, 1.0f, (gint) GTK_POS_RIGHT}, {0.0f, -1.0f, 0.0f, 0.0f, (gint) GTK_POS_TOP}, {-1.0f, -1.0f, 1.0f, 0.0f, (gint) GTK_POS_TOP}, {-1.0f, 0.0f, 0.0f, 0.0f, (gint) GTK_POS_LEFT}, {-1.0f, -1.0f, 0.0f, 1.0f, (gint) GTK_POS_LEFT}};
static const SugarConnectorAlignment SUGAR_TOOL_CONNECTOR_ALIGNMENT_HORIZONTAL[4] = {{0.0f, 0.0f, 0.0f, 1.0f, (gint) GTK_POS_BOTTOM}, {-1.0f, 0.0f, 1.0f, 1.0f, (gint) GTK_POS_BOTTOM}, {0.0f, -1.0f, 0.0f, 0.0f, (gint) GTK_POS_TOP}, {-1.0f, -1.0f, 1.0f, 0.0f, (gint) GTK_POS_TOP}};
static const SugarConnectorAlignment SUGAR_TOOL_CONNECTOR_ALIGNMENT_VERTICAL[4] = {{-1.0f, 0.0f, 0.0f, 0.0f, (gint) GTK_POS_LEFT}, {-1.0f, -1.0f, 0.0f, 1.0f, (gint) GTK_POS_LEFT}, {0.0f, 0.0f, 1.0f, 0.0f, (gint) GTK_POS_RIGHT}, {0.0f, -1.0f, 1.0f, 1.0f, (gint) GTK_POS_RIGHT}};

GType sugar_palette_position_get_type (void) {
	static volatile gsize sugar_palette_position_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_palette_position_type_id__volatile)) {
		static const GEnumValue values[] = {{SUGAR_PALETTE_POSITION_ANCHORED, "SUGAR_PALETTE_POSITION_ANCHORED", "anchored"}, {SUGAR_PALETTE_POSITION_AT_CURSOR, "SUGAR_PALETTE_POSITION_AT_CURSOR", "at-cursor"}, {0, NULL, NULL}};
		GType sugar_palette_position_type_id;
		sugar_palette_position_type_id = g_enum_register_static ("SugarPalettePosition", values);
		g_once_init_leave (&sugar_palette_position_type_id__volatile, sugar_palette_position_type_id);
	}
	return sugar_palette_position_type_id__volatile;
}


/** Helper function to find the gap position and size of widget a */
gboolean sugar_connector_get_box_gap (GdkRectangle* a, GdkRectangle* b, GtkPositionType* gap_side, gint* gap_start, gint* gap_size) {
	GtkPositionType _gap_side = 0;
	gint _gap_start = 0;
	gint _gap_size = 0;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	if (((*a).y + (*a).height) == (*b).y) {
		_gap_side = GTK_POS_BOTTOM;
	} else {
		if (((*a).x + (*a).width) == (*b).x) {
			_gap_side = GTK_POS_RIGHT;
		} else {
			if ((*a).x == ((*b).x + (*b).width)) {
				_gap_side = GTK_POS_LEFT;
			} else {
				if ((*a).y == ((*b).y + (*b).height)) {
					_gap_side = GTK_POS_TOP;
				} else {
					result = FALSE;
					if (gap_side) {
						*gap_side = _gap_side;
					}
					if (gap_start) {
						*gap_start = _gap_start;
					}
					if (gap_size) {
						*gap_size = _gap_size;
					}
					return result;
				}
			}
		}
	}
	if (_gap_side == GTK_POS_BOTTOM) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _gap_side == GTK_POS_TOP;
	}
	if (_tmp0_) {
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp1_ = MAX (0, (*b).x - (*a).x);
		_tmp2_ = MIN ((*a).width, _tmp1_);
		_gap_start = _tmp2_;
		_tmp3_ = MIN ((*a).width, ((*b).x + (*b).width) - (*a).x);
		_tmp4_ = MAX (0, _tmp3_ - _gap_start);
		_gap_size = _tmp4_;
	} else {
		gboolean _tmp5_ = FALSE;
		if (_gap_side == GTK_POS_RIGHT) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = _gap_side == GTK_POS_LEFT;
		}
		if (_tmp5_) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			_tmp6_ = MAX (0, (*b).y - (*a).y);
			_tmp7_ = MIN ((*a).height, _tmp6_);
			_gap_start = _tmp7_;
			_tmp8_ = MIN ((*a).height, ((*b).y + (*b).height) - (*a).y);
			_tmp9_ = MAX (0, _tmp8_ - _gap_start);
			_gap_size = _tmp9_;
		}
	}
	result = TRUE;
	if (gap_side) {
		*gap_side = _gap_side;
	}
	if (gap_start) {
		*gap_start = _gap_start;
	}
	if (gap_size) {
		*gap_size = _gap_size;
	}
	return result;
}


void sugar_connector_get_palette_pos (SugarConnector* self, GtkRequisition* palette_size, gint* x, gint* y) {
	gint _x = 0;
	gint _y = 0;
	SugarConnectorAlignment _tmp0_ = {0};
	SugarConnectorAlignment _tmp1_ = {0};
	SugarConnectorAlignment alignment;
	GdkRectangle _tmp2_ = {0};
	GdkRectangle _tmp3_ = {0};
	GdkRectangle rect;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_sugar_connector_get_alignment (self, palette_size, &_tmp0_);
	_tmp1_ = _tmp0_;
	alignment = _tmp1_;
	_sugar_connector_get_position_for_alignment (self, &alignment, palette_size, &_tmp2_);
	_tmp3_ = _tmp2_;
	rect = _tmp3_;
	_tmp4_ = _sugar_connector_in_screen (self, &rect);
	if (_tmp4_) {
		_x = rect.x;
		_y = rect.y;
	} else {
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp5_ = MAX (0, rect.x);
		_x = _tmp5_;
		_tmp6_ = MAX (0, rect.y);
		_y = _tmp6_;
		_tmp7_ = gdk_screen_width ();
		_tmp8_ = MIN (_x, _tmp7_ - rect.width);
		_x = _tmp8_;
		_tmp9_ = gdk_screen_height ();
		_tmp10_ = MIN (_y, _tmp9_ - rect.height);
		_y = _tmp10_;
	}
	if (x) {
		*x = _x;
	}
	if (y) {
		*y = _y;
	}
}


static void sugar_connector_real_on_popup (SugarConnector* self) {
	g_return_if_fail (self != NULL);
}


void sugar_connector_on_popup (SugarConnector* self) {
	SUGAR_CONNECTOR_GET_CLASS (self)->on_popup (self);
}


static void sugar_connector_real_on_popdown (SugarConnector* self) {
	g_return_if_fail (self != NULL);
}


void sugar_connector_on_popdown (SugarConnector* self) {
	SUGAR_CONNECTOR_GET_CLASS (self)->on_popdown (self);
}


static void sugar_connector_real_draw_rectangle (SugarConnector* self, GdkEventExpose* event, SugarPaletteWindow* palette) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `sugar_connector_draw_rectangle'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void sugar_connector_draw_rectangle (SugarConnector* self, GdkEventExpose* event, SugarPaletteWindow* palette) {
	SUGAR_CONNECTOR_GET_CLASS (self)->draw_rectangle (self, event, palette);
}


static GtkWindow* sugar_connector_real_get_toplevel (SugarConnector* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `sugar_connector_get_toplevel'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GtkWindow* sugar_connector_get_toplevel (SugarConnector* self) {
	return SUGAR_CONNECTOR_GET_CLASS (self)->get_toplevel (self);
}


static void sugar_connector_real_get_rect (SugarConnector* self, GdkRectangle* result) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `sugar_connector_get_rect'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void sugar_connector_get_rect (SugarConnector* self, GdkRectangle* result) {
	SUGAR_CONNECTOR_GET_CLASS (self)->get_rect (self, result);
}


static SugarConnectorAlignment* sugar_connector_real_get_alignments (SugarConnector* self, int* result_length1) {
	SugarConnectorAlignment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_palette_position == SUGAR_PALETTE_POSITION_AT_CURSOR) {
		SugarConnectorAlignment* _tmp0_;
		_tmp0_ = SUGAR_CONNECTOR_ALIGNMENT_AT_CURSOR;
		if (result_length1) {
			*result_length1 = G_N_ELEMENTS (SUGAR_CONNECTOR_ALIGNMENT_AT_CURSOR);
		}
		result = _tmp0_;
		return result;
	} else {
		SugarConnectorAlignment* _tmp1_;
		_tmp1_ = SUGAR_CONNECTOR_ALIGNMENT_ANCHORED;
		if (result_length1) {
			*result_length1 = G_N_ELEMENTS (SUGAR_CONNECTOR_ALIGNMENT_ANCHORED);
		}
		result = _tmp1_;
		return result;
	}
}


SugarConnectorAlignment* sugar_connector_get_alignments (SugarConnector* self, int* result_length1) {
	return SUGAR_CONNECTOR_GET_CLASS (self)->get_alignments (self, result_length1);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _sugar_connector_get_position_for_alignment (SugarConnector* self, SugarConnectorAlignment* alignment, GtkRequisition* palette_size, GdkRectangle* result) {
	GdkRectangle _tmp0_ = {0};
	GdkRectangle rect;
	g_return_if_fail (self != NULL);
	rect = _tmp0_;
	if (self->priv->_palette_position == SUGAR_PALETTE_POSITION_ANCHORED) {
		GdkRectangle _tmp1_ = {0};
		GdkRectangle _tmp2_ = {0};
		sugar_connector_get_rect (self, &_tmp1_);
		_tmp2_ = _tmp1_;
		rect = _tmp2_;
	} else {
		gint cursor_x = 0;
		gint cursor_y = 0;
		GdkDisplay* _tmp3_ = NULL;
		GdkDisplay* _tmp4_;
		GdkDisplay* display;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint dist;
		_tmp3_ = gdk_display_get_default ();
		_tmp4_ = _g_object_ref0 (_tmp3_);
		display = _tmp4_;
		gdk_display_get_pointer (display, NULL, &_tmp5_, &_tmp6_, NULL);
		cursor_x = _tmp5_;
		cursor_y = _tmp6_;
		_tmp7_ = sugar_metrics_get (SUGAR_PALETTE_CURSOR_DISTANCE);
		dist = _tmp7_;
		rect.x = cursor_x - dist;
		rect.y = cursor_y - dist;
		rect.width = dist * 2;
		rect.height = dist * 2;
		_g_object_unref0 (display);
	}
	rect.x = (gint) ((rect.x + (rect.width * (*alignment).invoker_halign)) + ((*palette_size).width * (*alignment).palette_halign));
	rect.y = (gint) ((rect.y + (rect.height * (*alignment).invoker_valign)) + ((*palette_size).height * (*alignment).palette_valign));
	rect.width = (*palette_size).width;
	rect.height = (*palette_size).height;
	*result = rect;
	return;
}


static void _sugar_connector_get_alignment (SugarConnector* self, GtkRequisition* palette_size, SugarConnectorAlignment* result) {
	gint best_area;
	SugarConnectorAlignment* best_alignment;
	gint _tmp0_;
	SugarConnectorAlignment* _tmp1_ = NULL;
	SugarConnectorAlignment _result_;
	GdkRectangle _tmp6_ = {0};
	GdkRectangle _tmp7_ = {0};
	GdkRectangle rect;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	best_area = -1;
	best_alignment = NULL;
	_tmp1_ = sugar_connector_get_alignments (self, &_tmp0_);
	{
		SugarConnectorAlignment* alignment_collection;
		int alignment_collection_length1;
		int alignment_it;
		alignment_collection = _tmp1_;
		alignment_collection_length1 = _tmp0_;
		for (alignment_it = 0; alignment_it < _tmp0_; alignment_it = alignment_it + 1) {
			SugarConnectorAlignment alignment;
			alignment = alignment_collection[alignment_it];
			{
				GdkRectangle _tmp2_ = {0};
				GdkRectangle _tmp3_ = {0};
				GdkRectangle rect;
				gboolean _tmp4_;
				gint _tmp5_;
				gint area;
				_sugar_connector_get_position_for_alignment (self, &alignment, palette_size, &_tmp2_);
				_tmp3_ = _tmp2_;
				rect = _tmp3_;
				_tmp4_ = _sugar_connector_in_screen (self, &rect);
				if (_tmp4_) {
					*result = alignment;
					return;
				}
				_tmp5_ = _sugar_connector_get_area_in_screen (self, &rect);
				area = _tmp5_;
				if (area > best_area) {
					best_alignment = &alignment;
					best_area = area;
				}
			}
		}
	}
	_result_ = *best_alignment;
	sugar_connector_get_rect (self, &_tmp6_);
	_tmp7_ = _tmp6_;
	rect = _tmp7_;
	if (_result_.position == GTK_POS_LEFT) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = _result_.position == GTK_POS_RIGHT;
	}
	if (_tmp8_) {
		gint top;
		gint _tmp9_;
		gint bottom;
		top = rect.y;
		_tmp9_ = gdk_screen_height ();
		bottom = (_tmp9_ - rect.y) - rect.width;
		if (top > bottom) {
			_result_.palette_valign = (-((gfloat) top)) / (*palette_size).height;
		} else {
			_result_.palette_valign = (-((gfloat) (((*palette_size).height - bottom) - rect.height))) / (*palette_size).height;
		}
		_result_.invoker_valign = (gfloat) 0;
	} else {
		gboolean _tmp10_ = FALSE;
		if (_result_.position == GTK_POS_TOP) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = _result_.position == GTK_POS_BOTTOM;
		}
		if (_tmp10_) {
			gint left;
			gint _tmp11_;
			gint right;
			left = rect.x;
			_tmp11_ = gdk_screen_width ();
			right = (_tmp11_ - rect.x) - rect.width;
			if (left > right) {
				_result_.palette_halign = (-((gfloat) left)) / (*palette_size).width;
			} else {
				_result_.palette_halign = (-((gfloat) (((*palette_size).width - right) - rect.width))) / (*palette_size).width;
			}
			_result_.invoker_halign = (gfloat) 0;
		}
	}
	*result = _result_;
	return;
}


/** Return area of rectangle visible in the screen */
static gint _sugar_connector_get_area_in_screen (SugarConnector* self, GdkRectangle* rect) {
	gint result = 0;
	gint _tmp0_;
	gint x1;
	gint _tmp1_;
	gint y1;
	gint _tmp2_;
	gint _tmp3_;
	gint x2;
	gint _tmp4_;
	gint _tmp5_;
	gint y2;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = MAX (0, (*rect).x);
	x1 = _tmp0_;
	_tmp1_ = MAX (0, (*rect).y);
	y1 = _tmp1_;
	_tmp2_ = gdk_screen_width ();
	_tmp3_ = MIN (_tmp2_, (*rect).x + (*rect).width);
	x2 = _tmp3_;
	_tmp4_ = gdk_screen_height ();
	_tmp5_ = MIN (_tmp4_, (*rect).y + (*rect).height);
	y2 = _tmp5_;
	result = (x2 - x1) * (y2 - y1);
	return result;
}


static gboolean _sugar_connector_in_screen (SugarConnector* self, GdkRectangle* rect) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*rect).x >= 0) {
		_tmp2_ = (*rect).y >= 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp3_;
		_tmp3_ = gdk_screen_width ();
		_tmp1_ = ((*rect).x + (*rect).width) <= _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp4_;
		_tmp4_ = gdk_screen_height ();
		_tmp0_ = ((*rect).y + (*rect).height) <= _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


SugarConnector* sugar_connector_construct (GType object_type) {
	SugarConnector * self = NULL;
	self = (SugarConnector*) g_object_new (object_type, NULL);
	return self;
}


GObject* sugar_connector_get_subject (SugarConnector* self) {
	GObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_subject;
	return result;
}


void sugar_connector_set_subject (SugarConnector* self, GObject* value) {
	GObject* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_subject);
	self->priv->_subject = _tmp0_;
	g_object_notify ((GObject *) self, "subject");
}


SugarPalettePosition sugar_connector_get_palette_position (SugarConnector* self) {
	SugarPalettePosition result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_palette_position;
	return result;
}


void sugar_connector_set_palette_position (SugarConnector* self, SugarPalettePosition value) {
	g_return_if_fail (self != NULL);
	self->priv->_palette_position = value;
	g_object_notify ((GObject *) self, "palette-position");
}


SugarConnectorAlignment* sugar_connector_alignment_dup (const SugarConnectorAlignment* self) {
	SugarConnectorAlignment* dup;
	dup = g_new0 (SugarConnectorAlignment, 1);
	memcpy (dup, self, sizeof (SugarConnectorAlignment));
	return dup;
}


void sugar_connector_alignment_free (SugarConnectorAlignment* self) {
	g_free (self);
}


GType sugar_connector_alignment_get_type (void) {
	static volatile gsize sugar_connector_alignment_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_connector_alignment_type_id__volatile)) {
		GType sugar_connector_alignment_type_id;
		sugar_connector_alignment_type_id = g_boxed_type_register_static ("SugarConnectorAlignment", (GBoxedCopyFunc) sugar_connector_alignment_dup, (GBoxedFreeFunc) sugar_connector_alignment_free);
		g_once_init_leave (&sugar_connector_alignment_type_id__volatile, sugar_connector_alignment_type_id);
	}
	return sugar_connector_alignment_type_id__volatile;
}


static void sugar_connector_class_init (SugarConnectorClass * klass) {
	sugar_connector_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarConnectorPrivate));
	SUGAR_CONNECTOR_CLASS (klass)->on_popup = sugar_connector_real_on_popup;
	SUGAR_CONNECTOR_CLASS (klass)->on_popdown = sugar_connector_real_on_popdown;
	SUGAR_CONNECTOR_CLASS (klass)->draw_rectangle = sugar_connector_real_draw_rectangle;
	SUGAR_CONNECTOR_CLASS (klass)->get_toplevel = sugar_connector_real_get_toplevel;
	SUGAR_CONNECTOR_CLASS (klass)->get_rect = sugar_connector_real_get_rect;
	SUGAR_CONNECTOR_CLASS (klass)->get_alignments = sugar_connector_real_get_alignments;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_connector_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_connector_set_property;
	G_OBJECT_CLASS (klass)->finalize = sugar_connector_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_CONNECTOR_SUBJECT, g_param_spec_object ("subject", "subject", "subject", G_TYPE_OBJECT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_CONNECTOR_PALETTE_POSITION, g_param_spec_enum ("palette-position", "palette-position", "palette-position", SUGAR_TYPE_PALETTE_POSITION, SUGAR_PALETTE_POSITION_ANCHORED, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("invoker_enter", SUGAR_TYPE_CONNECTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("invoker_leave", SUGAR_TYPE_CONNECTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("popup", SUGAR_TYPE_CONNECTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("popdown", SUGAR_TYPE_CONNECTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void sugar_connector_instance_init (SugarConnector * self) {
	self->priv = SUGAR_CONNECTOR_GET_PRIVATE (self);
	self->priv->_palette_position = SUGAR_PALETTE_POSITION_ANCHORED;
}


static void sugar_connector_finalize (GObject* obj) {
	SugarConnector * self;
	self = SUGAR_CONNECTOR (obj);
	_g_object_unref0 (self->priv->_subject);
	G_OBJECT_CLASS (sugar_connector_parent_class)->finalize (obj);
}


GType sugar_connector_get_type (void) {
	static volatile gsize sugar_connector_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_connector_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarConnectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_connector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarConnector), 0, (GInstanceInitFunc) sugar_connector_instance_init, NULL };
		GType sugar_connector_type_id;
		sugar_connector_type_id = g_type_register_static (G_TYPE_OBJECT, "SugarConnector", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&sugar_connector_type_id__volatile, sugar_connector_type_id);
	}
	return sugar_connector_type_id__volatile;
}


static void _vala_sugar_connector_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarConnector * self;
	self = SUGAR_CONNECTOR (object);
	switch (property_id) {
		case SUGAR_CONNECTOR_SUBJECT:
		g_value_set_object (value, sugar_connector_get_subject (self));
		break;
		case SUGAR_CONNECTOR_PALETTE_POSITION:
		g_value_set_enum (value, sugar_connector_get_palette_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_connector_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarConnector * self;
	self = SUGAR_CONNECTOR (object);
	switch (property_id) {
		case SUGAR_CONNECTOR_SUBJECT:
		sugar_connector_set_subject (self, g_value_get_object (value));
		break;
		case SUGAR_CONNECTOR_PALETTE_POSITION:
		sugar_connector_set_palette_position (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


SugarWidgetConnector* sugar_widget_connector_construct (GType object_type, GtkWidget* widget) {
	SugarWidgetConnector * self = NULL;
	g_return_val_if_fail (widget != NULL, NULL);
	self = (SugarWidgetConnector*) g_object_new (object_type, "widget", widget, NULL);
	return self;
}


SugarWidgetConnector* sugar_widget_connector_new (GtkWidget* widget) {
	return sugar_widget_connector_construct (SUGAR_TYPE_WIDGET_CONNECTOR, widget);
}


static void sugar_widget_connector_real_draw_rectangle (SugarConnector* base, GdkEventExpose* event, SugarPaletteWindow* palette) {
	SugarWidgetConnector * self;
	GtkPositionType gap_side = 0;
	gint gap_start = 0;
	gint gap_size = 0;
	gint x;
	gint y;
	GtkWidget* _tmp0_ = NULL;
	gboolean _tmp1_;
	GdkRectangle _tmp4_ = {0};
	GdkRectangle _tmp5_ = {0};
	GdkRectangle _tmp6_ = {0};
	GdkRectangle _tmp7_ = {0};
	GtkPositionType _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gboolean _tmp11_;
	self = (SugarWidgetConnector*) base;
	g_return_if_fail (palette != NULL);
	x = 0;
	y = 0;
	_tmp0_ = sugar_widget_connector_get_widget (self);
	_tmp1_ = GTK_WIDGET_NO_WINDOW (_tmp0_);
	if (_tmp1_) {
		GtkWidget* _tmp2_ = NULL;
		GtkWidget* _tmp3_ = NULL;
		_tmp2_ = sugar_widget_connector_get_widget (self);
		x = _tmp2_->allocation.x;
		_tmp3_ = sugar_widget_connector_get_widget (self);
		y = _tmp3_->allocation.y;
	}
	sugar_connector_get_rect ((SugarConnector*) self, &_tmp4_);
	_tmp5_ = _tmp4_;
	sugar_palette_window_get_rect (palette, &_tmp6_);
	_tmp7_ = _tmp6_;
	_tmp11_ = sugar_connector_get_box_gap (&_tmp5_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
	gap_side = _tmp8_;
	gap_start = _tmp9_;
	gap_size = _tmp10_;
	if (_tmp11_) {
		GtkWidget* _tmp12_ = NULL;
		GtkStyle* _tmp13_ = NULL;
		GtkWidget* _tmp14_ = NULL;
		GtkWidget* _tmp15_ = NULL;
		GtkWidget* _tmp16_ = NULL;
		_tmp12_ = sugar_widget_connector_get_widget (self);
		_tmp13_ = gtk_widget_get_style (_tmp12_);
		_tmp14_ = sugar_widget_connector_get_widget (self);
		_tmp15_ = sugar_widget_connector_get_widget (self);
		_tmp16_ = sugar_widget_connector_get_widget (self);
		gtk_paint_box_gap (_tmp13_, (*event).window, GTK_STATE_PRELIGHT, GTK_SHADOW_IN, &(*event).area, _tmp14_, "palette-invoker", x, y, _tmp15_->allocation.width, _tmp16_->allocation.height, gap_side, gap_start, gap_size);
	} else {
		GtkWidget* _tmp17_ = NULL;
		GtkStyle* _tmp18_ = NULL;
		GtkWidget* _tmp19_ = NULL;
		GtkWidget* _tmp20_ = NULL;
		GtkWidget* _tmp21_ = NULL;
		_tmp17_ = sugar_widget_connector_get_widget (self);
		_tmp18_ = gtk_widget_get_style (_tmp17_);
		_tmp19_ = sugar_widget_connector_get_widget (self);
		_tmp20_ = sugar_widget_connector_get_widget (self);
		_tmp21_ = sugar_widget_connector_get_widget (self);
		gtk_paint_box (_tmp18_, (*event).window, GTK_STATE_PRELIGHT, GTK_SHADOW_IN, &(*event).area, _tmp19_, "palette-invoker", x, y, _tmp20_->allocation.width, _tmp21_->allocation.height);
	}
}


static void sugar_widget_connector_real_on_popup (SugarConnector* base) {
	SugarWidgetConnector * self;
	GtkWidget* _tmp0_ = NULL;
	self = (SugarWidgetConnector*) base;
	_tmp0_ = sugar_widget_connector_get_widget (self);
	gtk_widget_queue_draw (_tmp0_);
}


static void sugar_widget_connector_real_on_popdown (SugarConnector* base) {
	SugarWidgetConnector * self;
	GtkWidget* _tmp0_ = NULL;
	self = (SugarWidgetConnector*) base;
	_tmp0_ = sugar_widget_connector_get_widget (self);
	gtk_widget_queue_draw (_tmp0_);
}


static GtkWindow* sugar_widget_connector_real_get_toplevel (SugarConnector* base) {
	SugarWidgetConnector * self;
	GtkWindow* result = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_;
	self = (SugarWidgetConnector*) base;
	_tmp0_ = sugar_widget_connector_get_widget (self);
	_tmp1_ = gtk_widget_get_toplevel (_tmp0_);
	_tmp2_ = _tmp1_;
	result = GTK_IS_WINDOW (_tmp2_) ? ((GtkWindow*) _tmp2_) : NULL;
	return result;
}


static void sugar_widget_connector_real_get_rect (SugarConnector* base, GdkRectangle* result) {
	SugarWidgetConnector * self;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GdkRectangle _tmp2_ = {0};
	GdkRectangle _result_;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp7_ = NULL;
	gboolean _tmp8_;
	self = (SugarWidgetConnector*) base;
	_tmp0_ = sugar_widget_connector_get_widget (self);
	_tmp1_ = sugar_widget_connector_get_widget (self);
	_tmp2_.x = 0;
	_tmp2_.y = 0;
	_tmp2_.width = _tmp0_->allocation.width;
	_tmp2_.height = _tmp1_->allocation.height;
	_result_ = _tmp2_;
	_tmp3_ = sugar_widget_connector_get_widget (self);
	if (_tmp3_->window != NULL) {
		GtkWidget* _tmp4_ = NULL;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = sugar_widget_connector_get_widget (self);
		gdk_window_get_origin (_tmp4_->window, &_tmp5_, &_tmp6_);
		_result_.x = _tmp5_;
		_result_.y = _tmp6_;
	} else {
		g_warning ("paletteconnector.vala:326: %s", "Trying to position palette with invoker " "that's not realized.");
	}
	_tmp7_ = sugar_widget_connector_get_widget (self);
	_tmp8_ = GTK_WIDGET_NO_WINDOW (_tmp7_);
	if (_tmp8_) {
		GtkWidget* _tmp9_ = NULL;
		GtkWidget* _tmp10_ = NULL;
		_tmp9_ = sugar_widget_connector_get_widget (self);
		_result_.x = _result_.x + _tmp9_->allocation.x;
		_tmp10_ = sugar_widget_connector_get_widget (self);
		_result_.y = _result_.y + _tmp10_->allocation.y;
	}
	*result = _result_;
	return;
}


static gboolean _sugar_widget_connector_enter_notify_event_cb (SugarWidgetConnector* self, GdkEventCrossing* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit_by_name ((SugarConnector*) self, "invoker-enter");
	result = FALSE;
	return result;
}


static gboolean _sugar_widget_connector_leave_notify_event_cb (SugarWidgetConnector* self, GdkEventCrossing* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit_by_name ((SugarConnector*) self, "invoker-leave");
	result = FALSE;
	return result;
}


static gboolean _sugar_widget_connector_button_release_event_cb (SugarWidgetConnector* self, GdkEventButton* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).button == 3) {
		g_signal_emit_by_name ((SugarConnector*) self, "popup");
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static void _sugar_widget_connector_hierarchy_changed_cb (SugarWidgetConnector* self, GtkWidget* previous_toplevel) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((SugarConnector*) self, "popdown");
}


GtkWidget* sugar_widget_connector_get_widget (SugarWidgetConnector* self) {
	GtkWidget* result;
	GObject* _tmp0_ = NULL;
	GObject* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sugar_connector_get_subject ((SugarConnector*) self);
	_tmp1_ = _tmp0_;
	result = GTK_IS_WIDGET (_tmp1_) ? ((GtkWidget*) _tmp1_) : NULL;
	return result;
}


static gboolean __sugar_widget_connector_enter_notify_event_cb_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _sugar_widget_connector_enter_notify_event_cb (self, event);
	return result;
}


static gboolean __sugar_widget_connector_leave_notify_event_cb_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _sugar_widget_connector_leave_notify_event_cb (self, event);
	return result;
}


static gboolean __sugar_widget_connector_button_release_event_cb_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _sugar_widget_connector_button_release_event_cb (self, event);
	return result;
}


static void __sugar_widget_connector_hierarchy_changed_cb_gtk_widget_hierarchy_changed (GtkWidget* _sender, GtkWidget* previous_toplevel, gpointer self) {
	_sugar_widget_connector_hierarchy_changed_cb (self, previous_toplevel);
}


void sugar_widget_connector_set_widget (SugarWidgetConnector* self, GtkWidget* value) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_widget_connector_get_widget (self);
	if (_tmp0_ != NULL) {
		GtkWidget* _tmp1_ = NULL;
		guint _tmp2_;
		GtkWidget* _tmp3_ = NULL;
		guint _tmp4_;
		GtkWidget* _tmp5_ = NULL;
		guint _tmp6_;
		GtkWidget* _tmp7_ = NULL;
		guint _tmp8_;
		_tmp1_ = sugar_widget_connector_get_widget (self);
		g_signal_parse_name ("enter-notify-event", GTK_TYPE_WIDGET, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) __sugar_widget_connector_enter_notify_event_cb_gtk_widget_enter_notify_event, self);
		_tmp3_ = sugar_widget_connector_get_widget (self);
		g_signal_parse_name ("leave-notify-event", GTK_TYPE_WIDGET, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) __sugar_widget_connector_leave_notify_event_cb_gtk_widget_leave_notify_event, self);
		_tmp5_ = sugar_widget_connector_get_widget (self);
		g_signal_parse_name ("button-release-event", GTK_TYPE_WIDGET, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) __sugar_widget_connector_button_release_event_cb_gtk_widget_button_release_event, self);
		_tmp7_ = sugar_widget_connector_get_widget (self);
		g_signal_parse_name ("hierarchy-changed", GTK_TYPE_WIDGET, &_tmp8_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) __sugar_widget_connector_hierarchy_changed_cb_gtk_widget_hierarchy_changed, self);
	}
	sugar_connector_set_subject ((SugarConnector*) self, (GObject*) value);
	_tmp9_ = sugar_widget_connector_get_widget (self);
	if (_tmp9_ != NULL) {
		GtkWidget* _tmp10_ = NULL;
		GtkWidget* _tmp11_ = NULL;
		GtkWidget* _tmp12_ = NULL;
		GtkWidget* _tmp13_ = NULL;
		_tmp10_ = sugar_widget_connector_get_widget (self);
		g_signal_connect_object (_tmp10_, "enter-notify-event", (GCallback) __sugar_widget_connector_enter_notify_event_cb_gtk_widget_enter_notify_event, self, 0);
		_tmp11_ = sugar_widget_connector_get_widget (self);
		g_signal_connect_object (_tmp11_, "leave-notify-event", (GCallback) __sugar_widget_connector_leave_notify_event_cb_gtk_widget_leave_notify_event, self, 0);
		_tmp12_ = sugar_widget_connector_get_widget (self);
		g_signal_connect_object (_tmp12_, "button-release-event", (GCallback) __sugar_widget_connector_button_release_event_cb_gtk_widget_button_release_event, self, 0);
		_tmp13_ = sugar_widget_connector_get_widget (self);
		g_signal_connect_object (_tmp13_, "hierarchy-changed", (GCallback) __sugar_widget_connector_hierarchy_changed_cb_gtk_widget_hierarchy_changed, self, 0);
	}
	g_object_notify ((GObject *) self, "widget");
}


static void sugar_widget_connector_class_init (SugarWidgetConnectorClass * klass) {
	sugar_widget_connector_parent_class = g_type_class_peek_parent (klass);
	SUGAR_CONNECTOR_CLASS (klass)->draw_rectangle = sugar_widget_connector_real_draw_rectangle;
	SUGAR_CONNECTOR_CLASS (klass)->on_popup = sugar_widget_connector_real_on_popup;
	SUGAR_CONNECTOR_CLASS (klass)->on_popdown = sugar_widget_connector_real_on_popdown;
	SUGAR_CONNECTOR_CLASS (klass)->get_toplevel = sugar_widget_connector_real_get_toplevel;
	SUGAR_CONNECTOR_CLASS (klass)->get_rect = sugar_widget_connector_real_get_rect;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_widget_connector_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_widget_connector_set_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_WIDGET_CONNECTOR_WIDGET, g_param_spec_object ("widget", "widget", "widget", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void sugar_widget_connector_instance_init (SugarWidgetConnector * self) {
}


GType sugar_widget_connector_get_type (void) {
	static volatile gsize sugar_widget_connector_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_widget_connector_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarWidgetConnectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_widget_connector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarWidgetConnector), 0, (GInstanceInitFunc) sugar_widget_connector_instance_init, NULL };
		GType sugar_widget_connector_type_id;
		sugar_widget_connector_type_id = g_type_register_static (SUGAR_TYPE_CONNECTOR, "SugarWidgetConnector", &g_define_type_info, 0);
		g_once_init_leave (&sugar_widget_connector_type_id__volatile, sugar_widget_connector_type_id);
	}
	return sugar_widget_connector_type_id__volatile;
}


static void _vala_sugar_widget_connector_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarWidgetConnector * self;
	self = SUGAR_WIDGET_CONNECTOR (object);
	switch (property_id) {
		case SUGAR_WIDGET_CONNECTOR_WIDGET:
		g_value_set_object (value, sugar_widget_connector_get_widget (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_widget_connector_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarWidgetConnector * self;
	self = SUGAR_WIDGET_CONNECTOR (object);
	switch (property_id) {
		case SUGAR_WIDGET_CONNECTOR_WIDGET:
		sugar_widget_connector_set_widget (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


SugarToolConnector* sugar_tool_connector_construct (GType object_type, GtkToolItem* tool_item) {
	SugarToolConnector * self = NULL;
	g_return_val_if_fail (tool_item != NULL, NULL);
	self = (SugarToolConnector*) g_object_new (object_type, "tool-item", tool_item, NULL);
	return self;
}


SugarToolConnector* sugar_tool_connector_new (GtkToolItem* tool_item) {
	return sugar_tool_connector_construct (SUGAR_TYPE_TOOL_CONNECTOR, tool_item);
}


static SugarConnectorAlignment* sugar_tool_connector_real_get_alignments (SugarConnector* base, int* result_length1) {
	SugarToolConnector * self;
	SugarConnectorAlignment* result = NULL;
	GtkToolItem* _tmp0_ = NULL;
	GtkContainer* _tmp1_ = NULL;
	GtkContainer* _tmp2_;
	GtkToolbar* _tmp3_;
	GtkToolbar* toolbar;
	self = (SugarToolConnector*) base;
	_tmp0_ = sugar_tool_connector_get_tool_item (self);
	_tmp1_ = gtk_widget_get_parent ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (GTK_IS_TOOLBAR (_tmp2_) ? ((GtkToolbar*) _tmp2_) : NULL);
	toolbar = _tmp3_;
	if (toolbar == NULL) {
		gint _tmp4_;
		SugarConnectorAlignment* _tmp5_ = NULL;
		SugarConnectorAlignment* _tmp6_;
		_tmp5_ = SUGAR_CONNECTOR_CLASS (sugar_tool_connector_parent_class)->get_alignments ((SugarConnector*) SUGAR_WIDGET_CONNECTOR (self), &_tmp4_);
		_tmp6_ = _tmp5_;
		if (result_length1) {
			*result_length1 = _tmp4_;
		}
		result = _tmp6_;
		_g_object_unref0 (toolbar);
		return result;
	} else {
		if (toolbar->orientation == GTK_ORIENTATION_HORIZONTAL) {
			SugarConnectorAlignment* _tmp7_;
			_tmp7_ = SUGAR_TOOL_CONNECTOR_ALIGNMENT_HORIZONTAL;
			if (result_length1) {
				*result_length1 = G_N_ELEMENTS (SUGAR_TOOL_CONNECTOR_ALIGNMENT_HORIZONTAL);
			}
			result = _tmp7_;
			_g_object_unref0 (toolbar);
			return result;
		} else {
			SugarConnectorAlignment* _tmp8_;
			_tmp8_ = SUGAR_TOOL_CONNECTOR_ALIGNMENT_VERTICAL;
			if (result_length1) {
				*result_length1 = G_N_ELEMENTS (SUGAR_TOOL_CONNECTOR_ALIGNMENT_VERTICAL);
			}
			result = _tmp8_;
			_g_object_unref0 (toolbar);
			return result;
		}
	}
	_g_object_unref0 (toolbar);
}


GtkToolItem* sugar_tool_connector_get_tool_item (SugarToolConnector* self) {
	GtkToolItem* result;
	GtkWidget* _tmp0_ = NULL;
	GtkContainer* _tmp1_ = NULL;
	GtkContainer* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sugar_widget_connector_get_widget ((SugarWidgetConnector*) self);
	_tmp1_ = gtk_widget_get_parent (_tmp0_);
	_tmp2_ = _tmp1_;
	result = GTK_IS_TOOL_ITEM (_tmp2_) ? ((GtkToolItem*) _tmp2_) : NULL;
	return result;
}


void sugar_tool_connector_set_tool_item (SugarToolConnector* self, GtkToolItem* value) {
	g_return_if_fail (self != NULL);
	if (value == NULL) {
		sugar_widget_connector_set_widget ((SugarWidgetConnector*) self, NULL);
	} else {
		sugar_widget_connector_set_widget ((SugarWidgetConnector*) self, ((GtkBin*) value)->child);
	}
	g_object_notify ((GObject *) self, "tool-item");
}


static void sugar_tool_connector_class_init (SugarToolConnectorClass * klass) {
	sugar_tool_connector_parent_class = g_type_class_peek_parent (klass);
	SUGAR_CONNECTOR_CLASS (klass)->get_alignments = sugar_tool_connector_real_get_alignments;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_tool_connector_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_tool_connector_set_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOOL_CONNECTOR_TOOL_ITEM, g_param_spec_object ("tool-item", "tool-item", "tool-item", GTK_TYPE_TOOL_ITEM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void sugar_tool_connector_instance_init (SugarToolConnector * self) {
}


GType sugar_tool_connector_get_type (void) {
	static volatile gsize sugar_tool_connector_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_tool_connector_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarToolConnectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_tool_connector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarToolConnector), 0, (GInstanceInitFunc) sugar_tool_connector_instance_init, NULL };
		GType sugar_tool_connector_type_id;
		sugar_tool_connector_type_id = g_type_register_static (SUGAR_TYPE_WIDGET_CONNECTOR, "SugarToolConnector", &g_define_type_info, 0);
		g_once_init_leave (&sugar_tool_connector_type_id__volatile, sugar_tool_connector_type_id);
	}
	return sugar_tool_connector_type_id__volatile;
}


static void _vala_sugar_tool_connector_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarToolConnector * self;
	self = SUGAR_TOOL_CONNECTOR (object);
	switch (property_id) {
		case SUGAR_TOOL_CONNECTOR_TOOL_ITEM:
		g_value_set_object (value, sugar_tool_connector_get_tool_item (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_tool_connector_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarToolConnector * self;
	self = SUGAR_TOOL_CONNECTOR (object);
	switch (property_id) {
		case SUGAR_TOOL_CONNECTOR_TOOL_ITEM:
		sugar_tool_connector_set_tool_item (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



