/* shell.c generated by valac 0.12.1, the Vala compiler
 * generated from shell.vala, do not modify */

/* shell.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/shell.h"
#include <stdlib.h>
#include <string.h>
#include <polyol/env.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>


#define SUGAR_TYPE_SHELL_SERVICE (sugar_shell_service_get_type ())
#define SUGAR_SHELL_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_TYPE_SHELL_SERVICE, SugarShellService))
#define SUGAR_SHELL_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_TYPE_SHELL_SERVICE, SugarShellServiceClass))
#define SUGAR_IS_SHELL_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_TYPE_SHELL_SERVICE))
#define SUGAR_IS_SHELL_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_TYPE_SHELL_SERVICE))
#define SUGAR_SHELL_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_TYPE_SHELL_SERVICE, SugarShellServiceClass))

typedef struct _SugarShellService SugarShellService;
typedef struct _SugarShellServiceClass SugarShellServiceClass;

#define SUGAR_TYPE_ACTIVITY_SERVICE (sugar_activity_service_get_type ())
#define SUGAR_ACTIVITY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_TYPE_ACTIVITY_SERVICE, SugarActivityService))
#define SUGAR_ACTIVITY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_TYPE_ACTIVITY_SERVICE, SugarActivityServiceClass))
#define SUGAR_IS_ACTIVITY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_TYPE_ACTIVITY_SERVICE))
#define SUGAR_IS_ACTIVITY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_TYPE_ACTIVITY_SERVICE))
#define SUGAR_ACTIVITY_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_TYPE_ACTIVITY_SERVICE, SugarActivityServiceClass))

typedef struct _SugarActivityService SugarActivityService;
typedef struct _SugarActivityServiceClass SugarActivityServiceClass;
#define _sugar_shell_service_unref0(var) ((var == NULL) ? NULL : (var = (sugar_shell_service_unref (var), NULL)))
#define _sugar_activity_service_unref0(var) ((var == NULL) ? NULL : (var = (sugar_activity_service_unref (var), NULL)))
typedef struct _SugarShellServicePrivate SugarShellServicePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SugarActivityServicePrivate SugarActivityServicePrivate;

#define SUGAR_ACTIVITY_SERVICE_TYPE_SERVER (sugar_activity_service_server_get_type ())
#define SUGAR_ACTIVITY_SERVICE_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_ACTIVITY_SERVICE_TYPE_SERVER, SugarActivityServiceServer))
#define SUGAR_ACTIVITY_SERVICE_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_ACTIVITY_SERVICE_TYPE_SERVER, SugarActivityServiceServerClass))
#define SUGAR_ACTIVITY_SERVICE_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_ACTIVITY_SERVICE_TYPE_SERVER))
#define SUGAR_ACTIVITY_SERVICE_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_ACTIVITY_SERVICE_TYPE_SERVER))
#define SUGAR_ACTIVITY_SERVICE_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_ACTIVITY_SERVICE_TYPE_SERVER, SugarActivityServiceServerClass))

typedef struct _SugarActivityServiceServer SugarActivityServiceServer;
typedef struct _SugarActivityServiceServerClass SugarActivityServiceServerClass;
typedef struct _SugarActivityServiceServerPrivate SugarActivityServiceServerPrivate;

struct _SugarShellPrivate {
	gboolean _active;
	SugarShellService* _shell;
	SugarActivityService* _activity;
};

struct _SugarShellService {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SugarShellServicePrivate * priv;
	DBusGConnection* connection;
	DBusGProxy* object;
};

struct _SugarShellServiceClass {
	GTypeClass parent_class;
	void (*finalize) (SugarShellService *self);
};

struct _SugarActivityService {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SugarActivityServicePrivate * priv;
	DBusGConnection* connection;
	SugarActivityServiceServer* object;
};

struct _SugarActivityServiceClass {
	GTypeClass parent_class;
	void (*finalize) (SugarActivityService *self);
};

typedef void (*SugarActivityServiceSetActive) (gboolean active, void* user_data);
struct _SugarActivityServiceServer {
	GObject parent_instance;
	SugarActivityServiceServerPrivate * priv;
	SugarActivityServiceSetActive set_active_cb;
	gpointer set_active_cb_target;
	GDestroyNotify set_active_cb_target_destroy_notify;
};

struct _SugarActivityServiceServerClass {
	GObjectClass parent_class;
};


static gpointer sugar_shell_parent_class = NULL;

gpointer sugar_shell_service_ref (gpointer instance);
void sugar_shell_service_unref (gpointer instance);
GParamSpec* sugar_param_spec_shell_service (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sugar_value_set_shell_service (GValue* value, gpointer v_object);
void sugar_value_take_shell_service (GValue* value, gpointer v_object);
gpointer sugar_value_get_shell_service (const GValue* value);
GType sugar_shell_service_get_type (void) G_GNUC_CONST;
gpointer sugar_activity_service_ref (gpointer instance);
void sugar_activity_service_unref (gpointer instance);
GParamSpec* sugar_param_spec_activity_service (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sugar_value_set_activity_service (GValue* value, gpointer v_object);
void sugar_value_take_activity_service (GValue* value, gpointer v_object);
gpointer sugar_value_get_activity_service (const GValue* value);
GType sugar_activity_service_get_type (void) G_GNUC_CONST;
#define SUGAR_SHELL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_SHELL, SugarShellPrivate))
enum  {
	SUGAR_SHELL_DUMMY_PROPERTY,
	SUGAR_SHELL_ACTIVE
};
static gchar* _dynamic_GetBundlePath1 (DBusGProxy* self, const gchar* param1, GError** error);
static void _sugar_shell_set_active_cb (SugarShell* self, gboolean active);
static void sugar_shell_set_active (SugarShell* self, gboolean value);
static GObject * sugar_shell_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
SugarShellService* sugar_shell_service_instance (GError** error);
SugarActivityService* sugar_activity_service_new (GError** error);
SugarActivityService* sugar_activity_service_construct (GType object_type, GError** error);
GType sugar_activity_service_server_get_type (void) G_GNUC_CONST;
static void __sugar_shell_set_active_cb_sugar_activity_service_set_active (gboolean active, gpointer self);
static void sugar_shell_finalize (GObject* obj);
static void _vala_sugar_shell_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_shell_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Get activity info by bundle_id
     */
static gchar* _dynamic_GetBundlePath1 (DBusGProxy* self, const gchar* param1, GError** error) {
	gchar* result;
	dbus_g_proxy_call (self, "GetBundlePath", error, G_TYPE_STRING, param1, G_TYPE_INVALID, G_TYPE_STRING, &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


gboolean sugar_shell_get_activity (SugarShell* self, const gchar* bundle_id, SugarActivityInfo* _result_) {
	SugarActivityInfo _result = {0};
	gboolean result = FALSE;
	gchar* bundle_path = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	SugarActivityInfo _tmp4_ = {0};
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bundle_id != NULL, FALSE);
	if (self->priv->_shell == NULL) {
		result = FALSE;
		if (_result_) {
			*_result_ = _result;
		} else {
			sugar_activity_info_destroy (&_result);
		}
		return result;
	}
	_tmp0_ = _dynamic_GetBundlePath1 (self->priv->_shell->object, bundle_id, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	_g_free0 (bundle_path);
	bundle_path = _tmp1_;
	goto __finally0;
	__catch0_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("shell.vala:57: Cannot GetBundlePath from the shell for %s: %s", bundle_id, _error_->message);
		result = FALSE;
		_g_error_free0 (_error_);
		_g_free0 (bundle_path);
		if (_result_) {
			*_result_ = _result;
		} else {
			sugar_activity_info_destroy (&_result);
		}
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_free0 (bundle_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (bundle_path == NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar _tmp3_;
		_tmp3_ = string_get (bundle_path, (glong) 0);
		_tmp2_ = _tmp3_ == '\0';
	}
	if (_tmp2_) {
		g_debug ("shell.vala:63: Cannot find activity with bundle_id '%s'", bundle_id);
		result = FALSE;
		_g_free0 (bundle_path);
		if (_result_) {
			*_result_ = _result;
		} else {
			sugar_activity_info_destroy (&_result);
		}
		return result;
	}
	_tmp5_ = sugar_activity_info_get (bundle_path, &_tmp4_);
	sugar_activity_info_destroy (&_result);
	_result = _tmp4_;
	result = _tmp5_;
	_g_free0 (bundle_path);
	if (_result_) {
		*_result_ = _result;
	} else {
		sugar_activity_info_destroy (&_result);
	}
	return result;
}


/**
     * Get activity info by bundle_id
     */
static void _sugar_shell_set_active_cb (SugarShell* self, gboolean active) {
	g_return_if_fail (self != NULL);
	sugar_shell_set_active (self, active);
}


SugarShell* sugar_shell_construct (GType object_type) {
	SugarShell * self = NULL;
	self = (SugarShell*) g_object_new (object_type, NULL);
	return self;
}


SugarShell* sugar_shell_new (void) {
	return sugar_shell_construct (SUGAR_TYPE_SHELL);
}


gboolean sugar_shell_get_active (SugarShell* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}


static void sugar_shell_set_active (SugarShell* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	g_object_notify ((GObject *) self, "active");
}


static void __sugar_shell_set_active_cb_sugar_activity_service_set_active (gboolean active, gpointer self) {
	_sugar_shell_set_active_cb (self, active);
}


static GObject * sugar_shell_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarShell * self;
	SugarShellService* _tmp0_ = NULL;
	SugarShellService* _tmp1_;
	SugarActivityService* _tmp2_ = NULL;
	SugarActivityService* _tmp3_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (sugar_shell_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_SHELL (obj);
	_tmp0_ = sugar_shell_service_instance (&_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	_sugar_shell_service_unref0 (self->priv->_shell);
	self->priv->_shell = _tmp1_;
	goto __finally1;
	__catch1_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("shell.vala:34: Cannot connecto to shell: %s", _error_->message);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp2_ = sugar_activity_service_new (&_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	_sugar_activity_service_unref0 (self->priv->_activity);
	self->priv->_activity = _tmp3_;
	(self->priv->_activity->object->set_active_cb_target_destroy_notify == NULL) ? NULL : (self->priv->_activity->object->set_active_cb_target_destroy_notify (self->priv->_activity->object->set_active_cb_target), NULL);
	self->priv->_activity->object->set_active_cb = NULL;
	self->priv->_activity->object->set_active_cb_target = NULL;
	self->priv->_activity->object->set_active_cb_target_destroy_notify = NULL;
	self->priv->_activity->object->set_active_cb = __sugar_shell_set_active_cb_sugar_activity_service_set_active;
	self->priv->_activity->object->set_active_cb_target = g_object_ref (self);
	self->priv->_activity->object->set_active_cb_target_destroy_notify = g_object_unref;
	goto __finally2;
	__catch2_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("shell.vala:41: Cannot create activity DBus service: %s", _error_->message);
		_g_error_free0 (_error_);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void sugar_shell_class_init (SugarShellClass * klass) {
	sugar_shell_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarShellPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_shell_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_shell_set_property;
	G_OBJECT_CLASS (klass)->constructor = sugar_shell_constructor;
	G_OBJECT_CLASS (klass)->finalize = sugar_shell_finalize;
	/**
	     * Is activity active
	     *
	     * Activity is active when it is selected in activities list in the shell.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_SHELL_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void sugar_shell_instance_init (SugarShell * self) {
	self->priv = SUGAR_SHELL_GET_PRIVATE (self);
	self->priv->_active = FALSE;
}


static void sugar_shell_finalize (GObject* obj) {
	SugarShell * self;
	self = SUGAR_SHELL (obj);
	_sugar_shell_service_unref0 (self->priv->_shell);
	_sugar_activity_service_unref0 (self->priv->_activity);
	G_OBJECT_CLASS (sugar_shell_parent_class)->finalize (obj);
}


/**
 * Hight-level interface to interact with sugar shell process
 */
GType sugar_shell_get_type (void) {
	static volatile gsize sugar_shell_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_shell_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarShellClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_shell_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarShell), 0, (GInstanceInitFunc) sugar_shell_instance_init, NULL };
		GType sugar_shell_type_id;
		sugar_shell_type_id = g_type_register_static (G_TYPE_OBJECT, "SugarShell", &g_define_type_info, 0);
		g_once_init_leave (&sugar_shell_type_id__volatile, sugar_shell_type_id);
	}
	return sugar_shell_type_id__volatile;
}


static void _vala_sugar_shell_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarShell * self;
	self = SUGAR_SHELL (object);
	switch (property_id) {
		case SUGAR_SHELL_ACTIVE:
		g_value_set_boolean (value, sugar_shell_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_shell_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarShell * self;
	self = SUGAR_SHELL (object);
	switch (property_id) {
		case SUGAR_SHELL_ACTIVE:
		sugar_shell_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



