/* backend.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * High level interface to abstract various Telepathy API or CM implementations
 */
private abstract class Sugar.Collab.Backend {
    public delegate void StateFallback (ShareScope scope);
    public delegate void StateChanged (bool success);
    public delegate void ChannelStatus (Channel channel, bool online);
    public delegate void OfferFailed (string bus_name);

    public bool initiator = false;
    public string title;
    public StateFallback fallback_cb;
    public StateChanged scope_changed_cb;
    public ChannelStatus channel_status_cb;
    public OfferFailed offer_failed;

    public abstract bool connect () throws DBus.Error;
    public abstract void set_scope (ShareScope scope);
    public abstract void on_title_changing ();
    public abstract void offer_channel (string bus_name);
    public abstract bool is_shared ();
}
