/* icon.c generated by valac 0.12.1, the Vala compiler
 * generated from icon.vala, do not modify */

/* icon.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Port from original sugar-toolkit project.
 * File:   src/sugar/graphics/icon.py
 * Commit: 4a4ea538cacd740f8e32f625d400e26ab590daa0
 *
 * Copyright (C) 2006-2007 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/gui.h"
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <polyol/env.h>
#include <librsvg/rsvg.h>
#include <librsvg/rsvg-cairo.h>
#include <gdk-pixbuf/gdk-pixdata.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sugar_lru_unref0(var) ((var == NULL) ? NULL : (var = (sugar_lru_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_mapped_file_free0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SugarIconPrivate {
	SugarIconAttr _attr;
	gchar* _file;
	guint _pulse_hid;
	gdouble _pulse_phase;
};

struct _Block4Data {
	int _ref_count_;
	gint dst_width;
	gint dst_height;
};


static gpointer sugar_icon_parent_class = NULL;
extern SugarLRU* sugar__surface_cache;
SugarLRU* sugar__surface_cache = NULL;

#define SUGAR_ICON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_ICON, SugarIconPrivate))
enum  {
	SUGAR_ICON_DUMMY_PROPERTY,
	SUGAR_ICON_FILE,
	SUGAR_ICON_FILL_COLOR,
	SUGAR_ICON_STROKE_COLOR,
	SUGAR_ICON_XO_COLOR,
	SUGAR_ICON_WIDTH,
	SUGAR_ICON_HEIGHT,
	SUGAR_ICON_PIXEL_SIZE,
	SUGAR_ICON_ICON_SIZE,
	SUGAR_ICON_PULSING
};
#define SUGAR_ICON__PULSE_INTERVAL 100
#define SUGAR_ICON__PULSE_STEP (G_PI / 10.0)
static void sugar_icon_real_dispose (GObject* base);
static void sugar_icon_real_size_request (GtkWidget* base, GtkRequisition* requisition);
static gboolean sugar_icon_real_expose_event (GtkWidget* base, GdkEventExpose* event);
static gboolean _sugar_icon_pulse_cb (SugarIcon* self);
static gboolean __sugar_icon_pulse_cb_gsource_func (gpointer self);
static void sugar_icon_finalize (GObject* obj);
static void _vala_sugar_icon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_icon_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static gboolean _sugar_color_equal (const SugarColor* s1, const SugarColor* s2);
RsvgHandle* _sugar_icon_load_svg (SugarIconAttr* attr);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static void _lambda4_ (gint width, gint height, Block4Data* _data4_);
static void __lambda4__rsvg_size_func (gint* width, gint* height, gpointer self);
#define SUGAR__FILL_TAG "<!ENTITY fill_color \""
#define SUGAR__STROKE_TAG "<!ENTITY stroke_color \""


static void sugar_icon_real_dispose (GObject* base) {
	SugarIcon * self;
	self = (SugarIcon*) base;
	sugar_icon_set_pulsing (self, FALSE);
	G_OBJECT_CLASS (sugar_icon_parent_class)->dispose ((GObject*) GTK_IMAGE (self));
}


static void sugar_icon_real_size_request (GtkWidget* base, GtkRequisition* requisition) {
	SugarIcon * self;
	GtkRequisition _requisition = {0};
	GtkRequisition _tmp0_ = {0};
	gint _tmp1_;
	gint _tmp3_;
	self = (SugarIcon*) base;
	GTK_WIDGET_CLASS (sugar_icon_parent_class)->size_request ((GtkWidget*) GTK_IMAGE (self), &_tmp0_);
	_requisition = _tmp0_;
	_tmp1_ = sugar_icon_get_width (self);
	if (_tmp1_ > 0) {
		gint _tmp2_;
		_tmp2_ = sugar_icon_get_width (self);
		_requisition.width = _tmp2_;
	}
	_tmp3_ = sugar_icon_get_height (self);
	if (_tmp3_ > 0) {
		gint _tmp4_;
		_tmp4_ = sugar_icon_get_height (self);
		_requisition.height = _tmp4_;
	}
	if (requisition) {
		*requisition = _requisition;
	}
}


static gboolean sugar_icon_real_expose_event (GtkWidget* base, GdkEventExpose* event) {
	SugarIcon * self;
	gboolean result = FALSE;
	SugarIconAttr _tmp0_;
	SugarIconAttr _tmp1_ = {0};
	SugarIconAttr attr;
	gboolean cache;
	gboolean _tmp2_ = FALSE;
	cairo_surface_t* _tmp3_ = NULL;
	cairo_surface_t* surface;
	gfloat _tmp4_ = 0.0F;
	GtkTextDirection _tmp5_;
	gfloat xalign_;
	gint _tmp8_;
	gdouble _tmp9_;
	gint x;
	gint _tmp10_;
	gfloat _tmp11_;
	gdouble _tmp12_;
	gint y;
	cairo_t* _tmp13_ = NULL;
	cairo_t* cairo_context;
	gboolean _tmp14_;
	self = (SugarIcon*) base;
	GTK_WIDGET_CLASS (sugar_icon_parent_class)->expose_event ((GtkWidget*) GTK_IMAGE (self), event);
	sugar_icon_attr_copy (&self->priv->_attr, &_tmp1_);
	_tmp0_ = _tmp1_;
	attr = _tmp0_;
	cache = TRUE;
	if (attr.width <= 0) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = attr.height <= 0;
	}
	if (_tmp2_) {
		attr.width = ((GtkWidget*) self)->allocation.width;
		attr.height = ((GtkWidget*) self)->allocation.height;
		cache = FALSE;
	}
	_tmp3_ = sugar_icon_get_surface (&attr, cache);
	surface = _tmp3_;
	if (surface == NULL) {
		result = FALSE;
		_cairo_surface_destroy0 (surface);
		sugar_icon_attr_destroy (&attr);
		return result;
	}
	_tmp5_ = gtk_widget_get_direction ((GtkWidget*) self);
	if (_tmp5_ != GTK_TEXT_DIR_LTR) {
		gfloat _tmp6_;
		g_object_get ((GtkMisc*) self, "xalign", &_tmp6_, NULL);
		_tmp4_ = _tmp6_;
	} else {
		gfloat _tmp7_;
		g_object_get ((GtkMisc*) self, "xalign", &_tmp7_, NULL);
		_tmp4_ = 1.0f - _tmp7_;
	}
	xalign_ = _tmp4_;
	g_object_get ((GtkMisc*) self, "xpad", &_tmp8_, NULL);
	_tmp9_ = floor ((gdouble) ((((GtkWidget*) self)->allocation.x + _tmp8_) + ((((GtkWidget*) self)->allocation.width - attr.width) * xalign_)));
	x = (gint) _tmp9_;
	g_object_get ((GtkMisc*) self, "ypad", &_tmp10_, NULL);
	g_object_get ((GtkMisc*) self, "yalign", &_tmp11_, NULL);
	_tmp12_ = floor ((gdouble) ((((GtkWidget*) self)->allocation.y + _tmp10_) + ((((GtkWidget*) self)->allocation.height - attr.height) * _tmp11_)));
	y = (gint) _tmp12_;
	_tmp13_ = gdk_cairo_create ((GdkDrawable*) ((GtkWidget*) self)->window);
	cairo_context = _tmp13_;
	cairo_set_source_surface (cairo_context, surface, (gdouble) x, (gdouble) y);
	_tmp14_ = sugar_icon_get_pulsing (self);
	if (_tmp14_) {
		gdouble _tmp15_;
		gdouble alpha;
		_tmp15_ = sin (self->priv->_pulse_phase);
		alpha = 0.2 + ((_tmp15_ + 1.0) / 2.5);
		cairo_paint_with_alpha (cairo_context, alpha);
	} else {
		GtkStateType _tmp16_;
		_tmp16_ = gtk_widget_get_state ((GtkWidget*) self);
		if (_tmp16_ == GTK_STATE_INSENSITIVE) {
			cairo_paint_with_alpha (cairo_context, 0.25);
		} else {
			cairo_paint (cairo_context);
		}
	}
	result = FALSE;
	_cairo_destroy0 (cairo_context);
	_cairo_surface_destroy0 (surface);
	sugar_icon_attr_destroy (&attr);
	return result;
}


static gboolean _sugar_icon_pulse_cb (SugarIcon* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->_pulse_phase = self->priv->_pulse_phase + SUGAR_ICON__PULSE_STEP;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = TRUE;
	return result;
}


SugarIcon* sugar_icon_construct (GType object_type) {
	SugarIcon * self = NULL;
	self = (SugarIcon*) g_object_new (object_type, NULL);
	return self;
}


SugarIcon* sugar_icon_new (void) {
	return sugar_icon_construct (SUGAR_TYPE_ICON);
}


const gchar* sugar_icon_get_file (SugarIcon* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_file;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


void sugar_icon_set_file (SugarIcon* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_icon_get_file (self);
	if (g_strcmp0 (value, _tmp0_) == 0) {
		return;
	}
	_tmp1_ = g_strdup (value);
	_g_free0 (self->priv->_file);
	self->priv->_file = _tmp1_;
	_tmp2_ = string_get (value, (glong) 0);
	if (_tmp2_ == '/') {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = sugar_icon_get_file (self);
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->priv->_attr.file_name);
		self->priv->_attr.file_name = _tmp4_;
	} else {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = sugar_icon_get_file (self);
		sugar_icon_attr_set_icon_name (&self->priv->_attr, _tmp5_);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "file");
}


void sugar_icon_get_fill_color (SugarIcon* self, SugarColor* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_attr.fill_color;
	return;
}


void sugar_icon_set_fill_color (SugarIcon* self, SugarColor* value) {
	g_return_if_fail (self != NULL);
	self->priv->_attr.fill_color = *value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "fill-color");
}


void sugar_icon_get_stroke_color (SugarIcon* self, SugarColor* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_attr.stroke_color;
	return;
}


void sugar_icon_set_stroke_color (SugarIcon* self, SugarColor* value) {
	g_return_if_fail (self != NULL);
	self->priv->_attr.stroke_color = *value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "stroke-color");
}


void sugar_icon_set_xo_color (SugarIcon* self, SugarXoColor* value) {
	g_return_if_fail (self != NULL);
	sugar_icon_attr_set_xo_color (&self->priv->_attr, value);
	g_object_notify ((GObject *) self, "xo-color");
}


gint sugar_icon_get_width (SugarIcon* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_attr.width;
	return result;
}


gint sugar_icon_get_height (SugarIcon* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_attr.height;
	return result;
}


void sugar_icon_set_pixel_size (SugarIcon* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_attr.height = value;
	self->priv->_attr.width = self->priv->_attr.height;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "pixel-size");
}


void sugar_icon_set_icon_size (SugarIcon* self, GtkIconSize value) {
	g_return_if_fail (self != NULL);
	sugar_icon_attr_set_icon_size (&self->priv->_attr, value);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "icon-size");
}


gboolean sugar_icon_get_pulsing (SugarIcon* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pulse_hid != 0;
	return result;
}


static gboolean __sugar_icon_pulse_cb_gsource_func (gpointer self) {
	gboolean result;
	result = _sugar_icon_pulse_cb (self);
	return result;
}


void sugar_icon_set_pulsing (SugarIcon* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_icon_get_pulsing (self);
	if (value == _tmp0_) {
		return;
	}
	if (value) {
		guint _tmp1_;
		self->priv->_pulse_phase = 0.0;
		_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) SUGAR_ICON__PULSE_INTERVAL, __sugar_icon_pulse_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->_pulse_hid = _tmp1_;
	} else {
		g_source_remove (self->priv->_pulse_hid);
		self->priv->_pulse_hid = (guint) 0;
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	g_object_notify ((GObject *) self, "pulsing");
}


static void sugar_icon_class_init (SugarIconClass * klass) {
	sugar_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarIconPrivate));
	G_OBJECT_CLASS (klass)->dispose = sugar_icon_real_dispose;
	GTK_WIDGET_CLASS (klass)->size_request = sugar_icon_real_size_request;
	GTK_WIDGET_CLASS (klass)->expose_event = sugar_icon_real_expose_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_icon_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_icon_set_property;
	G_OBJECT_CLASS (klass)->finalize = sugar_icon_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ICON_FILE, g_param_spec_string ("file", "file", "file", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ICON_FILL_COLOR, g_param_spec_boxed ("fill-color", "fill-color", "fill-color", SUGAR_TYPE_COLOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ICON_STROKE_COLOR, g_param_spec_boxed ("stroke-color", "stroke-color", "stroke-color", SUGAR_TYPE_COLOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ICON_XO_COLOR, g_param_spec_boxed ("xo-color", "xo-color", "xo-color", SUGAR_TYPE_XO_COLOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ICON_WIDTH, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ICON_HEIGHT, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ICON_PIXEL_SIZE, g_param_spec_int ("pixel-size", "pixel-size", "pixel-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ICON_ICON_SIZE, g_param_spec_enum ("icon-size", "icon-size", "icon-size", GTK_TYPE_ICON_SIZE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_ICON_PULSING, g_param_spec_boolean ("pulsing", "pulsing", "pulsing", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void sugar_icon_instance_init (SugarIcon * self) {
	self->priv = SUGAR_ICON_GET_PRIVATE (self);
}


static void sugar_icon_finalize (GObject* obj) {
	SugarIcon * self;
	self = SUGAR_ICON (obj);
	sugar_icon_attr_destroy (&self->priv->_attr);
	_g_free0 (self->priv->_file);
	G_OBJECT_CLASS (sugar_icon_parent_class)->finalize (obj);
}


GType sugar_icon_get_type (void) {
	static volatile gsize sugar_icon_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_icon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarIcon), 0, (GInstanceInitFunc) sugar_icon_instance_init, NULL };
		GType sugar_icon_type_id;
		sugar_icon_type_id = g_type_register_static (GTK_TYPE_IMAGE, "SugarIcon", &g_define_type_info, 0);
		g_once_init_leave (&sugar_icon_type_id__volatile, sugar_icon_type_id);
	}
	return sugar_icon_type_id__volatile;
}


static void _vala_sugar_icon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarIcon * self;
	SugarColor boxed0;
	SugarColor boxed1;
	self = SUGAR_ICON (object);
	switch (property_id) {
		case SUGAR_ICON_FILE:
		g_value_set_string (value, sugar_icon_get_file (self));
		break;
		case SUGAR_ICON_FILL_COLOR:
		sugar_icon_get_fill_color (self, &boxed0);
		g_value_set_boxed (value, &boxed0);
		break;
		case SUGAR_ICON_STROKE_COLOR:
		sugar_icon_get_stroke_color (self, &boxed1);
		g_value_set_boxed (value, &boxed1);
		break;
		case SUGAR_ICON_WIDTH:
		g_value_set_int (value, sugar_icon_get_width (self));
		break;
		case SUGAR_ICON_HEIGHT:
		g_value_set_int (value, sugar_icon_get_height (self));
		break;
		case SUGAR_ICON_PULSING:
		g_value_set_boolean (value, sugar_icon_get_pulsing (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_icon_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarIcon * self;
	self = SUGAR_ICON (object);
	switch (property_id) {
		case SUGAR_ICON_FILE:
		sugar_icon_set_file (self, g_value_get_string (value));
		break;
		case SUGAR_ICON_FILL_COLOR:
		sugar_icon_set_fill_color (self, g_value_get_boxed (value));
		break;
		case SUGAR_ICON_STROKE_COLOR:
		sugar_icon_set_stroke_color (self, g_value_get_boxed (value));
		break;
		case SUGAR_ICON_XO_COLOR:
		sugar_icon_set_xo_color (self, g_value_get_boxed (value));
		break;
		case SUGAR_ICON_PIXEL_SIZE:
		sugar_icon_set_pixel_size (self, g_value_get_int (value));
		break;
		case SUGAR_ICON_ICON_SIZE:
		sugar_icon_set_icon_size (self, g_value_get_enum (value));
		break;
		case SUGAR_ICON_PULSING:
		sugar_icon_set_pulsing (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


guint sugar_icon_attr_hash (SugarIconAttr* x) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	guint32 _tmp2_;
	guint32 _tmp3_;
	if ((*x).file_name == NULL) {
		_tmp0_ = (guint) 0;
	} else {
		guint _tmp1_;
		_tmp1_ = g_str_hash ((*x).file_name);
		_tmp0_ = _tmp1_;
	}
	_tmp2_ = sugar_color_get_integer (&(*x).fill_color);
	_tmp3_ = sugar_color_get_integer (&(*x).stroke_color);
	result = (((_tmp0_ + _tmp2_) + _tmp3_) + (*x).width) + (*x).height;
	return result;
}


static gboolean _sugar_color_equal (const SugarColor* s1, const SugarColor* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->alpha != s2->alpha) {
		return FALSE;
	}
	if (s1->red != s2->red) {
		return FALSE;
	}
	if (s1->green != s2->green) {
		return FALSE;
	}
	if (s1->blue != s2->blue) {
		return FALSE;
	}
	return TRUE;
}


gboolean sugar_icon_attr_cmp (SugarIconAttr* x, SugarIconAttr* y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	if (g_strcmp0 ((*x).file_name, (*y).file_name) == 0) {
		_tmp3_ = _sugar_color_equal (&(*x).fill_color, &(*y).fill_color) == TRUE;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = _sugar_color_equal (&(*x).stroke_color, &(*y).stroke_color) == TRUE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = (*x).width == (*y).width;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = (*x).height == (*y).height;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


void sugar_icon_attr_set_xo_color (SugarIconAttr* self, SugarXoColor* value) {
	g_return_if_fail (self != NULL);
	(*self).fill_color = (*value).fill;
	(*self).stroke_color = (*value).stroke;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void sugar_icon_attr_set_icon_name (SugarIconAttr* self, const gchar* value) {
	GtkIconTheme* _tmp0_ = NULL;
	GtkIconTheme* _tmp1_;
	GtkIconTheme* theme;
	GtkIconInfo* _tmp2_ = NULL;
	GtkIconInfo* info;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	theme = _tmp1_;
	_tmp2_ = gtk_icon_theme_lookup_icon (theme, value, (*self).width, 0);
	info = _tmp2_;
	if (info != NULL) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = gtk_icon_info_get_filename (info);
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 ((*self).file_name);
		(*self).file_name = _tmp4_;
	} else {
		g_warning ("icon.vala:214: No icon with the name '%s' was found", value);
		_g_free0 ((*self).file_name);
		(*self).file_name = NULL;
	}
	_gtk_icon_info_free0 (info);
	_g_object_unref0 (theme);
}


void sugar_icon_attr_set_icon_size (SugarIconAttr* self, GtkIconSize value) {
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	gtk_icon_size_lookup (value, &_tmp0_, &_tmp1_);
	(*self).width = _tmp0_;
	(*self).height = _tmp1_;
}


void sugar_icon_attr_copy (const SugarIconAttr* self, SugarIconAttr* dest) {
	dest->file_name = g_strdup (self->file_name);
	dest->fill_color = self->fill_color;
	dest->stroke_color = self->stroke_color;
	dest->width = self->width;
	dest->height = self->height;
}


void sugar_icon_attr_destroy (SugarIconAttr* self) {
	_g_free0 ((*self).file_name);
}


SugarIconAttr* sugar_icon_attr_dup (const SugarIconAttr* self) {
	SugarIconAttr* dup;
	dup = g_new0 (SugarIconAttr, 1);
	sugar_icon_attr_copy (self, dup);
	return dup;
}


void sugar_icon_attr_free (SugarIconAttr* self) {
	sugar_icon_attr_destroy (self);
	g_free (self);
}


GType sugar_icon_attr_get_type (void) {
	static volatile gsize sugar_icon_attr_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_icon_attr_type_id__volatile)) {
		GType sugar_icon_attr_type_id;
		sugar_icon_attr_type_id = g_boxed_type_register_static ("SugarIconAttr", (GBoxedCopyFunc) sugar_icon_attr_dup, (GBoxedFreeFunc) sugar_icon_attr_free);
		g_once_init_leave (&sugar_icon_attr_type_id__volatile, sugar_icon_attr_type_id);
	}
	return sugar_icon_attr_type_id__volatile;
}


void sugar_icon_cache_reset (void) {
	_sugar_lru_unref0 (sugar__surface_cache);
	sugar__surface_cache = NULL;
}


/**
     * Get cairo surface for sugar icon.
     *
     * @param attr  icon attributes
     * @param cache cache generated surface
     *
     * @return surface or null
     */
cairo_surface_t* sugar_icon_get_surface (SugarIconAttr* attr, gboolean cache) {
	cairo_surface_t* result = NULL;
	gpointer _tmp1_ = NULL;
	cairo_surface_t* surface;
	RsvgHandle* _tmp2_ = NULL;
	RsvgHandle* handle;
	gint _tmp3_ = 0;
	gint dst_width;
	gint _tmp5_ = 0;
	gint dst_height;
	cairo_surface_t* _tmp7_ = NULL;
	cairo_t* _tmp8_ = NULL;
	cairo_t* context;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_;
	if ((*attr).file_name == NULL) {
		result = NULL;
		return result;
	}
	if (sugar__surface_cache == NULL) {
		SugarLRU* _tmp0_ = NULL;
		_tmp0_ = sugar_lru_new (SUGAR_TYPE_ICON_ATTR, (GBoxedCopyFunc) sugar_icon_attr_dup, sugar_icon_attr_free, G_TYPE_POINTER, (GBoxedCopyFunc) cairo_surface_reference, cairo_surface_destroy, 50, (GHashFunc) sugar_icon_attr_hash, (GEqualFunc) sugar_icon_attr_cmp);
		_sugar_lru_unref0 (sugar__surface_cache);
		sugar__surface_cache = _tmp0_;
	}
	_tmp1_ = sugar_lru_get (sugar__surface_cache, attr);
	surface = (cairo_surface_t*) _tmp1_;
	if (surface != NULL) {
		result = surface;
		return result;
	}
	_tmp2_ = _sugar_icon_load_svg (attr);
	handle = _tmp2_;
	if (handle == NULL) {
		result = NULL;
		_g_object_unref0 (handle);
		_cairo_surface_destroy0 (surface);
		return result;
	}
	if ((*attr).width > 0) {
		_tmp3_ = (*attr).width;
	} else {
		gint _tmp4_;
		g_object_get (handle, "width", &_tmp4_, NULL);
		_tmp3_ = _tmp4_;
	}
	dst_width = _tmp3_;
	if ((*attr).height > 0) {
		_tmp5_ = (*attr).height;
	} else {
		gint _tmp6_;
		g_object_get (handle, "height", &_tmp6_, NULL);
		_tmp5_ = _tmp6_;
	}
	dst_height = _tmp5_;
	_tmp7_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, dst_width, dst_height);
	_cairo_surface_destroy0 (surface);
	surface = _tmp7_;
	_tmp8_ = cairo_create (surface);
	context = _tmp8_;
	g_object_get (handle, "width", &_tmp10_, NULL);
	if (dst_width != _tmp10_) {
		_tmp9_ = TRUE;
	} else {
		gint _tmp11_;
		g_object_get (handle, "height", &_tmp11_, NULL);
		_tmp9_ = dst_height != _tmp11_;
	}
	if (_tmp9_) {
		gint _tmp12_;
		gint _tmp13_;
		g_object_get (handle, "width", &_tmp12_, NULL);
		g_object_get (handle, "height", &_tmp13_, NULL);
		cairo_scale (context, (gdouble) (((gfloat) dst_width) / _tmp12_), (gdouble) (((gfloat) dst_height) / _tmp13_));
	}
	rsvg_handle_render_cairo (handle, context);
	if (cache) {
		sugar_lru_set (sugar__surface_cache, attr, surface);
	}
	result = surface;
	_cairo_destroy0 (context);
	_g_object_unref0 (handle);
	return result;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		g_slice_free (Block4Data, _data4_);
	}
}


static void _lambda4_ (gint width, gint height, Block4Data* _data4_) {
	width = _data4_->dst_width;
	height = _data4_->dst_height;
}


static void __lambda4__rsvg_size_func (gint* width, gint* height, gpointer self) {
	_lambda4_ (width, height, self);
}


GdkPixbuf* sugar_icon_get_pixbuf (SugarIconAttr* attr) {
	GdkPixbuf* result = NULL;
	Block4Data* _data4_;
	RsvgHandle* _tmp0_ = NULL;
	RsvgHandle* handle;
	gint _tmp1_ = 0;
	gint _tmp3_ = 0;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_;
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	if ((*attr).file_name == NULL) {
		result = NULL;
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return result;
	}
	_tmp0_ = _sugar_icon_load_svg (attr);
	handle = _tmp0_;
	if (handle == NULL) {
		result = NULL;
		_g_object_unref0 (handle);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return result;
	}
	if ((*attr).width > 0) {
		_tmp1_ = (*attr).width;
	} else {
		gint _tmp2_;
		g_object_get (handle, "width", &_tmp2_, NULL);
		_tmp1_ = _tmp2_;
	}
	_data4_->dst_width = _tmp1_;
	if ((*attr).height > 0) {
		_tmp3_ = (*attr).height;
	} else {
		gint _tmp4_;
		g_object_get (handle, "height", &_tmp4_, NULL);
		_tmp3_ = _tmp4_;
	}
	_data4_->dst_height = _tmp3_;
	rsvg_handle_set_size_callback (handle, __lambda4__rsvg_size_func, block4_data_ref (_data4_), block4_data_unref);
	_tmp5_ = rsvg_handle_get_pixbuf (handle);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	result = _tmp6_;
	_g_object_unref0 (handle);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) (-1), c);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


RsvgHandle* _sugar_icon_load_svg (SugarIconAttr* attr) {
	RsvgHandle* result = NULL;
	GMappedFile* src;
	GString* dst;
	GMappedFile* _tmp0_ = NULL;
	GMappedFile* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* pos;
	gchar* _tmp3_ = NULL;
	gsize _tmp4_;
	gchar* end;
	gchar* _tmp5_ = NULL;
	gchar* _tmp7_;
	gchar* fill;
	gchar* _tmp8_ = NULL;
	gchar* _tmp10_;
	gchar* stroke;
	gboolean _tmp11_ = FALSE;
	guchar* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	gsize data_len = 0UL;
	gchar* _tmp32_ = NULL;
	RsvgHandle* _tmp38_ = NULL;
	RsvgHandle* _tmp39_;
	GError * _inner_error_ = NULL;
	src = NULL;
	dst = NULL;
	_tmp0_ = g_mapped_file_new ((*attr).file_name, FALSE, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch0_g_file_error;
		}
		_g_string_free0 (dst);
		_g_mapped_file_free0 (src);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_mapped_file_free0 (src);
	src = _tmp1_;
	goto __finally0;
	__catch0_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("icon.vala:313: Cannot load '%s' svg: %s", (*attr).file_name, e->message);
		result = NULL;
		_g_error_free0 (e);
		_g_string_free0 (dst);
		_g_mapped_file_free0 (src);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_string_free0 (dst);
		_g_mapped_file_free0 (src);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp2_ = g_mapped_file_get_contents (src);
	pos = _tmp2_;
	_tmp3_ = g_mapped_file_get_contents (src);
	_tmp4_ = g_mapped_file_get_length (src);
	end = _tmp3_ + _tmp4_;
	if ((*attr).fill_color.alpha > 0.0) {
		gchar* _tmp6_ = NULL;
		_tmp6_ = sugar_color_get_html (&(*attr).fill_color);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp6_;
	} else {
		_g_free0 (_tmp5_);
		_tmp5_ = NULL;
	}
	_tmp7_ = g_strdup (_tmp5_);
	fill = _tmp7_;
	if ((*attr).stroke_color.alpha > 0.0) {
		gchar* _tmp9_ = NULL;
		_tmp9_ = sugar_color_get_html (&(*attr).stroke_color);
		_g_free0 (_tmp8_);
		_tmp8_ = _tmp9_;
	} else {
		_g_free0 (_tmp8_);
		_tmp8_ = NULL;
	}
	_tmp10_ = g_strdup (_tmp8_);
	stroke = _tmp10_;
	if (fill != NULL) {
		_tmp11_ = TRUE;
	} else {
		_tmp11_ = stroke != NULL;
	}
	if (_tmp11_) {
		{
			gchar* i;
			i = pos;
			{
				gboolean _tmp12_;
				_tmp12_ = TRUE;
				while (TRUE) {
					const gchar* _tmp13_ = NULL;
					gboolean _tmp14_;
					const gchar* color;
					gboolean _tmp15_ = FALSE;
					if (!_tmp12_) {
						i++;
					}
					_tmp12_ = FALSE;
					if (!(i < end)) {
						break;
					}
					_tmp13_ = sugar_to_string (i);
					_tmp14_ = g_str_has_prefix (_tmp13_, "<svg");
					if (_tmp14_) {
						break;
					}
					color = NULL;
					if (fill != NULL) {
						const gchar* _tmp16_ = NULL;
						gboolean _tmp17_;
						_tmp16_ = sugar_to_string (i);
						_tmp17_ = g_str_has_prefix (_tmp16_, SUGAR__FILL_TAG);
						_tmp15_ = _tmp17_;
					} else {
						_tmp15_ = FALSE;
					}
					if (_tmp15_) {
						gint _tmp18_;
						color = fill;
						_tmp18_ = strlen (SUGAR__FILL_TAG);
						i = i + _tmp18_;
					} else {
						gboolean _tmp19_ = FALSE;
						if (stroke != NULL) {
							const gchar* _tmp20_ = NULL;
							gboolean _tmp21_;
							_tmp20_ = sugar_to_string (i);
							_tmp21_ = g_str_has_prefix (_tmp20_, SUGAR__STROKE_TAG);
							_tmp19_ = _tmp21_;
						} else {
							_tmp19_ = FALSE;
						}
						if (_tmp19_) {
							gint _tmp22_;
							color = stroke;
							_tmp22_ = strlen (SUGAR__STROKE_TAG);
							i = i + _tmp22_;
						}
					}
					if (color != NULL) {
						const gchar* _tmp29_ = NULL;
						const gchar* _tmp30_ = NULL;
						gint _tmp31_;
						gint end_i;
						if (dst == NULL) {
							gint _tmp23_ = 0;
							gint _tmp25_ = 0;
							gsize _tmp27_;
							GString* _tmp28_ = NULL;
							if (fill == NULL) {
								_tmp23_ = 0;
							} else {
								gint _tmp24_;
								_tmp24_ = strlen (fill);
								_tmp23_ = _tmp24_;
							}
							if (stroke == NULL) {
								_tmp25_ = 0;
							} else {
								gint _tmp26_;
								_tmp26_ = strlen (stroke);
								_tmp25_ = _tmp26_;
							}
							_tmp27_ = g_mapped_file_get_length (src);
							_tmp28_ = g_string_sized_new ((_tmp27_ + _tmp23_) + _tmp25_);
							_g_string_free0 (dst);
							dst = _tmp28_;
						}
						_tmp29_ = sugar_to_string (pos);
						g_string_append_len (dst, _tmp29_, (gssize) (i - pos));
						g_string_append (dst, color);
						_tmp30_ = sugar_to_string (i);
						_tmp31_ = string_index_of_char (_tmp30_, (gunichar) '"', 0);
						end_i = _tmp31_;
						if (end_i < 0) {
							g_warning ("icon.vala:352: Wron svg file, cannot find second quotes");
							result = NULL;
							_g_free0 (stroke);
							_g_free0 (_tmp8_);
							_g_free0 (fill);
							_g_free0 (_tmp5_);
							_g_string_free0 (dst);
							_g_mapped_file_free0 (src);
							return result;
						}
						i = i + end_i;
						pos = i;
					}
				}
			}
		}
	}
	_tmp32_ = g_mapped_file_get_contents (src);
	if (pos == _tmp32_) {
		gchar* _tmp33_ = NULL;
		gint _tmp34_;
		guchar* _tmp35_ = NULL;
		gsize _tmp36_;
		_tmp33_ = g_mapped_file_get_contents (src);
		_tmp35_ = sugar_to_uchars (_tmp33_, &_tmp34_);
		data = _tmp35_;
		data_length1 = _tmp34_;
		_data_size_ = _tmp34_;
		_tmp36_ = g_mapped_file_get_length (src);
		data_len = _tmp36_;
	} else {
		const gchar* _tmp37_ = NULL;
		_tmp37_ = sugar_to_string (pos);
		g_string_append (dst, _tmp37_);
		data = (guchar*) dst->str;
		data_length1 = -1;
		_data_size_ = -1;
		data_len = (gsize) dst->len;
	}
	_tmp38_ = rsvg_handle_new_from_data (data, data_len, &_inner_error_);
	_tmp39_ = _tmp38_;
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	result = _tmp39_;
	_g_free0 (stroke);
	_g_free0 (_tmp8_);
	_g_free0 (fill);
	_g_free0 (_tmp5_);
	_g_string_free0 (dst);
	_g_mapped_file_free0 (src);
	return result;
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("icon.vala:377: Cannot parse '%s' svg: %s", (*attr).file_name, e->message);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (stroke);
		_g_free0 (_tmp8_);
		_g_free0 (fill);
		_g_free0 (_tmp5_);
		_g_string_free0 (dst);
		_g_mapped_file_free0 (src);
		return result;
	}
	__finally1:
	_g_free0 (stroke);
	_g_free0 (_tmp8_);
	_g_free0 (fill);
	_g_free0 (_tmp5_);
	_g_string_free0 (dst);
	_g_mapped_file_free0 (src);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}



